/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.gui.starlightforge;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.gui.starlightforge.EFItem;
import net.borisshoes.arcananovum.gui.starlightforge.EnhancedForgingGame;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3917;
import net.minecraft.class_5250;

public class EnhancedForgingGui
extends SimpleGui {
    private final StarlightForgeBlockEntity blockEntity;
    private final EnhancedForgingGame game;
    private final class_2371<class_1799> ingredients;
    private final class_2371<class_1799> remainders;
    private final class_1799 enhancedStack;
    private EFItem selectedItem = EFItem.NOVA;
    private long tickCount = 0L;
    private int endingAnim = -1;
    private boolean turnMode = false;
    private boolean cinematicMode = false;
    private boolean animated = false;
    private boolean completed = false;
    private boolean paid = false;
    private boolean fast = false;
    private boolean showCodes = false;

    public EnhancedForgingGui(class_3222 player, StarlightForgeBlockEntity blockEntity, class_1799 enhancedStack, class_2371<class_1799> ingredients, class_2371<class_1799> remainders) {
        super(class_3917.field_17327, player, false);
        this.blockEntity = blockEntity;
        this.enhancedStack = enhancedStack;
        this.ingredients = ingredients;
        this.remainders = remainders;
        this.game = new EnhancedForgingGame(blockEntity.getStartingValue(), blockEntity.getPlanetCount(), blockEntity.getStarCount(), blockEntity.getSeed());
    }

    public boolean onAnyClick(int index, ClickType type, class_1713 action) {
        boolean onBoard;
        boolean bl = onBoard = index % 9 < 7 && index < 54;
        if (this.animated || this.endingAnim != -1) {
            return true;
        }
        if (index == 8) {
            this.turnMode = !this.turnMode;
            this.buildGui();
        } else if (index == 26) {
            if (type.isRight) {
                this.selectedItem = EFItem.cycleItem(this.selectedItem, true);
                this.buildGui();
            } else if (type.isLeft) {
                this.selectedItem = EFItem.cycleItem(this.selectedItem, false);
                this.buildGui();
            } else if (type == ClickType.MOUSE_LEFT_SHIFT) {
                this.selectedItem = EFItem.NOVA;
                this.buildGui();
            }
        } else if (index == 53) {
            if (type == ClickType.MOUSE_RIGHT) {
                this.showCodes = !this.showCodes;
                this.buildGui();
            } else if (this.game.hasNextTurn() && this.game.getTurn() == 0 && !this.paid) {
                if (MinecraftUtils.removeItems((class_1657)this.player, (class_1792)ArcanaRegistry.STARDUST, (int)this.game.getTotalCost())) {
                    this.turnMode = false;
                    this.animated = true;
                    this.cinematicMode = true;
                    this.paid = true;
                    this.fast = type == ClickType.MOUSE_LEFT_SHIFT;
                    this.buildGui();
                } else {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)"You do not have enough ").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}).method_10852((class_2561)class_2561.method_43471((String)ArcanaRegistry.STARDUST.method_7876()).method_27695(new class_124[]{class_124.field_1054, class_124.field_1056})), false);
                    SoundUtils.playSongToPlayer((class_3222)this.player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                }
            }
        } else if (index == 35 && type.isRight) {
            this.game.resetBoard();
            this.game.applyChanges();
            this.buildGui();
        } else if (onBoard && !type.isDragging && this.game.getTurn() == 0) {
            int x = index % 9;
            int y = index / 9;
            if (type == ClickType.MOUSE_LEFT_SHIFT) {
                if (this.selectedItem == this.game.getItemAt(x, y)) {
                    this.game.removeChanges(x, y);
                } else {
                    this.game.addChange(new EnhancedForgingGame.EFChange(EnhancedForgingGame.EFChangeType.TILE_CHANGE, x, y, Optional.of(this.selectedItem)));
                }
            } else if (type == ClickType.MOUSE_LEFT) {
                this.game.addChange(new EnhancedForgingGame.EFChange(EnhancedForgingGame.EFChangeType.TURN_DECREASE, x, y, Optional.empty()));
            } else if (type == ClickType.MOUSE_RIGHT) {
                this.game.addChange(new EnhancedForgingGame.EFChange(EnhancedForgingGame.EFChangeType.TURN_INCREASE, x, y, Optional.empty()));
            }
            this.game.applyChanges();
            this.buildGui();
        }
        return true;
    }

    public boolean advanceGameStep() {
        boolean changed = this.game.nextTurn();
        this.buildGui();
        return changed;
    }

    public void onTick() {
        class_1937 world = this.blockEntity.method_10997();
        if (world == null || world.method_8321(this.blockEntity.method_11016()) != this.blockEntity || !this.blockEntity.isAssembled()) {
            this.close();
        }
        ++this.tickCount;
        super.onTick();
        if (!this.animated && this.endingAnim == -1) {
            return;
        }
        if (this.tickCount % (long)(this.fast ? 5 : 10) != 0L) {
            return;
        }
        if (this.endingAnim >= 0) {
            if (this.endingAnim == 0) {
                ArrayList<Integer> slots = new ArrayList<Integer>();
                for (int i = 0; i < this.getSize(); ++i) {
                    class_2960 id;
                    class_1799 stack = this.getSlot(i).getItemStack();
                    if (!stack.method_31574(BorisLib.GRAPHICAL_ITEM) || (id = class_2960.method_60654((String)BorisLib.BORISLIB_ITEM_DATA.getStringProperty(stack, "graphic_id"))).equals((Object)EFItem.STAR.displayElement.id()) || id.equals((Object)EFItem.PULSAR.displayElement.id()) || id.equals((Object)EFItem.GAS.displayElement.id()) || id.equals((Object)GraphicalItem.BLACK.id())) continue;
                    slots.add(i);
                }
                if (slots.isEmpty()) {
                    this.endingAnim = 1;
                } else {
                    GuiElementBuilder elem = EFItem.getGuiElement(EFItem.GAS).hideTooltip();
                    Collections.shuffle(slots);
                    for (int i = 0; i < 3 && i < slots.size(); ++i) {
                        this.setSlot((Integer)slots.get(i), (GuiElementBuilderInterface)elem);
                    }
                    return;
                }
            }
            if (this.endingAnim == 5) {
                this.onCompletion();
                this.endingAnim = -1;
                return;
            }
            ++this.endingAnim;
            return;
        }
        if (this.tickCount % 20L != 0L) {
            return;
        }
        boolean didTurn = false;
        while (this.game.hasNextTurn() && !this.advanceGameStep()) {
            didTurn = true;
        }
        if (!didTurn && !this.game.hasNextTurn()) {
            this.animated = false;
            this.endingAnim = 0;
        }
    }

    public void buildGui() {
        this.setTitle((class_2561)class_2561.method_43470((String)"Stardust Infusion"));
        this.setSlot(7, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT, (int)478174)).setName((class_2561)class_2561.method_43473()).hideTooltip());
        this.setSlot(16, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)478174)).setName((class_2561)class_2561.method_43473()).hideTooltip());
        this.setSlot(17, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)478174)).setName((class_2561)class_2561.method_43473()).hideTooltip());
        this.setSlot(25, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT, (int)478174)).setName((class_2561)class_2561.method_43473()).hideTooltip());
        this.setSlot(34, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT, (int)478174)).setName((class_2561)class_2561.method_43473()).hideTooltip());
        this.setSlot(43, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT_CONNECTOR, (int)478174)).setName((class_2561)class_2561.method_43473()).hideTooltip());
        this.setSlot(44, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_TOP, (int)478174)).setName((class_2561)class_2561.method_43473()).hideTooltip());
        this.setSlot(52, (GuiElementBuilderInterface)GuiElementBuilder.from((class_1799)GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.MENU_LEFT, (int)478174)).setName((class_2561)class_2561.method_43473()).hideTooltip());
        GuiElementBuilder orderItem = GuiElementBuilder.from((class_1799)class_1802.field_8557.method_7854()).hideDefaultTooltip();
        orderItem.setName((class_2561)class_2561.method_43470((String)"Show Item Order").method_27692(class_124.field_1054));
        orderItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to show the order of tiles.").method_27692(class_124.field_1076))));
        orderItem.addLoreLine((class_2561)class_2561.method_43473());
        orderItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Stack size indicates the order of tiles.").method_27692(class_124.field_1080)));
        orderItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Newly created items activate after all queued tiles.").method_27692(class_124.field_1080)));
        orderItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Changing turn order costs ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"1").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" stardust.").method_27692(class_124.field_1054))));
        orderItem.setMaxCount(99);
        orderItem.setCount(this.game.getTurn() + 1);
        this.setSlot(8, (GuiElementBuilderInterface)orderItem);
        GuiElementBuilder runItem = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.CONFIRM)).hideDefaultTooltip();
        runItem.setName((class_2561)class_2561.method_43470((String)"Activate Forge").method_27692(class_124.field_1054));
        runItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to activate the forge.").method_27692(class_124.field_1076))));
        if (this.showCodes) {
            runItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
            runItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Board ID: " + this.game.getStartingCode())).method_27692(class_124.field_1063)));
            runItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)("Solution ID: " + this.game.getGameCode())).method_27692(class_124.field_1063)));
        }
        this.setSlot(53, (GuiElementBuilderInterface)runItem);
        int playCost = 10;
        int turnCost = this.game.getTurnChangeCost();
        int tileCost = this.game.getTileChangeCost();
        int totalCost = this.game.getTotalCost();
        GuiElementBuilder stardustItem = GuiElementBuilder.from((class_1799)MinecraftUtils.removeLore((class_1799)ArcanaRegistry.STARDUST.method_7854())).hideDefaultTooltip();
        stardustItem.setName((class_2561)class_2561.method_43470((String)"Requires 10 Stardust").method_27692(class_124.field_1054));
        stardustItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Requires ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)("" + totalCost)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" Stardust").method_27692(class_124.field_1054)));
        stardustItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Base Cost: ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)(playCost + " Stardust")).method_27692(class_124.field_1065))));
        stardustItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Turn Order Cost: ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)(turnCost + " Stardust")).method_27692(class_124.field_1065))));
        stardustItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Tile Cost: ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(tileCost + " Stardust")).method_27692(class_124.field_1065))));
        stardustItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
        stardustItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"Changing tiles or tile order costs stardust.").method_27692(class_124.field_1080)));
        stardustItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Forging has a base cost of ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("" + playCost)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" stardust.").method_27692(class_124.field_1054))));
        stardustItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
        stardustItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to reset the layout.").method_27692(class_124.field_1076))));
        stardustItem.setMaxCount(99);
        stardustItem.setCount(totalCost);
        this.setSlot(35, (GuiElementBuilderInterface)stardustItem);
        GuiElementBuilder placementItem = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)this.selectedItem.displayElement)).hideDefaultTooltip();
        placementItem.setName((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Change tile to ").method_27692(class_124.field_1054)).method_10852(this.selectedItem.name));
        placementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This tile costs ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("" + this.selectedItem.placementCost)).method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" stardust.").method_27692(class_124.field_1054))));
        placementItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
        for (class_2561 text : this.selectedItem.description) {
            placementItem.addLoreLine(text);
        }
        placementItem.addLoreLine((class_2561)class_2561.method_43470((String)""));
        placementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Click or Right Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to cycle tile types.").method_27692(class_124.field_1076))));
        placementItem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" a tile to convert it.").method_27692(class_124.field_1076))));
        placementItem.setCount(Math.max(1, this.selectedItem.placementCost));
        this.setSlot(26, (GuiElementBuilderInterface)placementItem);
        class_3545<EFItem, Integer>[][] board = this.game.getBoard();
        for (int x = 0; x < this.game.width; ++x) {
            for (int y = 0; y < this.game.height; ++y) {
                class_3545<EFItem, Integer> tile = board[x][y];
                GuiElementBuilder elem = EFItem.getGuiElement((EFItem)((Object)tile.method_15442()));
                if (tile.method_15442() != EFItem.PLANET) {
                    elem.addLoreLine((class_2561)class_2561.method_43470((String)""));
                    if (tile.method_15442() == this.selectedItem) {
                        elem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to reset this tile.").method_27692(class_124.field_1076))));
                    } else {
                        elem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Shift Click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to change tile type to ").method_27692(class_124.field_1076)).method_10852(this.selectedItem.name)));
                    }
                    if (EFItem.hasTurn((EFItem)((Object)tile.method_15442()))) {
                        elem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Left Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to hasten this tile's turn.").method_27692(class_124.field_1076))));
                        elem.addLoreLine((class_2561)TextUtils.removeItalics((class_5250)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to delay this tile's turn.").method_27692(class_124.field_1076))));
                    }
                }
                if (this.turnMode) {
                    elem.setMaxCount(99);
                    elem.setCount((Integer)tile.method_15441() + 1);
                }
                if (this.cinematicMode) {
                    elem.hideTooltip();
                    this.setSlot(x + 1 + 9 * y, (GuiElementBuilderInterface)elem);
                    continue;
                }
                this.setSlot(x + 9 * y, (GuiElementBuilderInterface)elem);
            }
        }
        if (this.cinematicMode) {
            for (int i = 0; i < 6; ++i) {
                GuiElementBuilder elem = GuiElementBuilder.from((class_1799)GraphicalItem.with((GraphicalItem.GraphicElement)GraphicalItem.BLACK)).hideTooltip();
                this.setSlot(i * 9, (GuiElementBuilderInterface)elem);
                this.setSlot(i * 9 + 8, (GuiElementBuilderInterface)elem);
            }
        }
    }

    public void onCompletion() {
        class_1937 class_19372 = this.blockEntity.method_10997();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        this.completed = true;
        this.blockEntity.addSeedUse();
        double percentile = EnhancedStatUtils.generatePercentile(this.game.getStarCount());
        if (this.enhancedStack.method_31574(ArcanaRegistry.SOVEREIGN_ARCANE_PAPER)) {
            this.enhancedStack.method_7939((int)(6.0 * Math.pow(percentile, 5.0) + 5.0 * percentile + 5.0));
        } else {
            EnhancedStatUtils.enhanceItem(this.enhancedStack, percentile);
            ArcanaNovum.data((class_1657)this.player).setResearchTask(ResearchTasks.INFUSE_ITEM, true);
        }
        ArcanaEffectUtils.enhancedForgingAnim(world, this.blockEntity.method_11016(), this.enhancedStack, 0.0, this.fast ? 1.75 : 1.0);
        int finalCost = this.game.getTotalCost();
        BorisLib.addTickTimerCallback((class_3218)world, (TickTimerCallback)new GenericTimer(this.fast ? 200 : 350, () -> {
            if (percentile >= 0.99 && !this.enhancedStack.method_31574(ArcanaRegistry.SOVEREIGN_ARCANE_PAPER)) {
                ArcanaAchievements.grant(this.player, ArcanaAchievements.MASTER_CRAFTSMAN.id);
            }
            ArcanaNovum.data((class_1657)this.player).addXP(ArcanaConfig.getInt(ArcanaRegistry.STARDUST_INFUSION_PER_STARDUST) * finalCost);
            class_243 pos = this.blockEntity.method_11016().method_46558().method_1031(0.0, 2.0, 0.0);
            class_1264.method_5449((class_1937)world, (double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (class_1799)this.enhancedStack);
        }));
        this.paid = false;
        this.close();
    }

    public void close() {
        super.close();
    }

    public void onClose() {
        class_2371<class_1799> list = this.completed ? this.remainders : this.ingredients;
        class_1277 returnInv = new class_1277(list.size() + 1);
        for (class_1799 stack : list) {
            returnInv.method_5491(stack);
        }
        if (this.paid) {
            int amnt;
            for (int cost = this.game.getTotalCost(); cost > 0; cost -= amnt) {
                amnt = Math.min(cost, ArcanaRegistry.STARDUST.method_7882());
                returnInv.method_5491(new class_1799((class_1935)ArcanaRegistry.STARDUST, amnt));
            }
        }
        MinecraftUtils.returnItems((class_1263)returnInv, (class_1657)this.player);
    }
}

