/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class AncientDowsingRod
extends EnergyItem {
    public static final String ID = "ancient_dowsing_rod";

    public AncientDowsingRod() {
        this.id = ID;
        this.name = "Ancient Dowsing Rod";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.vanillaItem = class_1802.field_8894;
        this.item = new AncientDowsingRodItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.ancient_dowsing_rod", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1079});
        this.researchTasks = new class_5321[]{ResearchTasks.RESONATE_BELL, ResearchTasks.ADVANCEMENT_OBTAIN_ANCIENT_DEBRIS, ResearchTasks.ADVANCEMENT_FIND_BASTION};
        this.initEnergy = 100;
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Ancient civilizations").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" in the ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"nether ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"had ways of finding ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"netherite").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1061)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"dowsing rod ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"is based on ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"ancient designs").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" to locate ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"netherite scrap").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1061)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" to search for ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"ancient debris").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1061)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        int lvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.SONIC_REABSORPTION.id));
        return 30 - 5 * lvl;
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8695, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_20410, 12);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8814, 16);
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_8894, 8);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_22021, 1);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_22019, 1);
        ArcanaIngredient l = new ArcanaIngredient(class_1802.field_41946, 1);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_16315, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, d, b}, {b, g, h, g, d}, {h, l, m, l, h}, {d, g, h, g, b}, {b, d, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Ancient Dowsing\n         Rod").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nModern Piglins seem to be incapable of finding Netherite, but their bastions contain fragments of it, and the smithing templates to forge it. There may be some history at play here.   ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Ancient Dowsing\n         Rod").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nI recovered some pieces of a tool, possibly used by their ancestors, perhaps I can reconstruct it.\n\nUse the rod to send out a resonating signal that reflects off Ancient Debris. ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Ancient Dowsing\n         Rod").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nThe echos trigger a compass of flame to indicate how much debris is nearby.\n\nAdditionally, a flaming arrow points to the closest debris nearby.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class AncientDowsingRodItem
    extends ArcanaPolymerItem {
        public AncientDowsingRodItem() {
            super(AncientDowsingRod.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            ArrayList<String> stringList = new ArrayList<String>();
            if (AncientDowsingRod.this.getEnergy(itemStack) < AncientDowsingRod.this.getMaxEnergy(itemStack)) {
                stringList.add("cooldown");
            } else {
                stringList.add("charged");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return AncientDowsingRod.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218)) {
                return;
            }
            if (world.method_8503().method_3780() % 20 == 0) {
                AncientDowsingRod.this.addEnergy(stack, 1);
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 item = playerEntity.method_5998(hand);
            if (playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                int curEnergy = AncientDowsingRod.this.getEnergy(item);
                if (curEnergy >= AncientDowsingRod.this.getMaxEnergy(item)) {
                    AncientDowsingRod.this.setEnergy(item, 0);
                    int scanRange = 25 + 5 * Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.ENHANCED_RESONANCE.id));
                    class_2338 curBlock = playerEntity.method_24515();
                    SoundUtils.playSound((class_1937)world, (class_2338)curBlock, (class_3414)class_3417.field_17265, (class_3419)class_3419.field_15248, (float)1.0f, (float)0.5f);
                    ArrayList<class_2338> debris = new ArrayList<class_2338>();
                    for (class_2338 block : class_2338.method_25996((class_2338)curBlock, (int)scanRange, (int)(scanRange / 2), (int)scanRange)) {
                        if (world.method_8320(block).method_26204() != class_2246.field_22109) continue;
                        debris.add(new class_2338((class_2382)block));
                    }
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        if (!debris.isEmpty()) {
                            ArcanaAchievements.progress(player, ArcanaAchievements.ARCHEOLOGIST.id, debris.size());
                        }
                        BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(30, () -> SoundUtils.playSound((class_1937)world, (class_2338)playerEntity.method_24515(), (class_3414)class_3417.field_19167, (class_3419)class_3419.field_15248, (float)1.0f, (float)0.5f)));
                        BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(140, () -> {
                            int[] locations = new int[8];
                            double t1 = Math.tan(Math.toRadians(67.5));
                            double t2 = Math.tan(Math.toRadians(22.5));
                            class_243 playerPos = playerEntity.method_19538();
                            int count = 0;
                            for (class_2338 b : debris) {
                                class_243 rPos = new class_243((double)b.method_10263() - playerPos.field_1352, (double)b.method_10264() - playerPos.field_1351, (double)b.method_10260() - playerPos.field_1350);
                                double ratio = rPos.field_1352 == 0.0 ? 100.0 : rPos.field_1350 / rPos.field_1352;
                                int ind = 0;
                                if (ratio < 0.0 && ratio > -t2) {
                                    ind = 0;
                                } else if (ratio > -t1 && ratio < -t2) {
                                    ind = 1;
                                } else if (ratio < -t1 || ratio > t1) {
                                    ind = 2;
                                } else if (ratio < t1 && ratio > t2) {
                                    ind = 3;
                                } else if (ratio > 0.0 && ratio < t2) {
                                    ind = 4;
                                }
                                if (rPos.field_1350 < 0.0) {
                                    ind += 4;
                                }
                                if (ind > locations.length - 1) {
                                    ind = 0;
                                }
                                int n = ind;
                                locations[n] = locations[n] + 1;
                                if (count < 12) {
                                    ArcanaEffectUtils.dowsingRodEmitter(serverWorld, new class_243((double)b.method_10263(), (double)b.method_10264(), (double)b.method_10260()), 1, 100 + 33 * Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.HARMONIC_FEEDBACK.id)));
                                }
                                ++count;
                            }
                            double radius = 1.5;
                            for (int i = 0; i < locations.length; ++i) {
                                double mod;
                                class_243 pPos = switch (i) {
                                    case 0 -> new class_243(-radius, 0.0, 0.0);
                                    case 1 -> new class_243(-radius, 0.0, radius);
                                    case 2 -> new class_243(0.0, 0.0, radius);
                                    case 3 -> new class_243(radius, 0.0, radius);
                                    case 4 -> new class_243(radius, 0.0, 0.0);
                                    case 5 -> new class_243(radius, 0.0, -radius);
                                    case 6 -> new class_243(0.0, 0.0, -radius);
                                    case 7 -> new class_243(-radius, 0.0, -radius);
                                    default -> new class_243(0.0, 0.0, 0.0);
                                };
                                for (int n = 0; n < locations[i] && (mod = Math.min((double)n * 0.6, 6.0 / radius)) != 6.0 / radius; ++n) {
                                    class_243 parPos = playerPos.method_1019(pPos.method_1021(1.0 + mod)).method_1031(0.0, 0.7, 0.0);
                                    player.method_51469().method_65096((class_2394)class_2398.field_11223, parPos.field_1352, parPos.field_1351, parPos.field_1350, 15, 0.12, 0.12, 0.12, 1.0);
                                }
                            }
                            if (!debris.isEmpty()) {
                                class_2338 closest = (class_2338)debris.get(0);
                                class_243 eyePos = playerEntity.method_33571();
                                class_243 blockPos = new class_243((double)closest.method_10263() + 0.5, (double)closest.method_10264() + 0.5, (double)closest.method_10260() + 0.5);
                                class_243 start = eyePos.method_1019(blockPos.method_1020(eyePos).method_1029().method_1021(1.5));
                                class_243 end = eyePos.method_1019(blockPos.method_1020(eyePos).method_1029().method_1021(4.5));
                                ArcanaEffectUtils.dowsingRodArrow(player.method_51469(), start, end, 1);
                                ArcanaNovum.data((class_1657)player).addXP(Math.min(ArcanaConfig.getInt(ArcanaRegistry.ANCIENT_DOWSING_ROD_CAP), ArcanaConfig.getInt(ArcanaRegistry.ANCIENT_DOWSING_ROD_PER_DEBRIS) * debris.size()));
                                SoundUtils.playSound((class_1937)world, (class_2338)playerEntity.method_24515(), (class_3414)class_3417.field_15013, (class_3419)class_3419.field_15248, (float)1.0f, (float)0.5f);
                                if (debris.size() >= 10) {
                                    ArcanaAchievements.grant(player, ArcanaAchievements.MOTHERLOAD.id);
                                }
                            } else {
                                SoundUtils.playSound((class_1937)world, (class_2338)playerEntity.method_24515(), (class_3414)class_3417.field_15102, (class_3419)class_3419.field_15248, (float)1.0f, (float)0.5f);
                            }
                        }));
                    }
                } else {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)("Dowsing Rod Recharging: " + curEnergy * 100 / AncientDowsingRod.this.getMaxEnergy(item) + "%")).method_27692(class_124.field_1065), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                }
            }
            return class_1269.field_52422;
        }
    }
}

