/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2402;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class AquaticEversource
extends ArcanaItem {
    public static final String ID = "aquatic_eversource";

    public AquaticEversource() {
        this.id = ID;
        this.name = "Aquatic Eversource";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.vanillaItem = class_1802.field_8705;
        this.item = new AquaticEversourceItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.aquatic_eversource", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1078});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_HEART_OF_THE_SEA, ResearchTasks.OBTAIN_BLUE_ICE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        AquaticEversource.putProperty(stack, "mode", 0);
        this.setPrefStack(stack);
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        int mode = AquaticEversource.getIntProperty(stack, "mode");
        class_1799 newStack = super.updateItem(stack, server);
        AquaticEversource.putProperty(newStack, "mode", mode);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Two ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"buckets can make an ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"ocean").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)", but ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"one ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"should be ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"enough").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1075)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"create ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"or ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"evaporate ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"water.").method_27692(class_124.field_1075)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" to switch between ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"placing ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"removing ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"water.").method_27692(class_124.field_1075)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8550, 8);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8695, 6);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8178, 4);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8477, 2);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8207, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, c, h, c, b}, {c, h, m, h, c}, {b, c, h, c, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"       Aquatic\n    Eversource").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nCarrying numerous water buckets is a waste of inventory space.\nA rudimentary contraption capable of portable condensation should alleviate this issue.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"       Aquatic\n    Eversource").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nThe trinket I created can pull water straight from the air to produce limitless water.\n\nA reversal of the process lets me use the trinket to evaporate any fluid type.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"       Aquatic\n    Eversource").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nUsing the Eversource will generate or drain water.\n\nSneak Using will switch the mode of the Eversource.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class AquaticEversourceItem
    extends ArcanaPolymerItem {
        public AquaticEversourceItem() {
            super(AquaticEversource.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            int mode = ArcanaItem.getIntProperty(itemStack, "mode");
            ArrayList<String> stringList = new ArrayList<String>();
            if (mode == 1) {
                stringList.add("remove");
            } else {
                stringList.add("place");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return AquaticEversource.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            boolean floodgate;
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            int mode = ArcanaItem.getIntProperty(stack, "mode");
            boolean bl = floodgate = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.FLOODGATE.id) > 0;
            if (playerEntity.method_5715()) {
                int newMode = (mode + 1) % (floodgate ? 3 : 2);
                ArcanaItem.putProperty(stack, "mode", newMode);
                if (newMode == 1) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Eversource Evaporates").method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14834, (float)1.0f, (float)1.0f);
                } else if (newMode == 2) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Eversource Swells").method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15126, (float)1.0f, (float)1.0f);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Eversource Condenses").method_27695(new class_124[]{class_124.field_1078, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15126, (float)1.0f, (float)1.0f);
                }
                return class_1269.field_52422;
            }
            Object fluid = mode == 1 ? class_3612.field_15906 : class_3612.field_15910;
            class_3965 blockHitResult = class_1755.method_7872((class_1937)world, (class_1657)playerEntity, (class_3959.class_242)(fluid == class_3612.field_15906 ? class_3959.class_242.field_1345 : class_3959.class_242.field_1348));
            if (blockHitResult.method_17783() == class_239.class_240.field_1333) {
                return class_1269.field_5811;
            }
            if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
                class_2338 blockPos = blockHitResult.method_17777();
                class_2350 direction = blockHitResult.method_17780();
                class_2338 blockPos2 = blockPos.method_10093(direction);
                if (!world.method_8505((class_1297)playerEntity, blockPos) || !playerEntity.method_7343(blockPos2, direction, stack)) {
                    return class_1269.field_5814;
                }
                if (fluid == class_3612.field_15906) {
                    class_2263 fluidDrainable;
                    class_2680 blockState = world.method_8320(blockPos);
                    class_2248 block = blockState.method_26204();
                    if (block instanceof class_2263 && !(fluidDrainable = (class_2263)block).method_9700((class_1309)playerEntity, (class_1936)world, blockPos, blockState).method_7960()) {
                        playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
                        fluidDrainable.method_32351().ifPresent(sound -> playerEntity.method_5783(sound, 1.0f, 1.0f));
                        world.method_33596((class_1297)playerEntity, (class_6880)class_5712.field_28167, blockPos);
                        return class_1269.field_52422;
                    }
                    return class_1269.field_5814;
                }
                class_2680 blockState = world.method_8320(blockPos);
                class_2338 blockPos3 = blockState.method_26204() instanceof class_2402 ? blockPos : blockPos2;
                int placeStatus = this.placeFluid((class_3611)fluid, playerEntity, world, blockPos3, blockHitResult, false);
                if (placeStatus > 0) {
                    if (mode == 2 && placeStatus == 2) {
                        for (class_2338 floodPos : class_2338.method_10097((class_2338)blockPos3.method_10069(-1, 0, -1), (class_2338)blockPos3.method_10069(1, 0, 1))) {
                            if (floodPos.equals((Object)blockPos3) || this.placeFluid((class_3611)fluid, playerEntity, world, floodPos, null, true) <= 0) continue;
                            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.AQUATIC_EVERSOURCE_USE));
                            ArcanaAchievements.progress(player, ArcanaAchievements.POCKET_OCEAN.id, 1);
                        }
                    }
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.AQUATIC_EVERSOURCE_USE));
                    ArcanaAchievements.progress(player, ArcanaAchievements.POCKET_OCEAN.id, 1);
                    playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
                    playerEntity.method_7357().method_62835(stack, 5);
                    return class_1269.field_52422;
                }
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        }

        public int placeFluid(class_3611 fluid, @Nullable class_1657 player, class_1937 world, class_2338 pos, @Nullable class_3965 hitResult, boolean flood) {
            boolean bl2;
            if (!(fluid instanceof class_3609)) {
                return 0;
            }
            class_3609 flowableFluid = (class_3609)fluid;
            class_2680 blockState = world.method_8320(pos);
            class_2248 block = blockState.method_26204();
            boolean bl = blockState.method_26188(fluid);
            boolean bl3 = bl2 = blockState.method_26215() || bl || block instanceof class_2402 && ((class_2402)block).method_10310((class_1309)player, (class_1922)world, pos, blockState, fluid) && !flood;
            if (!bl2) {
                return hitResult == null ? 0 : this.placeFluid(fluid, player, world, hitResult.method_17777().method_10093(hitResult.method_17780()), null, flood);
            }
            if (world.method_8597().comp_644() && fluid.method_15791(class_3486.field_15517)) {
                int i = pos.method_10263();
                int j = pos.method_10264();
                int k = pos.method_10260();
                world.method_8396((class_1297)player, pos, class_3417.field_15102, class_3419.field_15245, 0.5f, 2.6f + (world.field_9229.method_43057() - world.field_9229.method_43057()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    world.method_8406((class_2394)class_2398.field_11237, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
                return 1;
            }
            if (block instanceof class_2402 && !flood) {
                class_2402 fluidFillable = (class_2402)block;
                if (fluid == class_3612.field_15910) {
                    fluidFillable.method_10311((class_1936)world, pos, blockState, flowableFluid.method_15729(false));
                    world.method_8396((class_1297)player, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
                    world.method_33596((class_1297)player, (class_6880)class_5712.field_28166, pos);
                    return 1;
                }
            }
            if (!world.field_9236 && bl && !blockState.method_51176()) {
                world.method_22352(pos, true);
            }
            if (world.method_8652(pos, fluid.method_15785().method_15759(), 11) || blockState.method_26227().method_15771()) {
                if (!flood) {
                    world.method_8396((class_1297)player, pos, class_3417.field_14834, class_3419.field_15245, 1.0f, 1.0f);
                }
                world.method_33596((class_1297)player, (class_6880)class_5712.field_28166, pos);
                return 2;
            }
            return 0;
        }
    }
}

