/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ExplainIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ExplainRecipe;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class ArcaneTome
extends ArcanaItem {
    public static final String ID = "arcane_tome";
    public static final String DISPLAY_TAG = "arcanaItemId";
    public static final String FORGE_TAG = "forgeCraftTick";
    public static final String TOME_TAG = "tomeCraftTick";

    public ArcaneTome() {
        this.id = ID;
        this.name = "Tome of Arcana Novum";
        this.rarity = ArcanaRarity.MUNDANE;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 1;
        this.vanillaItem = class_1802.field_8361;
        this.item = new ArcaneTomeItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.arcane_tome", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1064});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_EYE_OF_ENDER, ResearchTasks.ADVANCEMENT_ENCHANT_ITEM};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The knowledge within shall be your ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"guide").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"There is so much ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"new magic").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to explore...").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right click").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to open the tome.").method_27692(class_124.field_1060)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    public void openGui(class_1657 playerEntity, TomeGui.TomeMode mode, TomeGui.CompendiumSettings settings) {
        this.openGui(playerEntity, mode, settings, "");
    }

    public void openGui(class_1657 playerEntity, TomeGui.TomeMode mode, TomeGui.CompendiumSettings settings, String data) {
        if (!(playerEntity instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)playerEntity;
        TomeGui gui = null;
        boolean open = false;
        if (mode == TomeGui.TomeMode.PROFILE) {
            gui = new TomeGui(class_3917.field_17327, player, mode, this, settings);
            gui.buildProfileGui(player);
            open = true;
        } else if (mode == TomeGui.TomeMode.COMPENDIUM) {
            gui = new TomeGui(class_3917.field_17327, player, mode, this, settings);
            TomeGui.buildCompendiumGui(gui, player, settings);
            open = true;
        } else if (mode == TomeGui.TomeMode.ITEM) {
            if (ArcanaItemUtils.getItemFromId(data) != null) {
                gui = new TomeGui(class_3917.field_17327, player, mode, this, settings);
                TomeGui.buildItemGui(gui, player, data);
                open = true;
            } else {
                gui = new TomeGui(class_3917.field_17327, player, mode, this, settings);
                TomeGui.buildCompendiumGui(gui, player, settings);
                open = true;
            }
        } else if (mode == TomeGui.TomeMode.RECIPE) {
            if (ArcanaItemUtils.getItemFromId(data) != null) {
                this.openRecipeGui(player, settings, ArcanaItemUtils.getItemFromId(data));
            } else {
                gui = new TomeGui(class_3917.field_17327, player, mode, this, settings);
                TomeGui.buildCompendiumGui(gui, player, settings);
                open = true;
            }
        } else if (mode == TomeGui.TomeMode.ACHIEVEMENTS) {
            gui = new TomeGui(class_3917.field_17327, player, mode, this, settings);
            gui.buildAchievementsGui(player, settings);
            open = true;
        } else if (mode == TomeGui.TomeMode.LEADERBOARD) {
            gui = new TomeGui(class_3917.field_17327, player, mode, this, settings);
            gui.buildLeaderboardGui(player, settings);
            open = true;
        } else if (mode == TomeGui.TomeMode.RESEARCH) {
            gui = new TomeGui(class_3917.field_17327, player, mode, this, settings);
            gui.buildResearchGui(player, settings, data);
            open = true;
        }
        if (open) {
            gui.setMode(mode);
            gui.open();
        }
    }

    public void openRecipeGui(class_3222 player, TomeGui.CompendiumSettings settings, ArcanaItem arcanaItem) {
        this.openRecipeGui(player, settings, (class_2561)arcanaItem.getTranslatedName(), arcanaItem.getRecipe(), arcanaItem.getPrefItem());
    }

    public void openRecipeGui(class_3222 player, TomeGui.CompendiumSettings settings, class_2561 name, ArcanaRecipe recipe, class_1799 output) {
        TomeGui gui = new TomeGui(class_3917.field_18667, player, TomeGui.TomeMode.RECIPE, this, settings);
        gui.buildRecipeGui(gui, name, recipe, output);
        gui.setMode(TomeGui.TomeMode.RECIPE);
        gui.open();
    }

    public void openItemGui(class_3222 player, TomeGui.CompendiumSettings settings, String id) {
        TomeGui gui = new TomeGui(class_3917.field_17327, player, TomeGui.TomeMode.ITEM, this, settings);
        TomeGui.buildItemGui(gui, player, id);
        gui.setMode(TomeGui.TomeMode.ITEM);
        gui.open();
    }

    public void openResearchGui(class_3222 player, TomeGui.CompendiumSettings settings, String id) {
        TomeGui gui = new TomeGui(class_3917.field_17327, player, TomeGui.TomeMode.RESEARCH, this, settings);
        gui.buildResearchGui(player, settings, id);
        gui.setMode(TomeGui.TomeMode.RESEARCH);
        gui.open();
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"  Tome of Arcana           Novum").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThis new type of paper has quite a few interesting properties.\n\nIt allows the inscription of active arcane elements. It makes an excellent parchment for this ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Tome of Arcana           Novum").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nnew notebook.\n\nEnchanting the pages together with an additional Eye of Ender should bind the whole Tome together nicely.\n\nIt is here that I shall \nscribe all the secrets ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Tome of Arcana           Novum").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067}), class_2561.method_43470((String)"\nof this Arcana Novum that I seek to uncover.").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ExplainIngredient a = new ExplainIngredient(GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)2756918), 1, "", false).withName((class_2561)class_2561.method_43470((String)"In World Recipe").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Do this in the World").method_27692(class_124.field_1064)));
        ExplainIngredient t = new ExplainIngredient(class_1802.field_8657, 1, "Enchanting Table").withName((class_2561)class_2561.method_43470((String)"Enchanting Table").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Place an Enchanting Table in the World").method_27692(class_124.field_1064)));
        ExplainIngredient p = new ExplainIngredient(ArcanaRegistry.MUNDANE_ARCANE_PAPER, 4, "Mundane Arcane Paper").withName((class_2561)class_2561.method_43470((String)"Mundane Arcane Paper").method_27692(class_124.field_1075)).withLore(List.of(class_2561.method_43470((String)"Place the Paper onto the Enchanting Table").method_27692(class_124.field_1064)));
        ExplainIngredient e = new ExplainIngredient(class_1802.field_8449, 1, "Eye of Ender").withName((class_2561)class_2561.method_43470((String)"Eye of Ender").method_27695(new class_124[]{class_124.field_1060, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Place an Eye of Ender onto the Enchanting Table").method_27692(class_124.field_1064)));
        ExplainIngredient[][] ingredients = new ExplainIngredient[][]{{a, a, a, a, a}, {a, a, e, a, a}, {a, a, p, a, a}, {a, a, t, a, a}, {a, a, a, a, a}};
        return new ExplainRecipe(ingredients);
    }

    public class ArcaneTomeItem
    extends ArcanaPolymerItem {
        public ArcaneTomeItem() {
            super(ArcaneTome.this.getThis());
        }

        public class_1799 method_7854() {
            return ArcaneTome.this.prefItem;
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            ArcaneTome.this.openGui(playerEntity, TomeGui.TomeMode.PROFILE, new TomeGui.CompendiumSettings(0, 0));
            return class_1269.field_52422;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            ArcanaItem.removeProperty(stack, ArcaneTome.FORGE_TAG);
        }
    }
}

