/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaItemContainer;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.gui.arcanistsbelt.ArcanistsBeltGui;
import net.borisshoes.arcananovum.gui.arcanistsbelt.ArcanistsBeltSlot;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.DataFixer;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ArcanistsBelt
extends ArcanaItem
implements ArcanaItemContainer.ArcanaItemContainerHaver {
    public static final String ID = "arcanists_belt";
    public static final String ITEMS_TAG = "items";

    public ArcanistsBelt() {
        this.id = ID;
        this.name = "Arcanist's Belt";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 1;
        this.vanillaItem = class_1802.field_8719;
        this.item = new ArcanistsBeltItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.arcanists_belt", (String)this.name).method_27692(class_124.field_1067).method_54663(0x996633);
        this.researchTasks = new class_5321[]{ResearchTasks.USE_ENDER_CHEST, ResearchTasks.CONCENTRATION_DAMAGE, ResearchTasks.UNLOCK_TWILIGHT_ANVIL};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"For when you have too many ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"tools ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Arcana Items ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"to carry...").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arcana Items").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" in the belt will maintain their ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"passive effects").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Arcana Items").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)" consume a ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"reduced").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" amount of ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"concentration").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to access the ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"Belt's").method_54663(0x996633)).method_10852((class_2561)class_2561.method_43470((String)" slots").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
        if (itemStack != null) {
            int i;
            class_9288 beltItems = (class_9288)itemStack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
            class_1277 inv = new class_1277(9);
            List streamList = beltItems.method_59712().toList();
            for (i = 0; i < streamList.size(); ++i) {
                inv.method_5447(i, (class_1799)streamList.get(i));
            }
            if (inv.method_5442()) {
                lore.add(class_2561.method_43470((String)""));
                lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Contents: ").method_54663(0x996633)).method_10852((class_2561)class_2561.method_43470((String)"Empty").method_27692(class_124.field_1054)));
            } else {
                lore.add(class_2561.method_43470((String)""));
                lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Contents:").method_54663(0x996633)));
                for (i = 0; i < inv.method_5439(); ++i) {
                    class_1799 stack = inv.method_5438(i);
                    if (stack.method_7960()) continue;
                    class_2583 style = stack.method_7964().method_10866();
                    boolean keepStyle = style.method_10984() || style.method_10966() || style.method_10987() || style.method_10965() || style.method_10986() || style.method_10973() != null && style.method_10973().method_27716() != class_124.field_1068.method_532().intValue();
                    class_5250 name = stack.method_7964().method_27661();
                    if (!keepStyle) {
                        name = name.method_27692(class_124.field_1054);
                    }
                    if (stack.method_7947() == 1 && stack.method_7914() == 1) {
                        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1062)).method_10852((class_2561)name));
                        continue;
                    }
                    lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)(stack.method_7947() + "x ")).method_27692(class_124.field_1064)).method_10852((class_2561)name));
                }
            }
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        if (ArcanistsBelt.getIntProperty(stack, "Version") <= 12) {
            class_2499 beltItems = ArcanistsBelt.getListProperty(stack, ITEMS_TAG).method_10612();
            stack.method_57379(class_9334.field_49622, (Object)DataFixer.nbtListToComponent(beltItems, server));
            ArcanistsBelt.removeProperty(stack, ITEMS_TAG);
        }
        class_1799 newStack = super.updateItem(stack, server);
        return this.buildItemLore(newStack, server);
    }

    public static boolean checkBeltAndHasItem(class_1799 beltStack, class_1792 searchItem) {
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(beltStack);
        return arcanaItem instanceof ArcanistsBelt && !MinecraftUtils.getMatchingItemsFromContainerComp((class_1799)beltStack, (class_1792)searchItem).isEmpty();
    }

    @Override
    public ArcanaItemContainer getArcanaItemContainer(class_1799 item) {
        int size = 9;
        boolean padding = ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.MENTAL_PADDING.id) >= 1;
        class_9288 beltItems = (class_9288)item.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        class_1277 inv = new class_1277(size);
        List streamList = beltItems.method_59712().toList();
        for (int i = 0; i < streamList.size(); ++i) {
            inv.method_5447(i, (class_1799)streamList.get(i));
        }
        return new ArcanaItemContainer((class_1263)inv, size, 10, "AB", "Arcanist's Belt", padding ? 0.25 : 0.5);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8137, 1);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8745, 12);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_22021, 2);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8695, 24);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8106, 16);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8466, 8);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"  Arcanist's Belt").method_27692(class_124.field_1067).method_54663(0x996633), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nWith my collection of Arcana items rapidly increasing, my inventory has become cluttered with trinkets. Some Arcana items are passive, so perhaps I can stuff them away in a mini Ender Chest of sorts and only ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Arcanist's Belt").method_27692(class_124.field_1067).method_54663(0x996633), class_2561.method_43470((String)"\nchannel enough Arcana to keep their passive abilities active.\n\nThe Belt should be able to accommodate unstackable items as well, as long as they aren\u2019t too big. The Belt\u2019s pouches can \n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Arcanist's Belt").method_27692(class_124.field_1067).method_54663(0x996633), class_2561.method_43470((String)"\nalso be accessed similar to a Bundle in my inventory.").method_27692(class_124.field_1074)));
        return list;
    }

    public class ArcanistsBeltItem
    extends ArcanaPolymerItem {
        public static final int[] BELT_SLOT_COUNT = new int[]{3, 4, 5, 7, 9};

        public ArcanistsBeltItem() {
            super(ArcanistsBelt.this.getThis(), ArcanistsBelt.this.getArcanaItemComponents().method_57349(class_9334.field_49622, (Object)class_9288.field_49334));
        }

        public class_1799 method_7854() {
            return ArcanistsBelt.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            class_9288 beltItems = (class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
            for (class_1799 invStack : beltItems.method_59714()) {
                invStack.method_7909().method_7888(invStack, world, entity, null);
            }
            ArcanistsBelt.this.buildItemLore(stack, BorisLib.SERVER);
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            if (playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                class_1799 stack = playerEntity.method_5998(hand);
                ArcanistsBeltGui gui = new ArcanistsBeltGui(player, ArcanistsBelt.this, stack, BELT_SLOT_COUNT[Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.POUCHES))]);
                gui.build();
                gui.open();
            }
            return class_1269.field_52422;
        }

        public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 playerEntity, class_5630 cursorStackReference) {
            if (playerEntity.method_37908().field_9236 || !(playerEntity instanceof class_3222)) {
                return false;
            }
            class_3222 player = (class_3222)playerEntity;
            if (clickType == class_5536.field_27013 && otherStack.method_7960()) {
                return false;
            }
            class_9288 beltItems = (class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
            List beltList = beltItems.method_57489().toList();
            if (clickType == class_5536.field_27013 && !otherStack.method_7960()) {
                if (!ArcanistsBeltSlot.isValidItem(otherStack)) {
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_52372, (float)1.0f, (float)1.0f);
                } else {
                    class_3545 addPair;
                    int size = BELT_SLOT_COUNT[Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.POUCHES))];
                    int count = otherStack.method_7947();
                    if (count == ((class_1799)(addPair = MinecraftUtils.tryAddStackToContainerComp((class_9288)beltItems, (int)size, (class_1799)otherStack)).method_15441()).method_7947()) {
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_52372, (float)1.0f, (float)1.0f);
                    } else {
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_34376, (float)0.8f, (float)(0.8f + player.method_51469().method_8409().method_43057() * 0.4f));
                        stack.method_57379(class_9334.field_49622, (Object)((class_9288)addPair.method_15442()));
                    }
                }
                ArcanistsBelt.this.buildItemLore(stack, player.method_5682());
                return true;
            }
            if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
                boolean found = false;
                for (class_1799 itemStack : beltList.reversed()) {
                    if (itemStack.method_7960()) continue;
                    cursorStackReference.method_32332(itemStack.method_51164());
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_34377, (float)0.8f, (float)(0.8f + player.method_51469().method_8409().method_43057() * 0.4f));
                    found = true;
                    break;
                }
                if (found) {
                    stack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(beltList));
                    ArcanistsBelt.this.buildItemLore(stack, player.method_5682());
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

