/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.achievements.TimedAchievement;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.blocks.forge.TwilightAnvilBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.arcananovum.events.BinaryBladesMaxEnergyEvent;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.borislib.events.Event;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10707;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2616;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_9274;
import net.minecraft.class_9280;
import net.minecraft.class_9285;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9886;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class BinaryBlades
extends EnergyItem {
    public static final String ID = "binary_blades";
    public static final String SPLIT_TAG = "split";
    public static final String FAKE_TAG = "fake";
    public static final String LAST_HIT_TAG = "last_hit";
    public static final String MOVE_SPEED_TAG = "binary_move_speed";
    public static final String ATTACK_SPEED_TAG = "binary_attack_speed";
    public static final String ATTACK_DAMAGE_TAG = "binary_attack_damage";

    public BinaryBlades() {
        this.id = ID;
        this.name = "Binary Blades";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_8371;
        this.item = new BinaryBladesItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.binary_blades", (String)this.name).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_STARDUST, ResearchTasks.INFUSE_ITEM, ResearchTasks.OBTAIN_NETHERITE_SWORD, ResearchTasks.OBTAIN_NETHER_STAR, ResearchTasks.UNLOCK_STELLAR_CORE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        BinaryBlades.putProperty(stack, SPLIT_TAG, false);
        BinaryBlades.putProperty(stack, FAKE_TAG, false);
        this.setPrefStack(stack);
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        boolean split = BinaryBlades.getBooleanProperty(stack, SPLIT_TAG);
        boolean fake = BinaryBlades.getBooleanProperty(stack, FAKE_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        BinaryBlades.putProperty(newStack, SPLIT_TAG, split);
        BinaryBlades.putProperty(newStack, FAKE_TAG, fake);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Two ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"blades ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"forged by ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"starlight").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)", bound together like ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"twin stars").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Wielding the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"blade ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"splits it in two").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)", and ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"rejoins ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"after ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"combat").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"With each ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"strike ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"swords ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"harmonize together, ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"empowering ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"your ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"strikes").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Attacking ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"an ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"enemy ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"grants ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"ramping ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"movement ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"attack speed").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        TwilightAnvilBlockEntity.AnvilOutputSet outputSet;
        class_3218 serverWorld;
        TwilightAnvilBlockEntity twilightAnvil;
        class_1799 sword1 = inv.method_5438(6);
        class_1799 sword2 = inv.method_5438(18);
        class_1799 combinedSword = sword1.method_7972();
        class_1937 class_19372 = starlightForge.method_10997();
        if (class_19372 instanceof class_3218 && (twilightAnvil = (TwilightAnvilBlockEntity)starlightForge.getForgeAddition(serverWorld = (class_3218)class_19372, ArcanaRegistry.TWILIGHT_ANVIL_BLOCK_ENTITY)) != null && !(outputSet = twilightAnvil.calculateOutput(sword1, sword2)).output().method_7960()) {
            combinedSword = outputSet.output().method_7972();
        }
        class_1799 newArcanaItem = this.getNewItem();
        if (combinedSword.method_7942()) {
            class_1890.method_57530((class_1799)newArcanaItem, (class_9304)combinedSword.method_58657());
        }
        if (BinaryBlades.hasProperty(combinedSword, EnhancedStatUtils.ENHANCED_STAT_TAG)) {
            EnhancedStatUtils.enhanceItem(newArcanaItem, BinaryBlades.getDoubleProperty(combinedSword, EnhancedStatUtils.ENHANCED_STAT_TAG));
        }
        return newArcanaItem;
    }

    private class_10707 getWhiteDwarfBlock(class_1799 item) {
        if (!(ArcanaItemUtils.identifyItem(item) instanceof BinaryBlades)) {
            return null;
        }
        int whiteDwarf = ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.WHITE_DWARF_BLADES.id);
        if (whiteDwarf < 1) {
            return null;
        }
        float[] reducePercentages = new float[]{0.0f, 0.5f, 0.75f, 1.0f};
        class_10707 blockComp = new class_10707(0.15f, 0.5f, List.of(new class_10707.class_10708(60.0f, Optional.empty(), 0.0f, reducePercentages[whiteDwarf])), new class_10707.class_10709(1.0f, 1.0f, 1.0f), Optional.of(class_8103.field_56242), Optional.of(class_7923.field_41172.method_47983((Object)class_3417.field_49779)), Optional.of(class_3417.field_15239));
        return blockComp;
    }

    private class_1799 getFakeItem(class_1799 item) {
        boolean white;
        if (!(ArcanaItemUtils.identifyItem(item) instanceof BinaryBlades)) {
            return item;
        }
        class_1799 fake = item.method_7972();
        BinaryBlades.putProperty(fake, FAKE_TAG, true);
        BinaryBlades.putProperty(fake, "uuid", "00000000-0000-4000-8000-000000000000");
        boolean bl = white = ArcanaAugments.getAugmentOnItem(fake, ArcanaAugments.WHITE_DWARF_BLADES.id) > 0;
        if (white) {
            fake.method_57379(class_9334.field_56396, (Object)this.getWhiteDwarfBlock(item));
        }
        fake.method_57381(class_9334.field_49636);
        fake.method_57381(class_9334.field_53966);
        return fake;
    }

    public void rebuildAttributes(class_1799 stack) {
        if (!stack.method_31574(this.item)) {
            return;
        }
        int energy = this.getEnergy(stack);
        class_9285 modifiers = (class_9285)stack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
        ArrayList<class_9285.class_9287> attributeList = new ArrayList<class_9285.class_9287>();
        boolean redGiant = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.RED_GIANT_BLADES) > 0;
        for (class_9285.class_9287 entry : modifiers.comp_2393()) {
            class_1322 modifier = entry.comp_2396();
            if (modifier.comp_2447().toString().contains(MOVE_SPEED_TAG) || modifier.comp_2447().toString().contains(ATTACK_SPEED_TAG) || modifier.comp_2447().toString().contains(ATTACK_DAMAGE_TAG)) continue;
            attributeList.add(entry);
        }
        if (energy > 0) {
            attributeList.add(new class_9285.class_9287(class_5134.field_23719, new class_1322(class_2960.method_60655((String)"arcananovum", (String)MOVE_SPEED_TAG), 0.5 * (double)this.getEnergy(stack) / (double)this.getMaxEnergy(stack), class_1322.class_1323.field_6330), class_9274.field_49217));
            attributeList.add(new class_9285.class_9287(class_5134.field_23723, new class_1322(class_2960.method_60655((String)"arcananovum", (String)ATTACK_SPEED_TAG), (double)this.getEnergy(stack) / (double)this.getMaxEnergy(stack), class_1322.class_1323.field_6328), class_9274.field_49217));
            if (redGiant && energy >= 50) {
                attributeList.add(new class_9285.class_9287(class_5134.field_23721, new class_1322(class_2960.method_60655((String)"arcananovum", (String)ATTACK_DAMAGE_TAG), 4.0 * ((double)this.getEnergy(stack) - 50.0) / ((double)this.getMaxEnergy(stack) - 50.0), class_1322.class_1323.field_6328), class_9274.field_49217));
            }
        }
        class_9285 newComponent = new class_9285(attributeList);
        stack.method_57379(class_9334.field_49636, (Object)newComponent);
    }

    private class_124 getColor(class_1799 stack) {
        boolean red;
        boolean pulsar = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.PULSAR_BLADES.id) > 0;
        boolean white = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.WHITE_DWARF_BLADES.id) > 0;
        boolean bl = red = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.RED_GIANT_BLADES.id) > 0;
        if (pulsar) {
            return class_124.field_1075;
        }
        if (white) {
            return class_124.field_1068;
        }
        if (red) {
            return class_124.field_1061;
        }
        return class_124.field_1054;
    }

    public static boolean isFakeBlade(class_1799 stack) {
        return stack.method_31574(ArcanaRegistry.BINARY_BLADES.getItem()) && ArcanaItem.getBooleanProperty(stack, FAKE_TAG);
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        return 100;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8601, 32);
        ArcanaIngredient b = new ArcanaIngredient(ArcanaRegistry.STARDUST, 32);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8477, 8);
        ArcanaIngredient e = new ArcanaIngredient(class_1802.field_8137, 4);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_22022, 1, true);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8183, 48);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_22020, 4);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, e}, {b, g, h, a, b}, {c, h, m, h, c}, {b, a, h, g, b}, {e, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil().withCore());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Binary Blades").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nGazing up at the stars one night led me to observe two close stars dancing in the sky. Two stars harmoniously acting as one. Glancing over at my Forge gave me an idea.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Binary Blades").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nThe Binary Blades are two swords that act in unison, combining into one when stored and splitting in two when held. They grant an increased attack speed compared to normal weapons, with each strike acting like a note in a harmony. ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Binary Blades").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nSuccessive strikes grant the wielder increased movement and attack speed.").method_27692(class_124.field_1074)));
        return list;
    }

    public class BinaryBladesItem
    extends ArcanaPolymerItem {
        public BinaryBladesItem() {
            super(BinaryBlades.this.getThis(), BinaryBlades.this.getEquipmentArcanaItemComponents().method_66333(class_9886.field_52590, 2.0f, -1.2f));
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            boolean red;
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            boolean split = ArcanaItem.getBooleanProperty(itemStack, BinaryBlades.SPLIT_TAG);
            boolean pulsar = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.PULSAR_BLADES.id) > 0;
            boolean white = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.WHITE_DWARF_BLADES.id) > 0;
            boolean bl = red = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.RED_GIANT_BLADES.id) > 0;
            if (pulsar) {
                stringList.add(split ? "singular_pulsar" : "combined_pulsar");
            } else if (white) {
                stringList.add(split ? "singular_white" : "combined_white");
            } else if (red) {
                stringList.add(split ? "singular_red" : "combined_red");
            } else {
                stringList.add(split ? "singular" : "combined");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return BinaryBlades.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            boolean fake = ArcanaItem.getBooleanProperty(stack, BinaryBlades.FAKE_TAG);
            if (fake) {
                if (!player.method_6079().equals(stack) || !player.method_6047().method_31574((class_1792)this)) {
                    stack.method_7939(0);
                    ArcanaNovum.data((class_1657)player).restoreOffhand();
                } else {
                    boolean red2;
                    class_1799 mainStack = player.method_6047();
                    boolean pulsar1 = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.PULSAR_BLADES.id) > 0;
                    boolean white1 = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.WHITE_DWARF_BLADES.id) > 0;
                    boolean red1 = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.RED_GIANT_BLADES.id) > 0;
                    boolean pulsar2 = ArcanaAugments.getAugmentOnItem(mainStack, ArcanaAugments.PULSAR_BLADES.id) > 0;
                    boolean white2 = ArcanaAugments.getAugmentOnItem(mainStack, ArcanaAugments.WHITE_DWARF_BLADES.id) > 0;
                    boolean bl = red2 = ArcanaAugments.getAugmentOnItem(mainStack, ArcanaAugments.RED_GIANT_BLADES.id) > 0;
                    if (pulsar1 ^ pulsar2 || white1 ^ white2 || red1 ^ red2) {
                        ArcanaNovum.data((class_1657)player).restoreOffhand();
                        ArcanaNovum.data((class_1657)player).storeOffhand(BinaryBlades.this.getFakeItem(mainStack));
                    }
                }
                return;
            }
            boolean split = ArcanaItem.getBooleanProperty(stack, BinaryBlades.SPLIT_TAG);
            class_1799 handStack = player.method_6047();
            int energy = BinaryBlades.this.getEnergy(stack);
            if (handStack.equals(stack)) {
                if (!split) {
                    ArcanaItem.putProperty(stack, BinaryBlades.SPLIT_TAG, true);
                }
                if (!player.method_6079().method_31574((class_1792)this)) {
                    ArcanaNovum.data((class_1657)player).restoreOffhand();
                    ArcanaNovum.data((class_1657)player).storeOffhand(BinaryBlades.this.getFakeItem(stack));
                }
                if (world.method_8503().method_3780() % 40 == 0 || energy > 0 && energy < BinaryBlades.this.getMaxEnergy(stack)) {
                    char[] unicodeChars = new char[]{'\u2581', '\u2582', '\u2583', '\u2585', '\u2586', '\u2587', '\u258c'};
                    StringBuilder message = new StringBuilder("\ud83d\udde1 \u2726 ");
                    for (int i = 0; i < 10; ++i) {
                        int segmentValue = energy - i * 10;
                        if (segmentValue <= 0) {
                            message.append(unicodeChars[0]);
                            continue;
                        }
                        if (segmentValue >= 10) {
                            message.append(unicodeChars[unicodeChars.length - 1]);
                            continue;
                        }
                        int charIndex = (int)((double)segmentValue / 10.0 * (double)(unicodeChars.length - 1));
                        message.append(unicodeChars[charIndex]);
                    }
                    message.append(" \u2726 \ud83d\udde1");
                    player.method_7353((class_2561)class_2561.method_43470((String)message.toString()).method_27692(BinaryBlades.this.getColor(stack)), true);
                }
            } else if (split) {
                ArcanaItem.putProperty(stack, BinaryBlades.SPLIT_TAG, false);
            }
            if (world.method_8503().method_3780() % 5 == 0) {
                int lastHitTime;
                int redGiant = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.RED_GIANT_BLADES);
                if (energy >= 50 && redGiant >= 2) {
                    ArrayList entities = new ArrayList(player.method_51469().method_8333((class_1297)player, player.method_5829().method_1014(8.0), e -> (double)e.method_5739((class_1297)player) <= 3.5));
                    for (class_1297 nearEntity : entities) {
                        if (!(nearEntity instanceof class_1309)) continue;
                        class_1309 living = (class_1309)nearEntity;
                        if (nearEntity.method_5753()) continue;
                        living.method_5639(3.0f);
                    }
                    ArcanaEffectUtils.circle((class_3218)player.method_51469(), null, (class_243)player.method_19538().method_1031(0.0, 0.2, 0.0), (class_2394)class_2398.field_11240, (double)0.5, (int)8, (int)2, (double)0.1, (double)0.05);
                }
                if ((lastHitTime = ArcanaItem.getIntProperty(stack, BinaryBlades.LAST_HIT_TAG)) > 0) {
                    ArcanaItem.putProperty(stack, BinaryBlades.LAST_HIT_TAG, lastHitTime - 1);
                } else if (lastHitTime == 0) {
                    ArcanaItem.putProperty(stack, BinaryBlades.LAST_HIT_TAG, -1);
                } else {
                    BinaryBlades.this.addEnergy(stack, -4);
                }
            }
            if (energy >= BinaryBlades.this.getMaxEnergy(stack)) {
                Event.addEvent((Event)new BinaryBladesMaxEnergyEvent(player));
                long count = Event.getEventsOfType(BinaryBladesMaxEnergyEvent.class).stream().filter(event -> event.getPlayer().equals((Object)player)).count();
                if (count >= (long)((TimedAchievement)ArcanaAchievements.STARBURST_STREAM).getGoal()) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.STARBURST_STREAM);
                }
                if (world.method_8503().method_3780() % 20 == 0) {
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.BINARY_BLADES_MAX_ENERGY_PER_SECOND));
                }
            }
            BinaryBlades.this.rebuildAttributes(stack);
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            boolean fake = ArcanaItem.getBooleanProperty(stack, BinaryBlades.FAKE_TAG);
            boolean split = ArcanaItem.getBooleanProperty(stack, BinaryBlades.SPLIT_TAG);
            class_10707 blocksAttacksComponent = (class_10707)stack.method_58694(class_9334.field_56396);
            if (blocksAttacksComponent != null) {
                playerEntity.method_6019(hand);
                return class_1269.field_21466;
            }
            if (fake || !split) {
                return class_1269.field_5811;
            }
            int pulsar = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.PULSAR_BLADES);
            int energy = BinaryBlades.this.getEnergy(stack);
            int energyCost = 25 * (3 - pulsar);
            int energyGain = 0;
            if (pulsar > 0 && energy > energyCost) {
                MinecraftUtils.LasercastResult lasercast = MinecraftUtils.lasercast((class_1937)world, (class_243)player.method_33571(), (class_243)player.method_5663(), (double)25.0, (boolean)true, (class_1297)player);
                float damage = pulsar * 7;
                for (class_1297 hit : lasercast.sortedHits()) {
                    double dp;
                    class_3222 hitPlayer;
                    if (hit instanceof class_3222 && (hitPlayer = (class_3222)hit).method_6039() && (dp = hitPlayer.method_5663().method_1029().method_1026(lasercast.direction().method_1029())) < -0.6) {
                        ArcanaUtils.blockWithShield((class_1309)hitPlayer, damage);
                        continue;
                    }
                    hit.method_64397(player.method_51469(), ArcanaDamageTypes.of((class_1937)player.method_51469(), ArcanaDamageTypes.PHOTONIC, (class_1297)player), damage);
                    ArcanaItem.putProperty(stack, BinaryBlades.LAST_HIT_TAG, 20);
                    energyGain += 10;
                }
                ArcanaEffectUtils.pulsarBladeShoot(player.method_51469(), player.method_33571().method_1023(0.0, (double)(player.method_17682() / 4.0f), 0.0), lasercast.endPos(), 0);
                SoundUtils.playSound((class_1937)player.method_51469(), (class_2338)player.method_24515(), (class_3414)class_3417.field_19344, (class_3419)class_3419.field_15248, (float)1.0f, (float)2.0f);
                BinaryBlades.this.addEnergy(stack, energyGain - energyCost);
                player.method_7357().method_62835(stack, 10);
                player.method_51469().method_14178().method_18751((class_1297)player, (class_2596)new class_2616((class_1297)player, 3));
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }

        public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 player, class_5630 cursorStackReference) {
            boolean superRet = super.method_31566(stack, otherStack, slot, clickType, player, cursorStackReference);
            if (ArcanaItem.getBooleanProperty(stack, BinaryBlades.FAKE_TAG)) {
                stack.method_51164();
                ArcanaNovum.data(player).restoreOffhand();
                return false;
            }
            return superRet;
        }

        public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
            super.method_7852(world, user, stack, remainingUseTicks);
        }
    }
}

