/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.Soulstone;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.SoulstoneIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_8959;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class EssenceEgg
extends ArcanaItem {
    public static final String ID = "essence_egg";
    public static final String USES_TAG = "uses";

    public EssenceEgg() {
        this.id = ID;
        this.name = "Essence Egg";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.vanillaItem = class_1802.field_8265;
        this.item = new EssenceEggItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.essence_egg", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_SOULSTONE, ResearchTasks.FIND_SPAWNER, ResearchTasks.OBTAIN_EGG};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        EssenceEgg.putProperty(stack, "type", "unattuned");
        EssenceEgg.putProperty(stack, USES_TAG, 0);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Harness the power of a filled ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"Soulstone").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"...").method_27692(class_124.field_1076)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"With enough ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"souls").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" a new form can be ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"spawned").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1076)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Spawns").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" a mob of the ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"attuned type").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1076)));
        lore.add(class_2561.method_43470((String)""));
        Object attunedString = "Unattuned";
        int uses = 0;
        if (itemStack != null) {
            String type = EssenceEgg.getType(itemStack);
            uses = EssenceEgg.getUses(itemStack);
            Optional opt = class_1299.method_5898((String)type);
            if (!type.equals("unattuned") && opt.isPresent()) {
                String entityTypeName = ((class_1299)opt.get()).method_5897().getString();
                attunedString = "Attuned - " + entityTypeName;
            }
        }
        lore.add(class_2561.method_43470((String)attunedString).method_27692(class_124.field_1076));
        lore.add(class_2561.method_43470((String)(LevelUtils.readableInt(uses) + " Uses Left")).method_27692(class_124.field_1080));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        int uses = EssenceEgg.getIntProperty(stack, USES_TAG);
        String type = EssenceEgg.getStringProperty(stack, "type");
        class_1799 newStack = super.updateItem(stack, server);
        EssenceEgg.putProperty(newStack, USES_TAG, uses);
        EssenceEgg.putProperty(newStack, "type", type);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    public static void setType(class_1799 stack, String entityId) {
        EssenceEgg.putProperty(stack, "type", entityId);
        ArcanaRegistry.ESSENCE_EGG.buildItemLore(stack, BorisLib.SERVER);
    }

    public static String getType(class_1799 stack) {
        return EssenceEgg.getStringProperty(stack, "type");
    }

    public static int getUses(class_1799 stack) {
        return EssenceEgg.getIntProperty(stack, USES_TAG);
    }

    public static void setUses(class_1799 stack, int uses) {
        if ((uses = class_3532.method_15340((int)uses, (int)0, (int)1000000)) <= 0) {
            stack.method_7934(stack.method_7947());
        } else {
            EssenceEgg.putProperty(stack, USES_TAG, uses);
            ArcanaRegistry.ESSENCE_EGG.buildItemLore(stack, BorisLib.SERVER);
        }
    }

    public static void addUses(class_1799 stack, int uses) {
        int curUses = EssenceEgg.getIntProperty(stack, USES_TAG);
        int newUses = class_3532.method_15340((int)(uses + curUses), (int)0, (int)1000000);
        if (newUses <= 0) {
            stack.method_7934(stack.method_7947());
        } else {
            EssenceEgg.putProperty(stack, USES_TAG, newUses);
            ArcanaRegistry.ESSENCE_EGG.buildItemLore(stack, BorisLib.SERVER);
        }
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_1799 soulstoneStack = inv.method_5438(12);
        class_1799 newArcanaItem = null;
        if (ArcanaItemUtils.identifyItem(soulstoneStack) instanceof Soulstone) {
            int uses = Soulstone.getSouls(soulstoneStack) / Soulstone.tiers[0];
            String essenceType = Soulstone.getType(soulstoneStack);
            newArcanaItem = this.getNewItem();
            EssenceEgg.setType(newArcanaItem, essenceType);
            EssenceEgg.setUses(newArcanaItem, uses);
        }
        return newArcanaItem;
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Essence Egg").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nAs making Soulstones has taught me, keeping souls imprisoned is hard. Making them so they can be released controllably is even harder. Thankfully, I can build off of a Soulstone\u2019s solid foundation.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Essence Egg").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nThis \u2018Egg\u2019 should take the souls from a Soulstone and keep them captive just long enough for me to release them into a new form. Although, it takes 25 souls to form an entirely new creature.\n\nThe Essence Egg can ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Essence Egg").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nbe used one at a time to spawn a mob, or 5 uses (125 souls) can be used on a spawner to change its attunement to the type of essence contained within the Egg.\n").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        SoulstoneIngredient t = new SoulstoneIngredient(Soulstone.tiers[0], true, false, false, null);
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8281, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_22421, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8076, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8067, 16);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, c, h, c, b}, {c, h, t, h, c}, {b, c, h, c, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    public class EssenceEggItem
    extends ArcanaPolymerItem {
        public EssenceEggItem() {
            super(EssenceEgg.this.getThis());
        }

        public class_1799 method_7854() {
            return EssenceEgg.this.prefItem;
        }

        public class_1269 method_7884(class_1838 context) {
            class_1799 stack = context.method_8041();
            try {
                class_1937 world = context.method_8045();
                class_1657 playerEntity = context.method_8036();
                if (!EssenceEgg.getType(stack).equals("unattuned")) {
                    class_2586 blockEntity;
                    class_2586 class_25862;
                    class_2338 blockPos = context.method_8037();
                    class_2680 blockState = world.method_8320(blockPos);
                    if (blockState.method_27852(class_2246.field_10260) && (class_25862 = (blockEntity = world.method_8321(blockPos))) instanceof class_8959) {
                        class_8959 spawner = (class_8959)class_25862;
                        int captiveLevel = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.WILLING_CAPTIVE.id));
                        if (EssenceEgg.getUses(stack) >= 5 - captiveLevel) {
                            class_1299 entityType = (class_1299)class_1299.method_5898((String)EssenceEgg.getType(stack)).get();
                            spawner.method_46408(entityType, world.method_8409());
                            world.method_8413(blockPos, blockState, blockState, 3);
                            blockEntity.method_5431();
                            if (playerEntity instanceof class_3222) {
                                class_3222 player = (class_3222)playerEntity;
                                player.method_7353((class_2561)class_2561.method_43470((String)("The Spawner Assumes the Essence of " + ((class_1299)class_1299.method_5898((String)EssenceEgg.getType(stack)).get()).method_5897().getString())).method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14905, (float)1.0f, (float)0.7f);
                                int xp = ArcanaConfig.getInt(ArcanaRegistry.ESSENCE_EGG_CONVERT);
                                ArcanaNovum.data(playerEntity).addXP(Math.min(0, xp - xp / 5 * captiveLevel));
                                ArcanaAchievements.grant(player, ArcanaAchievements.SOUL_CONVERSION.id);
                            }
                            EssenceEgg.addUses(stack, -5 + captiveLevel);
                        }
                    } else {
                        int splitLevel = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SOUL_SPLIT.id));
                        int efficiencyLevel = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.DETERMINED_SPIRIT.id));
                        if (EssenceEgg.getUses(stack) > 0) {
                            class_3218 serverWorld = world.method_8503().method_3847(world.method_27983());
                            class_243 summonPos = context.method_17698().method_1031(0.0, 0.5, 0.0);
                            class_2487 nbtCompound = new class_2487();
                            nbtCompound.method_10582("id", EssenceEgg.getType(stack));
                            int spawns = Math.random() >= 0.1 * (double)splitLevel ? 1 : 2;
                            for (int i = 0; i < spawns; ++i) {
                                class_1297 newEntity = class_1299.method_71371((class_2487)nbtCompound, (class_1937)serverWorld, (class_3730)class_3730.field_16465, entity -> {
                                    entity.method_5808(summonPos.method_10216(), summonPos.method_10214(), summonPos.method_10215(), entity.method_36454(), entity.method_36455());
                                    return entity;
                                });
                                if (newEntity instanceof class_1308) {
                                    class_1308 mobEntity = (class_1308)newEntity;
                                    mobEntity.method_5943((class_5425)serverWorld, serverWorld.method_8404(newEntity.method_24515()), class_3730.field_16465, null);
                                }
                                serverWorld.method_30736(newEntity);
                            }
                            if (Math.random() >= 0.1 * (double)efficiencyLevel) {
                                EssenceEgg.addUses(stack, -1);
                            }
                            if (playerEntity instanceof class_3222) {
                                class_3222 player = (class_3222)playerEntity;
                                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15013, (float)1.0f, (float)1.5f);
                                ArcanaNovum.data(playerEntity).addXP(ArcanaConfig.getInt(ArcanaRegistry.ESSENCE_EGG_SPAWN));
                                ArcanaAchievements.progress(player, ArcanaAchievements.SOUL_FOR_SOUL.id, 1);
                            }
                        }
                    }
                }
                return class_1269.field_52422;
            }
            catch (Exception e) {
                e.printStackTrace();
                return class_1269.field_5811;
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 item = playerEntity.method_5998(hand);
            if (playerEntity.method_68878()) {
                if (!EssenceEgg.getType(item).equals("unattuned")) {
                    EssenceEgg.addUses(item, 1);
                }
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }

        public void method_7873(class_1799 stack, class_1309 entity, class_1309 attacker) {
            String type;
            if (!(attacker instanceof class_1657)) {
                return;
            }
            class_1657 playerEntity = (class_1657)attacker;
            if (playerEntity.method_68878() && (type = EssenceEgg.getType(stack)).equals("unattuned") && entity instanceof class_1308) {
                class_1308 attackedEntity = (class_1308)entity;
                if (playerEntity instanceof class_3222) {
                    class_3222 player = (class_3222)playerEntity;
                    if (entity.method_5864().method_20210(ArcanaRegistry.ESSENCE_EGG_DISALLOWED)) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"The Essence Egg cannot attune to this creature.").method_27695(new class_124[]{class_124.field_1079, class_124.field_1056}), true);
                    } else {
                        String entityTypeId = class_1299.method_5890((class_1299)attackedEntity.method_5864()).toString();
                        String entityTypeName = ((class_1299)class_1299.method_5898((String)entityTypeId).get()).method_5897().getString();
                        EssenceEgg.setType(stack, entityTypeId);
                        player.method_7353((class_2561)class_2561.method_43470((String)("The Essence Egg attunes to the essence of " + entityTypeName)).method_27695(new class_124[]{class_124.field_1079, class_124.field_1056}), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_23118, (float)1.0f, (float)0.5f);
                    }
                }
            }
        }
    }
}

