/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.gui.greaves.GreavesOfGaialtusGui;
import net.borisshoes.arcananovum.gui.greaves.GreavesSlot;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10192;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5536;
import net.minecraft.class_5630;
import net.minecraft.class_6880;
import net.minecraft.class_8051;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class GreavesOfGaialtus
extends ArcanaItem {
    public static final String ID = "greaves_of_gaialtus";

    public GreavesOfGaialtus() {
        this.id = ID;
        this.name = "Greaves Of Gaialtus";
        this.rarity = ArcanaRarity.DIVINE;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_8348;
        this.item = new GreavesOfGaialtusItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.greaves_of_gaialtus", (String)this.name).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_GREAVES_OF_GAIALTUS};
        this.attributions = new class_3545[]{new class_3545((Object)class_2561.method_43471((String)"credits_and_attribution.arcananovum.texture_by"), (Object)class_2561.method_43470((String)"tcmEcho")), new class_3545((Object)class_2561.method_43471((String)"credits_and_attribution.arcananovum.model_by"), (Object)class_2561.method_43470((String)"tcmEcho"))};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        GreavesOfGaialtus.putProperty(stack, "active", true);
        this.setPrefStack(stack);
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        boolean active = GreavesOfGaialtus.getBooleanProperty(stack, "active");
        class_1799 newStack = super.updateItem(stack, server);
        GreavesOfGaialtus.putProperty(newStack, "active", active);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A manifestation of ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"nature's ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"nurturing ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"protective ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"embrace.").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Wearing them makes your mind ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"surge ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"with ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"creativity").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"pants ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"are ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"unbreakable").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" and act as ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"unenchanted netherite").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"greaves'").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" pockets are deep as the ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"ocean ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"and can hold many ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"blocks").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"greaves ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"will ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"refill ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"your inventory with ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"blocks").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" as you use them.").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to access the ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"greaves'").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" pockets.").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click in offhand").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to toggle the ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"greaves'").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" auto-refill.").method_27692(class_124.field_1077)));
        if (itemStack != null) {
            List<class_3545<class_1792, Integer>> cargo = this.getCargoList(itemStack);
            if (cargo.isEmpty()) {
                lore.add(class_2561.method_43470((String)""));
                lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Contents: ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"Empty").method_27692(class_124.field_1075)));
            } else {
                lore.add(class_2561.method_43470((String)""));
                lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Contents: ").method_27692(class_124.field_1077)));
                int leftOverCount = 0;
                for (int i = 0; i < cargo.size(); ++i) {
                    int count = (Integer)cargo.get(i).method_15441();
                    if (i >= 10) {
                        leftOverCount += count;
                        continue;
                    }
                    class_1792 item = (class_1792)cargo.get(i).method_15442();
                    int stacks = count / item.method_7882();
                    int leftover = count % item.method_7882();
                    if (count > item.method_7882()) {
                        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)("" + count)).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" (").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)(stacks + " Stacks + " + leftover)).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)") of ").method_27692(class_124.field_1077)).method_10852((class_2561)item.method_63680().method_27661().method_27692(class_124.field_1075)));
                        continue;
                    }
                    lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)("" + count)).method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" of ").method_27692(class_124.field_1077)).method_10852((class_2561)item.method_63680().method_27661().method_27692(class_124.field_1075)));
                }
                if (leftOverCount > 0) {
                    lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)("" + leftOverCount)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" more items of ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)("" + (cargo.size() - 10))).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" types...").method_27692(class_124.field_1060)));
                }
            }
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Greaves Of\n      Gaialtus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nEquayus once spoke to me of Gaialtus, the long lost progenitor of the Overworld. They mentioned only good things, a seemingly rare attitude towards the so-called").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Greaves Of\n      Gaialtus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\n\u2018progenitors\u2019.\n\nEquayus said that they met once, and Gaialtus was kind enough to offer them something incredibly important; a wonderfully cryptic tale.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Greaves Of\n      Gaialtus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nThese Greaves contain a condensed fraction of their essence, that of creativity and protection. \nThey are similar to Netherite, but are incredibly cozy, and have pockets that ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Greaves Of\n      Gaialtus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\ncould fit mountains inside.\n\nSneak Using the Greaves access their pockets, where copious amounts of building blocks can be stored. \n\n ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Greaves Of\n      Gaialtus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nSneak Using in my off-hand toggles the Greaves ability to auto-refill my hands with the stored blocks.\n\nThe pockets can also be accessed similar to a Bundle in my inventory.").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    public class_1799 onAugment(class_1799 stack, ArcanaAugment augment, int level) {
        if (ArcanaItemUtils.identifyItem(stack) instanceof GreavesOfGaialtus) {
            if (augment == ArcanaAugments.NATURES_EMBRACE && level >= 1) {
                EnhancedStatUtils.enhanceItem(stack, 1.0);
            } else if (augment == ArcanaAugments.CREATORS_TOUCH && level >= 1) {
                class_9285 modifiers = (class_9285)stack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
                ArrayList<class_9285.class_9287> attributeList = new ArrayList<class_9285.class_9287>();
                for (class_9285.class_9287 entry : modifiers.comp_2393()) {
                    if (entry.method_60767(class_5134.field_47758, class_2960.method_60655((String)"arcananovum", (String)this.id))) continue;
                    attributeList.add(entry);
                }
                attributeList.add(new class_9285.class_9287(class_5134.field_47758, new class_1322(class_2960.method_60655((String)"arcananovum", (String)this.id), 1.5, class_1322.class_1323.field_6328), class_9274.field_49221));
                class_9285 newComponent = new class_9285(attributeList);
                stack.method_57379(class_9334.field_49636, (Object)newComponent);
            }
        }
        return stack;
    }

    public List<class_3545<class_1792, Integer>> getCargoList(class_1799 greaves) {
        ArrayList<class_3545<class_1792, Integer>> list = new ArrayList<class_3545<class_1792, Integer>>();
        if (!(ArcanaItemUtils.identifyItem(greaves) instanceof GreavesOfGaialtus)) {
            return list;
        }
        class_9288 containerItems = (class_9288)greaves.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        containerItems.method_57489().forEach(stack -> {
            if (stack.method_7960()) {
                return;
            }
            class_1792 item = stack.method_7909();
            boolean found = false;
            for (class_3545 pair : list) {
                if (pair.method_15442() != item) continue;
                pair.method_34965((Object)((Integer)pair.method_15441() + stack.method_7947()));
                found = true;
                break;
            }
            if (!found) {
                list.add(new class_3545((Object)item, (Object)stack.method_7947()));
            }
        });
        list.sort((pair1, pair2) -> ((Integer)pair2.method_15441()).compareTo((Integer)pair1.method_15441()));
        return list;
    }

    public class_1799 getStackOf(class_1799 greaves, class_1799 refillStack) {
        if (!(ArcanaItemUtils.identifyItem(greaves) instanceof GreavesOfGaialtus)) {
            return class_1799.field_8037;
        }
        List stacks = MinecraftUtils.getMatchingItemsFromContainerComp((class_1799)greaves, (class_1792)refillStack.method_7909());
        class_1799 returnStack = class_1799.field_8037;
        for (class_1799 stack : stacks) {
            if (!class_1799.method_31577((class_1799)refillStack, (class_1799)stack) || !returnStack.method_7960() && stack.method_7947() >= returnStack.method_7947()) continue;
            returnStack = stack;
        }
        return returnStack;
    }

    public class GreavesOfGaialtusItem
    extends ArcanaPolymerItem {
        public static final int[] GREAVES_SLOT_COUNT = new int[]{18, 27, 36, 45, 54};

        public GreavesOfGaialtusItem() {
            super(GreavesOfGaialtus.this.getThis(), GreavesOfGaialtus.this.getEquipmentArcanaItemComponents().method_66332(class_1740.field_21977, class_8051.field_41936).method_57349(class_9334.field_49622, (Object)class_9288.field_49334));
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            class_10192 equippableComponent = (class_10192)baseStack.method_58694(class_9334.field_54196);
            class_10192 newComp = class_10192.method_64202((class_1304)equippableComponent.comp_3174()).method_64205(equippableComponent.comp_3175()).method_64204(class_5321.method_29179(ArcanaRegistry.EQUIPMENT_ASSET_REGISTRY_KEY, (class_2960)class_2960.method_60655((String)"arcananovum", (String)GreavesOfGaialtus.ID))).method_64203();
            baseStack.method_57379(class_9334.field_54196, (Object)newComp);
            return baseStack;
        }

        public class_1799 method_7854() {
            return GreavesOfGaialtus.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_3222 player;
            if (playerEntity instanceof class_3222 && (player = (class_3222)playerEntity).method_5715()) {
                class_1799 stack = playerEntity.method_5998(hand);
                if (hand == class_1268.field_5808) {
                    GreavesOfGaialtusGui gui = new GreavesOfGaialtusGui(player, GreavesOfGaialtus.this, stack, GREAVES_SLOT_COUNT[Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.PLANETARY_POCKETS))]);
                    gui.build();
                    gui.open();
                } else if (hand == class_1268.field_5810) {
                    boolean active = !ArcanaItem.getBooleanProperty(stack, "active");
                    ArcanaItem.putProperty(stack, "active", active);
                    if (active) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"Your pockets zip open").method_27695(new class_124[]{class_124.field_1077, class_124.field_1056}), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_6880)class_3417.field_14581, (float)0.5f, (float)1.2f);
                    } else {
                        player.method_7353((class_2561)class_2561.method_43470((String)"Your pockets zip closed").method_27695(new class_124[]{class_124.field_1077, class_124.field_1056}), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_6880)class_3417.field_14581, (float)0.5f, (float)0.7f);
                    }
                }
                class_1661 inv = player.method_31548();
                player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), hand == class_1268.field_5808 ? 36 + inv.method_67532() : 45, stack));
                player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), 7, player.method_6118(class_1304.field_6172)));
                return class_1269.field_52422;
            }
            return super.method_7836(world, playerEntity, hand);
        }

        public boolean method_31566(class_1799 stack, class_1799 otherStack, class_1735 slot, class_5536 clickType, class_1657 playerEntity, class_5630 cursorStackReference) {
            if (playerEntity.method_37908().field_9236 || !(playerEntity instanceof class_3222)) {
                return false;
            }
            class_3222 player = (class_3222)playerEntity;
            if (clickType == class_5536.field_27013 && otherStack.method_7960()) {
                return false;
            }
            class_9288 beltItems = (class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
            List beltList = beltItems.method_57489().toList();
            if (clickType == class_5536.field_27013 && !otherStack.method_7960()) {
                if (!GreavesSlot.isValidItem(otherStack)) {
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_52372, (float)1.0f, (float)1.0f);
                } else {
                    class_3545 addPair;
                    int size = GREAVES_SLOT_COUNT[Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.PLANETARY_POCKETS))];
                    int count = otherStack.method_7947();
                    if (count == ((class_1799)(addPair = MinecraftUtils.tryAddStackToContainerComp((class_9288)beltItems, (int)size, (class_1799)otherStack)).method_15441()).method_7947()) {
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_52372, (float)1.0f, (float)1.0f);
                    } else {
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_34376, (float)0.8f, (float)(0.8f + player.method_51469().method_8409().method_43057() * 0.4f));
                        stack.method_57379(class_9334.field_49622, (Object)((class_9288)addPair.method_15442()));
                    }
                }
                GreavesOfGaialtus.this.buildItemLore(stack, BorisLib.SERVER);
                return true;
            }
            if (clickType == class_5536.field_27014 && otherStack.method_7960()) {
                boolean found = false;
                for (class_1799 itemStack : beltList.reversed()) {
                    if (itemStack.method_7960()) continue;
                    cursorStackReference.method_32332(itemStack.method_51164());
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_34377, (float)0.8f, (float)(0.8f + player.method_51469().method_8409().method_43057() * 0.4f));
                    found = true;
                    break;
                }
                if (found) {
                    stack.method_57379(class_9334.field_49622, (Object)class_9288.method_57493(beltList));
                    GreavesOfGaialtus.this.buildItemLore(stack, BorisLib.SERVER);
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

