/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import eu.pb4.polymer.resourcepack.api.PolymerResourcePackUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.arcananovum.events.NulMementoEvent;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ExplainIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ExplainRecipe;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.Dialog;
import net.borisshoes.arcananovum.utils.DialogHelper;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.arcananovum.utils.LevelUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.events.Event;
import net.borisshoes.borislib.gui.GraphicalItem;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10192;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1740;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_8051;
import net.minecraft.class_8103;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class NulMemento
extends EnergyItem {
    public static final String ID = "nul_memento";
    public static final String HEAD_TAG = "onHead";
    private static final class_1792 textureItem = class_1802.field_27019;

    public NulMemento() {
        this.id = ID;
        this.name = "Nul Memento";
        this.rarity = ArcanaRarity.DIVINE;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.vanillaItem = class_1802.field_8791;
        this.item = new NulMementoItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.nul_memento", (String)this.name).method_27692(class_124.field_1067).method_54663(0x2A2A2A);
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_DIVINE_CATALYST, ResearchTasks.KILL_CONSTRUCT};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        NulMemento.putProperty(stack, "active", false);
        NulMemento.putProperty(stack, HEAD_TAG, false);
        this.setPrefStack(stack);
    }

    @Override
    public void finalizePrefItem(MinecraftServer server) {
        super.finalizePrefItem(server);
        class_1799 curPrefItem = this.getPrefItem();
        curPrefItem.method_57379(class_9334.field_49633, (Object)MinecraftUtils.makeEnchantComponent((class_1889[])new class_1889[]{new class_1889(MinecraftUtils.getEnchantment((class_5455)server.method_30611(), (class_5321)class_1893.field_9111), 4)}));
        this.prefItem = this.buildItemLore(curPrefItem, server);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A strange, ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"withered skull").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" with a distinctive gash.").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Aspect of Death").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" has granted you his ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"favor").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)""));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You have ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"seen ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"things that most ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Players ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"never will.").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"curse of knowledge").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" binds ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"tighter ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"than any other.").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"There are some ").method_27695(new class_124[]{class_124.field_1056, class_124.field_1063})).method_10852((class_2561)class_2561.method_43470((String)"Skills ").method_27695(new class_124[]{class_124.field_1056, class_124.field_1078})).method_10852((class_2561)class_2561.method_43470((String)"that are better left ").method_27695(new class_124[]{class_124.field_1056, class_124.field_1063})).method_10852((class_2561)class_2561.method_43470((String)"forgotten").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080})).method_10852((class_2561)class_2561.method_43470((String)"...").method_27695(new class_124[]{class_124.field_1056, class_124.field_1063})));
        lore.add(class_2561.method_43470((String)""));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"calls ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"to your ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"mind ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"with a familiar ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"burn of concentration").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It ").method_27695(new class_124[]{class_124.field_1056, class_124.field_1063})).method_10852((class_2561)class_2561.method_43470((String)"yearns ").method_27695(new class_124[]{class_124.field_1056, class_124.field_1078})).method_10852((class_2561)class_2561.method_43470((String)"to be worn... To protect you from ").method_27695(new class_124[]{class_124.field_1056, class_124.field_1063})).method_10852((class_2561)class_2561.method_43470((String)"death").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080})).method_10852((class_2561)class_2561.method_43470((String)"...").method_27695(new class_124[]{class_124.field_1056, class_124.field_1063})));
        lore.add(class_2561.method_43470((String)""));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"When ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"activated").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)", all ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Skill Points").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" will be ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"deallocated").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        if (itemStack != null) {
            int energy = this.getEnergy(itemStack);
            if (energy == 0) {
                lore.add(class_2561.method_43470((String)""));
                lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Nul's Ward").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Ready").method_27692(class_124.field_1078)));
            } else {
                String duration = (energy /= 20) >= 100 ? energy / 60 + 1 + " Minutes" : energy + " Seconds";
                lore.add(class_2561.method_43470((String)""));
                lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Nul's Ward").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Recharging: ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)duration).method_27692(class_124.field_1063)));
            }
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 onAugment(class_1799 stack, ArcanaAugment augment, int level) {
        if (ArcanaItemUtils.identifyItem(stack) instanceof NulMemento && augment == ArcanaAugments.DEATHS_CHAMPION && level >= 1) {
            EnhancedStatUtils.enhanceItem(stack, 1.0);
        }
        return stack;
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        return 36000 - 12000 * Math.max(ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.TEMPO_MORTUUS.id), 0);
    }

    public boolean protectFromDeath(class_1799 stack, class_1309 living, class_1282 source, boolean constructInterference) {
        if (source.method_48789(class_8103.field_42242) && !source.method_49708(ArcanaDamageTypes.VENGEANCE_TOTEM) && !source.method_49708(ArcanaDamageTypes.CONCENTRATION)) {
            return false;
        }
        if (this.getEnergy(stack) > 0 && !this.isActive(stack)) {
            return false;
        }
        class_1937 class_19372 = living.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            world.method_65096((class_2394)class_2398.field_11237, living.method_23317(), living.method_23318() + (double)(living.method_17682() / 2.0f), living.method_23321(), 100, 0.4, 0.4, 0.4, 0.07);
        }
        if (living instanceof class_3222) {
            class_3222 player = (class_3222)living;
            DialogHelper dialogHelper = new DialogHelper();
            if (this.isActive(stack)) {
                ArcanaAchievements.grant(player, ArcanaAchievements.DEATHS_DOOR.id);
                dialogHelper.sendDialog(List.of(player), new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Now is no time to die on me. Pull yourself together!").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 1.4f))), new int[0], 1, 1, -1), true);
                living.method_6033(1.0f);
                living.method_6092(new class_1293(ArcanaRegistry.DEATH_WARD_EFFECT, 600, 0));
                return true;
            }
            if (!constructInterference) {
                dialogHelper.sendDialog(List.of(player), new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Let my gift offer you a second chance.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, -1), true);
            }
            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.NUL_MEMENTO_PROTECT));
        }
        this.setEnergy(stack, this.getMaxEnergy(stack));
        living.method_6033(1.0f);
        living.method_6012();
        living.method_6092(new class_1293(ArcanaRegistry.DEATH_WARD_EFFECT, constructInterference ? 150 : 300, 0));
        living.method_6092(new class_1293(ArcanaRegistry.GREATER_INVISIBILITY_EFFECT, 100, 0));
        living.method_37908().method_8421((class_1297)living, (byte)35);
        return true;
    }

    public boolean isActive(class_1799 stack) {
        return NulMemento.getBooleanProperty(stack, "active");
    }

    public void forgor(class_1799 stack, class_3222 player) {
        NulMemento.putProperty(stack, "active", true);
        int increments = 100;
        class_1293 blind = new class_1293(ArcanaRegistry.GREATER_BLINDNESS_EFFECT, increments * 5, 0, false, false, true);
        class_1293 slow = new class_1293(class_1294.field_5909, increments * 5, 9, false, false, true);
        class_1293 fatigue = new class_1293(class_1294.field_5901, increments * 5, 4, false, false, true);
        class_1293 weakness = new class_1293(class_1294.field_5911, increments * 5, 4, false, false, true);
        player.method_6092(blind);
        player.method_6092(slow);
        player.method_6092(fatigue);
        player.method_6092(weakness);
        boolean[] cont = new boolean[]{true};
        int resolve = ArcanaNovum.data((class_1657)player).getAugmentLevel(ArcanaAugments.RESOLVE.id);
        int maxConc = LevelUtils.concFromXp(ArcanaNovum.data((class_1657)player).getXP(), resolve);
        DialogHelper dialogHelper = new DialogHelper();
        dialogHelper.sendDialog(List.of(player), new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n\n\n\n").method_10852((class_2561)class_2561.method_43470((String)"As the crushing weight of ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"concentration").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" takes your mind you hear the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Nul Memento").method_27692(class_124.field_1067).method_54663(0x2A2A2A)).method_10852((class_2561)class_2561.method_43470((String)" whisper...")).method_27692(class_124.field_1063))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, -1), false);
        Event.addEvent((Event)new NulMementoEvent(increments, player, stack));
        BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(increments * 1, () -> {
            if (cont[0]) {
                class_1799 headStack = player.method_6118(class_1304.field_6169);
                if (!(ArcanaItemUtils.identifyItem(headStack) instanceof NulMemento) || ArcanaItemUtils.getUsedConcentration(player) <= maxConc) {
                    cont[0] = false;
                    this.processHalted(player);
                } else {
                    Event.addEvent((Event)new NulMementoEvent(increments, player, stack));
                    dialogHelper.sendDialog(List.of(player), new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n\n\n\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nFeel the weight, embrace it... let me in...").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, -1), true);
                }
            }
        }));
        BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(increments * 2, () -> {
            if (cont[0]) {
                class_1799 headStack = player.method_6118(class_1304.field_6169);
                if (!(ArcanaItemUtils.identifyItem(headStack) instanceof NulMemento) || ArcanaItemUtils.getUsedConcentration(player) <= maxConc) {
                    cont[0] = false;
                    this.processHalted(player);
                } else {
                    Event.addEvent((Event)new NulMementoEvent(increments, player, stack));
                    dialogHelper.sendDialog(List.of(player), new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n\n\n\n").method_10852((class_2561)class_2561.method_43470((String)"You feel as though your ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"skull").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" is about to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"collapse").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" when a ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"gentle breeze").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" sweeps through you.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, -1), false);
                }
            }
        }));
        BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(increments * 3, () -> {
            if (cont[0]) {
                class_1799 headStack = player.method_6118(class_1304.field_6169);
                if (!(ArcanaItemUtils.identifyItem(headStack) instanceof NulMemento) || ArcanaItemUtils.getUsedConcentration(player) <= maxConc) {
                    cont[0] = false;
                    this.processHalted(player);
                } else {
                    Event.addEvent((Event)new NulMementoEvent(increments, player, stack));
                    dialogHelper.sendDialog(List.of(player), new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n\n\n\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nYour secrets are safe with me. Be free of this burden, for I now bear it alone.").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, -1), true);
                }
            }
        }));
        BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(increments * 4, () -> {
            if (cont[0]) {
                class_1799 headStack = player.method_6118(class_1304.field_6169);
                if (!(ArcanaItemUtils.identifyItem(headStack) instanceof NulMemento) || ArcanaItemUtils.getUsedConcentration(player) <= maxConc) {
                    cont[0] = false;
                    this.processHalted(player);
                } else {
                    Event.addEvent((Event)new NulMementoEvent(increments, player, stack));
                    dialogHelper.sendDialog(List.of(player), new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n\n\n\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nThat is, until we meet again...").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, -1), true);
                }
            }
        }));
        BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(increments * 5, () -> {
            if (cont[0]) {
                class_1799 headStack = player.method_6118(class_1304.field_6169);
                if (!(ArcanaItemUtils.identifyItem(headStack) instanceof NulMemento) || ArcanaItemUtils.getUsedConcentration(player) <= maxConc) {
                    cont[0] = false;
                    this.processHalted(player);
                } else {
                    Event.addEvent((Event)new NulMementoEvent(increments, player, stack));
                    dialogHelper.sendDialog(List.of(player), new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n\n\n\n").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Nul Memento").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" crumbles ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"into").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" ash ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"around your head, your mind still ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"burning").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" from the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"overwhelming ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"Arcana.").method_27692(class_124.field_1076)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, -1), false);
                    class_1293 nausea = new class_1293(class_1294.field_5916, 200, 4, false, false, true);
                    class_1293 ward = new class_1293(ArcanaRegistry.DEATH_WARD_EFFECT, increments * 2, 0, false, false, true);
                    player.method_6092(nausea);
                    player.method_6092(ward);
                    headStack.method_7934(headStack.method_7947());
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14905, (float)1.0f, (float)1.0f);
                }
            }
        }));
        BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(increments * 6, () -> {
            if (cont[0]) {
                Event.addEvent((Event)new NulMementoEvent(increments, player, stack));
                dialogHelper.sendDialog(List.of(player), new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n\n\n\n").method_10852((class_2561)class_2561.method_43470((String)"All of your Skill Points have been deallocated.").method_27692(class_124.field_1075)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, -1), false);
                ArcanaNovum.data((class_1657)player).removeAllAugments();
                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.NUL_MEMENTO_DEALLOCATE));
                ArcanaAchievements.grant(player, ArcanaAchievements.LOST_KNOWLEDGE.id);
                ArcanaAchievements.progress(player, ArcanaAchievements.AMNESIAC.id, 1);
            }
        }));
    }

    private void processHalted(class_3222 player) {
        player.method_7353((class_2561)class_2561.method_43470((String)""), false);
        player.method_7353((class_2561)class_2561.method_43470((String)""), false);
        player.method_7353((class_2561)class_2561.method_43470((String)""), false);
        player.method_7353((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The weight of the ").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)"Nul Memento").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" becomes too much to bare, perhaps you aren't ready...").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})), false);
        player.method_6012();
    }

    public void inventoryDialog(class_3222 player) {
        ArrayList<Dialog> dialogOptions = new ArrayList<Dialog>();
        boolean[] conditions = new boolean[]{ArcanaNovum.data((class_1657)player).hasCrafted(ArcanaRegistry.WINGS_OF_ENDERIA), ArcanaNovum.data((class_1657)player).hasCrafted(ArcanaRegistry.AEQUALIS_SCIENTIA), ArcanaItemUtils.hasItemInInventory((class_1657)player, ArcanaRegistry.PICKAXE_OF_CEPTYUS.getItem()), ArcanaItemUtils.hasItemInInventory((class_1657)player, ArcanaRegistry.AEQUALIS_SCIENTIA.getItem()), ArcanaItemUtils.hasItemInInventory((class_1657)player, class_1802.field_8840), ArcanaItemUtils.hasItemInInventory((class_1657)player, ArcanaRegistry.GREAVES_OF_GAIALTUS.getItem()), ArcanaItemUtils.hasItemInInventory((class_1657)player, ArcanaRegistry.SPEAR_OF_TENBROUS.getItem())};
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"My Chosen... Will you continue show the courage that your peers lack?").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, 0));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"My dear Player, will you help us revitalize these realms to new heights?").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, 0));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Everything faces me once... Few have ever faced me twice.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, 0));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Take care in the dark secrets you seek. For only I can ever take them away.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 1, 1, 0));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"What do you think of my Sister's realm? Do you see the need for my mission now?").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 0, 1, 1));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"So you've met my kin, Equayus? What sort of exchange did you have?").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 0, 1, 2));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"I sense my kin's Arcana on you... I trust your deal was worthwhile.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 0, 1, 2));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Equayus and I might not always see eye to eye, but we both have these realms' best intentions at heart.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 0, 1, 2));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A relic of Ceptyus?! How fascinating! I wonder if it was forgotten as they fled.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 0, 1, 4));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Gaialtus turned its back on this world and left it to fall to ruin. What good is a creator that abandons their creation?").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 0, 1, 32));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"If Gaialtus was still here, none of my work would be necessary. Yet here I am, picking up its slack to maintain peace.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 0, 1, 32));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nGaialtus's negligence is responsible for the decay that has befallen our world. Don't let those trousers sway your mind.\n").method_27692(class_124.field_1063)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Equayus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nBrother, you know not of what you speak. Decay is sometimes a necessary precursor to greater regrowth.").method_27692(class_124.field_1075)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f), new Dialog.DialogSound(class_3417.field_38366, 0.5f, 0.7f))), new int[]{0, 90}, 0, 1, 40));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nEquayus? Have you also taken an interest in this Player?\n").method_27692(class_124.field_1063)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Equayus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nBrother, it is always good to hear your voice again...").method_27692(class_124.field_1075)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f), new Dialog.DialogSound(class_3417.field_38366, 0.5f, 0.7f))), new int[]{0, 60}, 0, 1, 8));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"That Spear you wield harnesses shadow Arcana far darker than anything I have seen, It's almost frightening. Be cautious with it.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 0, 1, 64));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"I never knew such vitriol could come from a mere Spear. Tenbrous must've been quite powerful.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[0], 0, 1, 64));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nYou carry an intriguing weapon... I know little of Tenbrous, I wish we had the chance to meet.\n").method_27692(class_124.field_1063)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nNo one will have to meet that monster EVER again! I made sure of it!\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nAre you sure whatever you did was truly permanent? Such a shame all that power went to waste on you...").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f), new Dialog.DialogSound(class_3417.field_14671, 0.5f, 1.4f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[]{0, 60, 60}, 0, 1, 80));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nSo you too, have taken an interest in this Player now? Do you now share my vision?\n").method_27692(class_124.field_1063)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Equayus").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nThis one is quite curious. I do believe they will help restore this world.\n").method_27692(class_124.field_1075)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nAt last, our goals united again.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f), new Dialog.DialogSound(class_3417.field_38366, 0.5f, 0.7f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 1.2f))), new int[]{0, 60, 60}, 0, 1, 8));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nHeh heh heh, How does it feel to be carried around like a prize, dear Sister?\n").method_27692(class_124.field_1063)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nNUL! YOU DID THIS TO ME! I WILL END YOU!\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nIt was not my actions that led to this. This Player did it of their own power. Perhaps in time your arrogance will turn to humility.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f), new Dialog.DialogSound(class_3417.field_14671, 0.5f, 1.4f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[]{0, 60, 60}, 0, 1, 16));
        dialogOptions.add(new Dialog(new ArrayList<class_5250>(Arrays.asList(class_2561.method_43470((String)"\n").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nI'm sorry it had to come to this, Sister. You had so long to realize your mistakes.\n").method_27692(class_124.field_1063)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nGods do not make mistakes! Our mere thoughts become the laws of our realm!\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nThen I suppose your mistake was defying Tenbrous, and ascending to take its place.\n").method_27692(class_124.field_1063)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Enderia").method_27695(new class_124[]{class_124.field_1064, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\n...\n").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"Nul").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)" ~ ").method_27695(new class_124[]{class_124.field_1074, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)"\nFood for thought, my Sister.").method_27692(class_124.field_1063)))), new ArrayList<Dialog.DialogSound>(Arrays.asList(new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f), new Dialog.DialogSound(class_3417.field_14671, 0.5f, 1.4f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f), new Dialog.DialogSound(class_3417.field_14671, 0.1f, 0.6f), new Dialog.DialogSound(class_3417.field_15163, 0.3f, 0.7f))), new int[]{0, 80, 100, 80, 60}, 0, 1, 16));
        DialogHelper helper = new DialogHelper(dialogOptions, conditions);
        helper.sendDialog(List.of(player), helper.getWeightedResult(), true);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ExplainIngredient a = new ExplainIngredient(GraphicalItem.withColor((GraphicalItem.GraphicElement)GraphicalItem.PAGE_BG, (int)2756918), 1, "", false).withName((class_2561)class_2561.method_43470((String)"In World Recipe").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Build this in the World").method_27692(class_124.field_1064)));
        ExplainIngredient s = new ExplainIngredient(class_1802.field_8067, 1, "Soul Sand or Soil").withName((class_2561)class_2561.method_43470((String)"Soul Sand or Soil").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Construct a Wither Base with a heart of Netherite").method_27692(class_124.field_1064)));
        ExplainIngredient k = new ExplainIngredient(class_1802.field_8791, 1, "Wither Skeleton Skull").withName((class_2561)class_2561.method_43470((String)"Wither Skeleton Skull").method_27695(new class_124[]{class_124.field_1063, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Construct a Wither Base with a heart of Netherite").method_27692(class_124.field_1064)));
        ExplainIngredient n = new ExplainIngredient(class_1802.field_22018, 1, "Netherite Block").withName((class_2561)class_2561.method_43470((String)"Block of Netherite").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"Construct a Wither Base with a heart of Netherite").method_27692(class_124.field_1064)));
        ExplainIngredient c = new ExplainIngredient(ArcanaRegistry.DIVINE_CATALYST.getItem(), 1, "Divine Augment Catalyst").withName((class_2561)class_2561.method_43470((String)"Divine Augmentation Catalyst").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).withLore(List.of(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Catalyst").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" on the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Netherite Heart").method_27692(class_124.field_1079)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Divine Energy").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" will flow into the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Exalted Construct").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" empowering it").method_27692(class_124.field_1064)), class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Defeat the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Exalted Construct").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)" without dying to receive a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Nul Memento").method_27692(class_124.field_1074)), class_2561.method_43470((String)""), class_2561.method_43470((String)"WARNING!!! This fight is considerably harder than a Nul Construct. Attempt at your own peril.").method_27692(class_124.field_1061)));
        ExplainIngredient[][] ingredients = new ExplainIngredient[][]{{a, a, a, a, a}, {a, k, k, k, a}, {a, s, n, s, c}, {a, a, s, a, a}, {a, a, a, a, a}};
        return new ExplainRecipe(ingredients);
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Nul Memento").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThis entity of Death that I have acquired a passing familiarity with is most intriguing. He wanted me to prove my fighting prowess by dueling his creation, and I believe I succeeded. I was gifted this strange ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Nul Memento").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nskull, and was informed that I have become one of his \u2018chosen\u2019.\nI\u2019m not sure what to think of this. What machinations could a Deity of Death be planning such that he needs help from me? The Memento whispers to me every so often.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Nul Memento").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nI have come to learn the entity calls himself Nul, the God of Death and Knowledge. He speaks of Arcana, and secrets that I have yet to learn. He warns that one mind can only hold so much knowledge at one time. ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Nul Memento").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nHowever, he offers his aid in circumventing this limitation. \nThis Memento reacts to an overburdened mind when worn and will make me forget all of the skills I have learned. ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Nul Memento").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nAs long as I use those skills before forgetting them, I should be able to take advantage of new knowledge with a new limit to what I can learn.\nThe Memento also offers incredible protection, as if it ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Nul Memento").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nwere made of enchanted Netherite!\n\nNul himself stated that by wearing his Memento, he may be willing to spare me from death every now and again.").method_27692(class_124.field_1074)));
        return list;
    }

    public class NulMementoItem
    extends ArcanaPolymerItem {
        public NulMementoItem() {
            super(NulMemento.this.getThis(), NulMemento.this.getEquipmentArcanaItemComponents().method_66332(class_1740.field_21977, class_8051.field_41934));
        }

        @Override
        public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
            boolean onHead;
            if (ArcanaItemUtils.isArcane(itemStack) && (onHead = ArcanaItem.getBooleanProperty(itemStack, NulMemento.HEAD_TAG)) && PolymerResourcePackUtils.hasMainPack((PacketContext)context)) {
                return textureItem;
            }
            return super.getPolymerItem(itemStack, context);
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            class_10192 equippableComponent = (class_10192)baseStack.method_58694(class_9334.field_54196);
            class_10192 newComp = class_10192.method_64202((class_1304)equippableComponent.comp_3174()).method_64205(equippableComponent.comp_3175()).method_64203();
            baseStack.method_57379(class_9334.field_54196, (Object)newComp);
            return baseStack;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            boolean nowOnHead = player.method_6118(class_1304.field_6169).equals(stack);
            boolean wasOnHead = ArcanaItem.getBooleanProperty(stack, NulMemento.HEAD_TAG);
            if (nowOnHead != wasOnHead) {
                ArcanaItem.putProperty(stack, NulMemento.HEAD_TAG, nowOnHead);
            }
            if (nowOnHead && NulMemento.this.getEnergy(stack) > 0) {
                NulMemento.this.addEnergy(stack, -1);
                NulMemento.this.buildItemLore(stack, entity.method_5682());
            }
            if (Math.random() < 7.5E-6) {
                NulMemento.this.inventoryDialog(player);
            }
        }

        public class_1799 method_7854() {
            return NulMemento.this.prefItem;
        }
    }
}

