/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.cardinalcomponents.IArcanaProfileComponent;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2431;
import net.minecraft.class_2449;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_9334;
import net.minecraft.class_9886;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class PickaxeOfCeptyus
extends ArcanaItem {
    public static final String ID = "pickaxe_of_ceptyus";
    public static final String CEPTYUS_TICK = "ceptyusPickTick";
    public static final String CEPTYUS_ENERGY = "ceptyusPickEnergy";

    public PickaxeOfCeptyus() {
        this.id = ID;
        this.name = "Ancient Pickaxe of Ceptyus";
        this.rarity = ArcanaRarity.DIVINE;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.vanillaItem = class_1802.field_22024;
        this.item = new PickaxeOfCeptyusItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.pickaxe_of_ceptyus", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1062});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_PICKAXE_OF_CEPTYUS};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public void finalizePrefItem(MinecraftServer server) {
        super.finalizePrefItem(server);
        class_1799 curPrefItem = this.getPrefItem();
        curPrefItem.method_57379(class_9334.field_49633, (Object)MinecraftUtils.makeEnchantComponent((class_1889[])new class_1889[]{new class_1889(MinecraftUtils.getEnchantment((class_5455)server.method_30611(), (class_5321)class_1893.field_9130), 5), new class_1889(MinecraftUtils.getEnchantment((class_5455)server.method_30611(), (class_5321)class_1893.field_9131), 5)}));
        this.prefItem = this.buildItemLore(curPrefItem, server);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"A long-lost ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"Pickaxe ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"that could ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"shatter ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"World").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"An ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"unbreakable ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"Netherite Pickaxe").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" with ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"Fortune V").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"Efficiency V").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It gives ramping ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"haste ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"mines ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"whole ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"ore veins").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)". ").method_27692(class_124.field_1077)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    public void veinMine(class_1937 world, class_1657 player, class_1799 item, class_2338 pos) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_2248 type = world.method_8320(pos).method_26204();
        if (!world.method_8320(pos).method_26164(ArcanaRegistry.CEPTYUS_VEIN_MINEABLE)) {
            return;
        }
        int veinLevel = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.WITH_THE_DEPTHS.id));
        int maxDepth = 8 + 2 * veinLevel;
        int maxBlocks = 64 + 32 * veinLevel;
        LinkedList queue = Lists.newLinkedList();
        LinkedList visited = Lists.newLinkedList();
        queue.add(new class_3545((Object)pos, (Object)0));
        ArrayList<class_2338> toMine = new ArrayList<class_2338>();
        while (!queue.isEmpty()) {
            class_3545 pair = (class_3545)queue.poll();
            class_2338 blockPos = (class_2338)pair.method_15442();
            int depth = (Integer)pair.method_15441();
            visited.add(blockPos);
            class_2248 curType = world.method_8320(blockPos).method_26204();
            if (curType != type || toMine.contains(blockPos)) continue;
            toMine.add(blockPos);
            if (toMine.size() >= maxBlocks) break;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (i == 0 && j == 0 && k == 0 || depth >= maxDepth) continue;
                        class_2338 pos2 = blockPos.method_10069(i, j, k);
                        if (!queue.stream().noneMatch(p -> ((class_2338)p.method_15442()).equals((Object)pos2)) || visited.contains(pos2)) continue;
                        queue.add(new class_3545((Object)pos2, (Object)(depth + 1)));
                    }
                }
            }
        }
        int greedLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.GREED.id));
        int[] greed = new int[]{0, 1, 3, 5};
        ArrayList drops = new ArrayList();
        class_1799 veinPick = new class_1799((class_1935)class_1802.field_22024);
        veinPick.method_7978(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9130), 5 + greed[greedLvl]);
        veinPick.method_7978(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9119), 5);
        for (class_2338 blockPos : toMine) {
            class_2431 ore;
            drops.addAll(class_2248.method_9609((class_2680)world.method_8320(blockPos), (class_3218)serverWorld, (class_2338)blockPos, null, (class_1297)player, (class_1799)veinPick));
            world.method_8651(blockPos, false, (class_1297)player);
            if (type instanceof class_2431) {
                ore = (class_2431)type;
                ore.method_9565(world.method_8320(blockPos), serverWorld, pos, veinPick, true);
            }
            if (type instanceof class_2449) {
                ore = (class_2449)type;
                ore.method_9565(world.method_8320(blockPos), serverWorld, pos, veinPick, true);
            }
            ArcanaNovum.data(player).addXP(ArcanaConfig.getInt(ArcanaRegistry.PICKAXE_OF_CEPTYUS_VEIN_MINE_BLOCK));
        }
        for (class_1799 stack : drops) {
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)stack);
        }
        if (toMine.size() >= 12 && (type == class_2246.field_10442 || type == class_2246.field_29029) && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            ArcanaAchievements.grant(serverPlayer, ArcanaAchievements.MINE_DIAMONDS.id);
        }
    }

    public void mining(class_3222 player, class_1799 stack) {
        int wHaste = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.WARDENS_HASTE.id));
        int energyGain = 5 + wHaste * 2;
        int maxEnergy = 1000 + 100 * wHaste;
        IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
        profile.addMiscData(CEPTYUS_TICK, (class_2520)class_2497.method_23247((int)0));
        class_2497 energy = (class_2497)profile.getMiscData(CEPTYUS_ENERGY);
        if (energy == null) {
            profile.addMiscData(CEPTYUS_ENERGY, (class_2520)class_2497.method_23247((int)0));
        } else {
            profile.addMiscData(CEPTYUS_ENERGY, (class_2520)class_2497.method_23247((int)Math.min(energy.method_10701() + energyGain, maxEnergy)));
        }
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"  Ancient Pickaxe\n     of Ceptyus").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nA curious Divine Artifact found in the deepest parts of the world amongst the rubble of the ancients\u2019 dwellings from a calamity long past. A Pickaxe that was used to carve  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Ancient Pickaxe\n     of Ceptyus").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nthrough the toughest\ndeepslate like butter, aid in the gathering of obsidian, and harvest fast fortunes from the depths without suffering a single chip.\n\nThis Pickaxe contains  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Ancient Pickaxe\n     of Ceptyus").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nthe Fortune enchantment pushed beyond its limit to the 5th level, as well as Efficiency imbued with a ramping hast boost that increases as I mine.\n\nThe Pickaxe also mines ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Ancient Pickaxe\n     of Ceptyus").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nall nearby ores of the same type in a single swing, and places the resulting valuables before me.\n\nThe ancients were careful folk, and so, such a noisy ability does not activate while sneaking.").method_27692(class_124.field_1074)));
        return list;
    }

    public class PickaxeOfCeptyusItem
    extends ArcanaPolymerItem {
        public PickaxeOfCeptyusItem() {
            super(PickaxeOfCeptyus.this.getThis(), PickaxeOfCeptyus.this.getEquipmentArcanaItemComponents().method_66330(class_9886.field_52590, 1.0f, -2.8f));
        }

        public class_1799 method_7854() {
            return PickaxeOfCeptyus.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            int energy;
            block7: {
                block6: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block6;
                    class_3218 serverWorld = world;
                    if (entity instanceof class_3222) break block7;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
            class_2497 energyEle = (class_2497)profile.getMiscData(PickaxeOfCeptyus.CEPTYUS_ENERGY);
            int n = energy = energyEle == null ? 0 : energyEle.method_10701();
            if (energy > 0) {
                int lastTick = ((class_2497)profile.getMiscData(PickaxeOfCeptyus.CEPTYUS_TICK)).method_10701();
                profile.addMiscData(PickaxeOfCeptyus.CEPTYUS_TICK, (class_2520)class_2497.method_23247((int)(lastTick + 1)));
                profile.addMiscData(PickaxeOfCeptyus.CEPTYUS_ENERGY, (class_2520)class_2497.method_23247((int)Math.max(0, energy - lastTick / 3)));
                int speed = energy / 100;
                class_1293 haste = new class_1293(class_1294.field_5917, 100, speed, false, false, false);
                player.method_6092(haste);
                if (speed == 10) {
                    ArcanaAchievements.progress(player, ArcanaAchievements.BACK_IN_THE_MINE.id, 1);
                }
            }
        }

        public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 miner) {
            if (miner instanceof class_3222) {
                class_3222 player = (class_3222)miner;
                int energyGain = 3 + Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.WARDENS_HASTE.id));
                int maxEnergy = 1000 + 100 * Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.WARDENS_HASTE.id));
                IArcanaProfileComponent profile = ArcanaNovum.data((class_1657)player);
                profile.addMiscData(PickaxeOfCeptyus.CEPTYUS_TICK, (class_2520)class_2497.method_23247((int)0));
                class_2497 energy = (class_2497)profile.getMiscData(PickaxeOfCeptyus.CEPTYUS_ENERGY);
                if (energy == null) {
                    profile.addMiscData(PickaxeOfCeptyus.CEPTYUS_ENERGY, (class_2520)class_2497.method_23247((int)0));
                } else {
                    profile.addMiscData(PickaxeOfCeptyus.CEPTYUS_ENERGY, (class_2520)class_2497.method_23247((int)Math.min(energy.method_10701() + energyGain, maxEnergy)));
                }
            }
            return super.method_7879(stack, world, state, pos, miner);
        }
    }
}

