/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerBowItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.PhotonicArrows;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_9280;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class RunicBow
extends ArcanaItem {
    public static final String ID = "runic_bow";

    public RunicBow() {
        this.id = ID;
        this.name = "Runic Bow";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.vanillaItem = class_1802.field_8102;
        this.item = new RunicBowItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.runic_bow", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1076});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_SHOOT_ARROW, ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER, ResearchTasks.UNLOCK_STELLAR_CORE, ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.ADVANCEMENT_SNIPER_DUEL, ResearchTasks.ADVANCEMENT_BULLSEYE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public void finalizePrefItem(MinecraftServer server) {
        super.finalizePrefItem(server);
        class_1799 curPrefItem = this.getPrefItem();
        curPrefItem.method_57379(class_9334.field_49633, (Object)MinecraftUtils.makeEnchantComponent((class_1889[])new class_1889[]{new class_1889(MinecraftUtils.getEnchantment((class_5455)server.method_30611(), (class_5321)class_1893.field_9103), 7)}));
        this.prefItem = this.buildItemLore(curPrefItem, server);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Bow").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" makes use of the ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Matrix").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to create ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"unique effects").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Bow").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" can fire and ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"activate ").method_27695(new class_124[]{class_124.field_1056, class_124.field_1062})).method_10852((class_2561)class_2561.method_43470((String)"the effects of ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"bow").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" also acts as a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"normal bow").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" with ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Power VII").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" and is ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"unbreakable").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_1799 newStack = super.updateItem(stack, server);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_1799 bowStack = inv.method_5438(12);
        class_1799 newArcanaItem = this.getNewItem();
        if (bowStack.method_7942()) {
            class_1890.method_57530((class_1799)newArcanaItem, (class_9304)bowStack.method_58657());
        }
        newArcanaItem.method_7978(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9103), 7);
        if (RunicBow.hasProperty(bowStack, EnhancedStatUtils.ENHANCED_STAT_TAG)) {
            EnhancedStatUtils.enhanceItem(newArcanaItem, RunicBow.getDoubleProperty(bowStack, EnhancedStatUtils.ENHANCED_STAT_TAG));
        }
        return newArcanaItem;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8137, 2);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_27063, 32);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9103), 5));
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_8301, 24);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_22020, 1);
        GenericArcanaIngredient h = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8102, 1, true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, d, a}, {b, g, h, g, d}, {c, h, m, h, c}, {d, g, h, g, b}, {a, d, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil().withFletchery().withEnchanter().withCore());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"      Runic Bow").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThe Runic Bow is truly a masterpiece of adaptive Arcana. The integrated Runic Matrices reconfigure the Bow\u2019s ethereal structure based on the projectile being fired to unlock its Arcane effects.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Runic Bow").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nThe Runic Bow is capable of utilizing Runic Arrows and activating their special abilities. \n\nThe Bow also enhances normal arrows to do more damage than a traditional enchanted bow.").method_27692(class_124.field_1074)));
        return list;
    }

    public class RunicBowItem
    extends ArcanaPolymerBowItem {
        public static final Predicate<class_1799> RUNIC_BOW_PROJECTILES = stack -> stack.method_31573(class_3489.field_18317) || ArcanaItemUtils.identifyItem(stack) instanceof RunicArrow;
        public static final float[] STABILITY = new float[]{1.0f, 0.75f, 0.5f, 0.0f};

        public RunicBowItem() {
            super(RunicBow.this.getThis(), RunicBow.this.getEquipmentArcanaItemComponents());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            ArrayList<CallSite> stringList = new ArrayList<CallSite>();
            int tier = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.BOW_ACCELERATION.id);
            if (tier > 0) {
                stringList.add((CallSite)((Object)("accel_" + tier)));
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return RunicBow.this.prefItem;
        }

        public Predicate<class_1799> method_19268() {
            return RUNIC_BOW_PROJECTILES;
        }

        public boolean method_7840(class_1799 bow, class_1937 world, class_1309 user, int remainingUseTicks) {
            if (!(user instanceof class_1657)) {
                return false;
            }
            class_1657 playerEntity = (class_1657)user;
            class_1799 arrowStack = playerEntity.method_18808(bow);
            boolean arrowsRunic = ArcanaItemUtils.isRunicArrow(arrowStack);
            if (!arrowStack.method_7960()) {
                float pullPercent = this.getPullProgress(this.method_7881(bow, user) - remainingUseTicks, bow);
                if ((double)pullPercent < 0.1) {
                    return false;
                }
                List list = RunicBowItem.method_57390((class_1799)bow, (class_1799)arrowStack, (class_1309)playerEntity);
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    if (!list.isEmpty()) {
                        float divergence = STABILITY[Math.max(0, ArcanaAugments.getAugmentOnItem(bow, ArcanaAugments.BOW_STABILIZATION.id))];
                        this.method_57393(serverWorld, (class_1309)playerEntity, playerEntity.method_6058(), bow, list, pullPercent * 3.0f, divergence, pullPercent == 1.0f, null);
                    }
                }
                class_3414 sound = class_3417.field_14600;
                float volume = 1.0f;
                if (arrowsRunic) {
                    sound = (class_3414)class_3417.field_15001.comp_349();
                    volume = 0.8f;
                    RunicArrow runicArrow = ArcanaItemUtils.identifyRunicArrow(arrowStack);
                    if (runicArrow instanceof PhotonicArrows) {
                        PhotonicArrows photonArrows = (PhotonicArrows)runicArrow;
                        sound = class_3417.field_26982;
                        volume = 1.2f;
                    }
                    ArcanaNovum.data(playerEntity).addXP(ArcanaConfig.getInt(ArcanaRegistry.RUNIC_ARROW_SHOOT) * list.size());
                    if (playerEntity instanceof class_3222) {
                        class_3222 player = (class_3222)playerEntity;
                        ArcanaAchievements.progress(player, ArcanaAchievements.JUST_LIKE_ARCHER.id, list.size());
                    }
                }
                world.method_43128(null, playerEntity.method_23317(), playerEntity.method_23318(), playerEntity.method_23321(), sound, class_3419.field_15248, volume, 1.0f / (world.method_8409().method_43057() * 0.4f + 1.2f) + pullPercent * 0.5f);
                playerEntity.method_7259(class_3468.field_15372.method_14956((Object)this));
                return true;
            }
            return false;
        }

        protected void method_57393(class_3218 world, class_1309 shooter, class_1268 hand, class_1799 bow, List<class_1799> projectiles, float speed, float divergence, boolean critical, @Nullable class_1309 target) {
            float f = class_1890.method_60118((class_3218)world, (class_1799)bow, (class_1297)shooter, (float)0.0f);
            float g = projectiles.size() == 1 ? 0.0f : 2.0f * f / (float)(projectiles.size() - 1);
            float h = (float)((projectiles.size() - 1) % 2) * g / 2.0f;
            float i = 1.0f;
            for (int j = 0; j < projectiles.size(); ++j) {
                class_1799 arrowStack = projectiles.get(j);
                if (arrowStack.method_7960()) continue;
                float k = h + i * (float)((j + 1) / 2) * g;
                i = -i;
                class_1676 projectileEntity = this.method_57344((class_1937)world, shooter, bow, arrowStack, critical);
                this.method_7763(shooter, projectileEntity, j, speed, divergence, k, target);
                world.method_8649((class_1297)projectileEntity);
                RunicArrow runicArrow = ArcanaItemUtils.identifyRunicArrow(arrowStack);
                if (runicArrow instanceof PhotonicArrows) {
                    PhotonicArrows photonArrows = (PhotonicArrows)runicArrow;
                    int alignmentLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(arrowStack, ArcanaAugments.PRISMATIC_ALIGNMENT.id));
                    photonArrows.shoot((class_1937)world, shooter, projectileEntity, alignmentLvl);
                    projectileEntity.method_5768(world);
                }
                bow.method_7970(this.method_57345(arrowStack), shooter, class_1309.method_56079((class_1268)hand));
                if (bow.method_7960()) break;
            }
        }

        public void method_7852(class_1937 world, class_1309 user, class_1799 bow, int remainingUseTicks) {
            int accelLvl = ArcanaAugments.getAugmentOnItem(bow, ArcanaAugments.BOW_ACCELERATION.id);
            float prog = this.getPullProgress(this.method_7881(bow, user) - remainingUseTicks, bow);
            if (accelLvl > 0 && user instanceof class_3222) {
                class_3222 player = (class_3222)user;
                if ((double)prog >= 0.1) {
                    String t = "\u2581\u2582\u2583\u2585\u2586\u2587\u06de";
                    char c = t.charAt((int)Math.max(0.0f, prog * (float)t.length() - 1.0f));
                    player.method_7353((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"\ud83c\udff9 (").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)String.valueOf(c)).method_27695(new class_124[]{class_124.field_1076, class_124.field_1067})).method_10852((class_2561)class_2561.method_43470((String)") \ud83c\udff9").method_27692(class_124.field_1076)), true);
                }
            }
            super.method_7852(world, user, bow, remainingUseTicks);
        }

        private float getPullProgress(int useTicks, class_1799 bow) {
            float maxPullTicks = 20.0f;
            ArcanaItem arcanaBow = ArcanaItemUtils.identifyItem(bow);
            if (arcanaBow instanceof RunicBow) {
                int accelLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(bow, ArcanaAugments.BOW_ACCELERATION.id));
                float[] accel = new float[]{20.0f, 18.0f, 17.0f, 16.0f, 15.0f, 10.0f};
                maxPullTicks = accel[accelLvl];
            }
            float f = (float)useTicks / maxPullTicks;
            if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
                f = 1.0f;
            }
            return f;
        }

        public int method_7881(class_1799 stack, class_1309 user) {
            return super.method_7881(stack, user);
        }

        public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
            return super.method_7836(world, user, hand);
        }
    }
}

