/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7260;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import net.minecraft.class_9886;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ShadowStalkersGlaive
extends EnergyItem {
    public static final String ID = "shadow_stalkers_glaive";
    public static final String TETHER_TARGET_TAG = "tetherTarget";
    public static final String TETHER_TIME_TAG = "tetherTime";
    private final int teleportLength = 10;

    public ShadowStalkersGlaive() {
        this.id = ID;
        this.name = "Shadow Stalkers Glaive";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.vanillaItem = class_1802.field_22022;
        this.item = new ShadowStalkersGlaiveItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.shadow_stalkers_glaive", (String)this.name).method_27692(class_124.field_1067).method_54663(0x2A2A2A);
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_NETHERITE_SWORD, ResearchTasks.OBTAIN_NETHER_STAR, ResearchTasks.USE_ENDER_PEARL, ResearchTasks.ADVANCEMENT_KILL_A_MOB, ResearchTasks.UNLOCK_STELLAR_CORE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        ShadowStalkersGlaive.putProperty(stack, TETHER_TIME_TAG, -1);
        ShadowStalkersGlaive.putProperty(stack, TETHER_TARGET_TAG, "");
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"blade ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"lets you move through your opponents ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"shadow").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"blade ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"stores the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"blood ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"from every strike and uses it as ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"energy").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Stride ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"through the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"darkness ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"behind your opponent or ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"blink forward").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"teleport ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"behind ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"your most recently attacked foe.").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"teleport ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"a ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"short distance").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        return 100;
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        String target = ShadowStalkersGlaive.getStringProperty(stack, TETHER_TARGET_TAG);
        int time = ShadowStalkersGlaive.getIntProperty(stack, TETHER_TIME_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        ShadowStalkersGlaive.putProperty(newStack, TETHER_TARGET_TAG, target);
        ShadowStalkersGlaive.putProperty(newStack, TETHER_TIME_TAG, time);
        return this.buildItemLore(newStack, server);
    }

    public void entityAttacked(class_1657 player, class_1799 stack, class_1297 entity) {
        if (entity instanceof class_1308 || entity instanceof class_1657) {
            ShadowStalkersGlaive.putProperty(stack, TETHER_TARGET_TAG, entity.method_5845());
            ShadowStalkersGlaive.putProperty(stack, TETHER_TIME_TAG, 60);
        }
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_1799 toolStack = inv.method_5438(12);
        class_1799 newArcanaItem = this.getNewItem();
        if (toolStack.method_7942()) {
            class_1890.method_57530((class_1799)newArcanaItem, (class_9304)toolStack.method_58657());
        }
        if (ShadowStalkersGlaive.hasProperty(toolStack, EnhancedStatUtils.ENHANCED_STAT_TAG)) {
            EnhancedStatUtils.enhanceItem(newArcanaItem, ShadowStalkersGlaive.getDoubleProperty(toolStack, EnhancedStatUtils.ENHANCED_STAT_TAG));
        }
        return newArcanaItem;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8449, 12);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_22421, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_20410, 32);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8281, 24);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_22020, 3);
        ArcanaIngredient l = new ArcanaIngredient(class_1802.field_8137, 3);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_22022, 1, true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, l, m, l, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil().withCore());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"  Shadow Stalkers\n       Glaive").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThis Blade was forged to mimic the power of Endermen to teleport and relentlessly pursue foes. However, instead of using Ender particles to warp through dimensions, this Glaive  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Shadow Stalkers\n       Glaive").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nrelies on a mechanism I came up with after my studies in the Nether. Using the Glaive lets me fall through the shadows and emerge elsewhere. The feeling is far different from Ender-based teleportation, such as ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Shadow Stalkers\n       Glaive").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nan Ender Pearl. \n\nBlood that is spilled on the Glaive gets soaked up by its shadowy surface.\nStriking and killing foes grants Glaive Charges.\n\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Shadow Stalkers\n       Glaive").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nSneak Use consumes one Charge to blink forward and emerge from the shadows 10 blocks in the direction of my gaze. \n\nThe Glaive remembers the last target it struck, and Using the ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"  Shadow Stalkers\n       Glaive").method_27692(class_124.field_1067).method_54663(0x2A2A2A), class_2561.method_43470((String)"\nGlaive consumes four Charges to emerge behind the target.").method_27692(class_124.field_1074)));
        return list;
    }

    public class ShadowStalkersGlaiveItem
    extends ArcanaPolymerItem {
        public ShadowStalkersGlaiveItem() {
            super(ShadowStalkersGlaive.this.getThis(), ShadowStalkersGlaive.this.getEquipmentArcanaItemComponents().method_66333(class_9886.field_52590, 3.0f, -2.4f));
        }

        public class_9323 method_57347() {
            class_9323 baseComponents = super.method_57347();
            class_9285 comp = (class_9285)baseComponents.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
            class_9285.class_9286 builder = class_9285.method_57480();
            for (class_9285.class_9287 entry : comp.comp_2393()) {
                if (entry.method_60767(class_5134.field_47759, class_2960.method_60655((String)"arcananovum", (String)ShadowStalkersGlaive.this.id))) continue;
                builder.method_57487(entry.comp_2395(), entry.comp_2396(), entry.comp_2397());
            }
            builder.method_57487(class_5134.field_47759, new class_1322(class_2960.method_60655((String)"arcananovum", (String)ShadowStalkersGlaive.this.id), 0.5, class_1322.class_1323.field_6328), class_9274.field_49217);
            class_9323.class_9324 overrides = class_9323.method_57827();
            overrides.method_57840(class_9334.field_49636, (Object)builder.method_57486());
            return class_9323.method_59771((class_9323)baseComponents, (class_9323)overrides.method_57838());
        }

        public class_1799 method_7854() {
            return ShadowStalkersGlaive.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            if (world.method_8503().method_3780() % 20 == 0) {
                int tetherTime;
                class_1297 target;
                String targetID = ArcanaItem.getStringProperty(stack, ShadowStalkersGlaive.TETHER_TARGET_TAG);
                if (!(targetID == null || targetID.isEmpty() || (target = player.method_51469().method_66347(AlgoUtils.getUUID((String)targetID))) != null && target.method_5805() && player.method_51469().method_27983() == target.method_37908().method_27983())) {
                    ArcanaItem.putProperty(stack, ShadowStalkersGlaive.TETHER_TIME_TAG, -1);
                    ArcanaItem.putProperty(stack, ShadowStalkersGlaive.TETHER_TARGET_TAG, "");
                }
                if ((tetherTime = ArcanaItem.getIntProperty(stack, ShadowStalkersGlaive.TETHER_TIME_TAG)) > 0) {
                    ArcanaItem.putProperty(stack, ShadowStalkersGlaive.TETHER_TIME_TAG, tetherTime - 1);
                } else if (tetherTime == 0) {
                    ArcanaItem.putProperty(stack, ShadowStalkersGlaive.TETHER_TIME_TAG, -1);
                    ArcanaItem.putProperty(stack, ShadowStalkersGlaive.TETHER_TARGET_TAG, "");
                }
                if (world.method_8503().method_3780() % 100 == 0) {
                    int energy = ShadowStalkersGlaive.this.getEnergy(stack);
                    boolean recharge = false;
                    if (energy < 20) {
                        recharge = true;
                    } else if (energy < ShadowStalkersGlaive.this.getMaxEnergy(stack) && ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.BLOODLETTER.id) >= 1 && player.method_6032() > 2.0f) {
                        recharge = true;
                        if (!player.method_68878() && !player.method_7325()) {
                            player.method_6033(player.method_6032() - 2.0f);
                        }
                    }
                    if (recharge) {
                        ShadowStalkersGlaive.this.addEnergy(stack, 20);
                        StringBuilder message = new StringBuilder("Glaive Charges: ");
                        for (int i = 1; i <= 5; ++i) {
                            message.append(ShadowStalkersGlaive.this.getEnergy(stack) >= i * 20 ? "\u2726 " : "\u2727 ");
                        }
                        player.method_7353((class_2561)class_2561.method_43470((String)message.toString()).method_54663(0x2A2A2A), true);
                    }
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) return class_1269.field_5811;
            class_3222 player = (class_3222)playerEntity;
            int energy = ShadowStalkersGlaive.this.getEnergy(stack);
            String tetherTarget = ArcanaItem.getStringProperty(stack, ShadowStalkersGlaive.TETHER_TARGET_TAG);
            if (tetherTarget == null || tetherTarget.isEmpty() || player.method_5715()) {
                if (!player.method_5715()) return class_1269.field_5811;
                if (energy < 20) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Glaive Needs At Least 1 Charge").method_54663(0x2A2A2A), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.8f);
                    return class_1269.field_5811;
                }
            } else {
                if (energy < 80) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Glaive Needs At Least 4 Charges").method_54663(0x2A2A2A), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.8f);
                    return class_1269.field_5811;
                }
                class_1297 target = player.method_51469().method_66347(AlgoUtils.getUUID((String)tetherTarget));
                if (target == null || !target.method_5805() || player.method_51469().method_27983() != target.method_37908().method_27983()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Glaive Has No Target").method_54663(0x2A2A2A), true);
                    return class_1269.field_5811;
                }
                class_243 targetPos = target.method_19538();
                class_243 targetView = target.method_5663();
                class_243 tpPos = targetPos.method_1019(targetView.method_18805(-1.5, 0.0, -1.5));
                ArcanaEffectUtils.shadowGlaiveTp(player.method_51469(), player);
                player.method_61275(new class_5454(player.method_51469(), tpPos.method_1031(0.0, 0.25, 0.0), class_243.field_1353, target.method_36454(), target.method_36455(), class_5454.field_52245));
                ArcanaEffectUtils.shadowGlaiveTp(player.method_51469(), player);
                SoundUtils.playSound((class_1937)world, (class_2338)player.method_24515(), (class_3414)class_3417.field_14545, (class_3419)class_3419.field_15248, (float)0.8f, (float)0.8f);
                ShadowStalkersGlaive.this.addEnergy(stack, -80);
                Object message = "Glaive Charges: ";
                for (int i = 1; i <= 5; ++i) {
                    message = (String)message + (ShadowStalkersGlaive.this.getEnergy(stack) >= i * 20 ? "\u2726 " : "\u2727 ");
                }
                player.method_7353((class_2561)class_2561.method_43470((String)message).method_54663(0x2A2A2A), true);
                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.SHADOW_STALKERS_GLAIVE_STALK));
                if (target instanceof class_3222 || target instanceof class_7260) {
                    ArcanaAchievements.progress(player, ArcanaAchievements.OMAE_WA.id, 0);
                }
                if (target instanceof class_1308) {
                    if (ArcanaAchievements.isTimerActive(player, ArcanaAchievements.SHADOW_FURY.id)) {
                        if (ArcanaAchievements.getProgress(player, ArcanaAchievements.SHADOW_FURY.id) % 2 == 1) {
                            ArcanaAchievements.progress(player, ArcanaAchievements.SHADOW_FURY.id, 1);
                        }
                    } else {
                        ArcanaAchievements.progress(player, ArcanaAchievements.SHADOW_FURY.id, 0);
                    }
                }
                int blindDur = (new int[]{0, 20, 40, 100})[Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.PARANOIA.id))];
                int invisDur = (new int[]{0, 20, 40, 100})[Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SHADOW_STRIDE.id))];
                class_1293 invis = new class_1293(ArcanaRegistry.GREATER_INVISIBILITY_EFFECT, invisDur, 0, false, false, true);
                player.method_6092(invis);
                if (!(target instanceof class_1309)) return class_1269.field_52422;
                class_1309 living = (class_1309)target;
                class_1293 blind = new class_1293(ArcanaRegistry.GREATER_BLINDNESS_EFFECT, blindDur, 5, false, true, true);
                living.method_6092(blind);
                return class_1269.field_52422;
            }
            class_243 playerPos = player.method_19538();
            class_243 view = player.method_5663();
            class_243 tpPos = playerPos.method_1019(view.method_1021(10.0));
            ArcanaEffectUtils.shadowGlaiveTp(player.method_51469(), player);
            player.method_61275(new class_5454(player.method_51469(), tpPos.method_1031(0.0, 0.25, 0.0), class_243.field_1353, player.method_36454(), player.method_36455(), class_5454.field_52245));
            ArcanaEffectUtils.shadowGlaiveTp(player.method_51469(), player);
            SoundUtils.playSound((class_1937)world, (class_2338)player.method_24515(), (class_3414)class_3417.field_14545, (class_3419)class_3419.field_15248, (float)0.8f, (float)0.8f);
            ShadowStalkersGlaive.this.addEnergy(stack, -20);
            Object message = "Glaive Charges: ";
            int i = 1;
            while (true) {
                if (i > 5) {
                    player.method_7353((class_2561)class_2561.method_43470((String)message).method_54663(0x2A2A2A), true);
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.SHADOW_STALKERS_GLAIVE_BLINK));
                    int invisDur = (new int[]{0, 20, 40, 100})[Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SHADOW_STRIDE.id))];
                    class_1293 invis = new class_1293(ArcanaRegistry.GREATER_INVISIBILITY_EFFECT, invisDur, 0, false, false, true);
                    player.method_6092(invis);
                    return class_1269.field_52422;
                }
                message = (String)message + (ShadowStalkersGlaive.this.getEnergy(stack) >= i * 20 ? "\u2726 " : "\u2727 ");
                ++i;
            }
        }
    }
}

