/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.achievements.TimedAchievement;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.events.SojournersMaxRunEvent;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.arcananovum.utils.EnhancedStatUtils;
import net.borisshoes.borislib.events.Event;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10192;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1740;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1847;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2653;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_8051;
import net.minecraft.class_8053;
import net.minecraft.class_9274;
import net.minecraft.class_9282;
import net.minecraft.class_9285;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class SojournerBoots
extends EnergyItem {
    public static final String ID = "sojourner_boots";
    public static final String SPEED_TAG = "sojourn_speed";
    public static final String STEP_TAG = "sojourn_step";
    public static final String ARMOR_TAG = "sojourn_armor";

    public SojournerBoots() {
        this.id = ID;
        this.name = "Sojourner's Boots";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.EQUIPMENT};
        this.vanillaItem = class_1802.field_8370;
        this.item = new SojournerBootsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.sojourner_boots", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1077});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_ADVENTURING_TIME, ResearchTasks.ADVANCEMENT_WALK_ON_POWDER_SNOW_WITH_LEATHER_BOOTS, ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.EFFECT_SWIFTNESS, ResearchTasks.EFFECT_JUMP_BOOST, ResearchTasks.UNLOCK_STELLAR_CORE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        SojournerBoots.putProperty(stack, "active", true);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Boots ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"shall take you to see the ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"world").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"...").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Merely ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"wearing ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"them makes you want to go on an ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"adventure").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Boots ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"are ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"unbreakable ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"and equal to ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"unenchanted netherite").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Wearing them gives ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"ramping move speed").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"uphill step assist").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" the ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"Boots ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"to ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"toggle ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"their ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"step assist").method_27692(class_124.field_1078)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        int boostLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.MARATHON_RUNNER.id));
        return 250 + 50 * boostLvl;
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        boolean active = SojournerBoots.getBooleanProperty(stack, "active");
        class_1799 newStack = super.updateItem(stack, server);
        SojournerBoots.putProperty(newStack, "active", active);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public class_1799 onAugment(class_1799 stack, ArcanaAugment augment, int level) {
        if (ArcanaItemUtils.identifyItem(stack) instanceof SojournerBoots && augment == ArcanaAugments.HIKING_BOOTS && level >= 1) {
            this.rebuildAttributes(stack);
        }
        return stack;
    }

    public void rebuildAttributes(class_1799 stack) {
        if (!stack.method_31574(this.item)) {
            return;
        }
        boolean active = SojournerBoots.getBooleanProperty(stack, "active");
        class_9285 modifiers = (class_9285)stack.method_58695(class_9334.field_49636, (Object)class_9285.field_49326);
        ArrayList<class_9285.class_9287> attributeList = new ArrayList<class_9285.class_9287>();
        for (class_9285.class_9287 entry : modifiers.comp_2393()) {
            class_1322 modifier = entry.comp_2396();
            if (modifier.comp_2447().toString().contains(SPEED_TAG) || modifier.comp_2447().toString().contains(STEP_TAG)) continue;
            attributeList.add(entry);
        }
        if (active) {
            double height = 0.65 + (double)Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.HIKING_BOOTS.id));
            attributeList.add(new class_9285.class_9287(class_5134.field_47761, new class_1322(class_2960.method_60655((String)"arcananovum", (String)STEP_TAG), height, class_1322.class_1323.field_6328), class_9274.field_49220));
        }
        attributeList.add(new class_9285.class_9287(class_5134.field_23719, new class_1322(class_2960.method_60655((String)"arcananovum", (String)SPEED_TAG), (double)this.getEnergy(stack) / 100.0, class_1322.class_1323.field_6330), class_9274.field_49220));
        class_9285 newComponent = new class_9285(attributeList);
        stack.method_57379(class_9334.field_49636, (Object)newComponent);
    }

    @Override
    public class_1799 forgeItem(class_1263 inv, StarlightForgeBlockEntity starlightForge) {
        class_8053 trim;
        class_1799 bootStack = inv.method_5438(12);
        class_1799 newArcanaItem = this.getNewItem();
        if (bootStack.method_7942()) {
            class_1890.method_57530((class_1799)newArcanaItem, (class_9304)bootStack.method_58657());
        }
        if ((trim = (class_8053)bootStack.method_58694(class_9334.field_49607)) != null) {
            newArcanaItem.method_57379(class_9334.field_49607, (Object)trim);
        }
        if (SojournerBoots.hasProperty(bootStack, EnhancedStatUtils.ENHANCED_STAT_TAG)) {
            EnhancedStatUtils.enhanceItem(newArcanaItem, SojournerBoots.getDoubleProperty(bootStack, EnhancedStatUtils.ENHANCED_STAT_TAG));
        }
        return newArcanaItem;
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"Sojourner's Boots").method_27695(new class_124[]{class_124.field_1077, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nInstead of focusing on combative properties, I have looked into integrating energy storage into armor, all while maintaining the basic protective properties of Netherite. The result is a pair of").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Sojourner's Boots").method_27695(new class_124[]{class_124.field_1077, class_124.field_1067}), class_2561.method_43470((String)"\nboots that lack any inherent protective enchantments (which I may be able to add via traditional methods) but come with the ability to store kinetic energy, amplify it and reapply it. This manifests as a ramping speed boost.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Sojourner's Boots").method_27695(new class_124[]{class_124.field_1077, class_124.field_1067}), class_2561.method_43470((String)"\nThe stored energy can also be used to carry me up short hills without jumping.").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8281, 32);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_27021, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8137, 2);
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_8200, 16);
        ArcanaIngredient f = new ArcanaIngredient(class_1802.field_28655, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_22020, 1);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8966);
        ArcanaIngredient j = new ArcanaIngredient(class_1802.field_37518, 16);
        ArcanaIngredient l = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8998);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_22030, 1, true);
        ArcanaIngredient p = new ArcanaIngredient(class_1802.field_8270, 16);
        ArcanaIngredient t = new ArcanaIngredient(class_1802.field_8110, 16);
        ArcanaIngredient v = new ArcanaIngredient(class_1802.field_8858, 16);
        ArcanaIngredient x = new ArcanaIngredient(class_1802.field_8260, 16);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, d, a}, {f, g, h, g, j}, {c, l, m, l, c}, {p, g, h, g, t}, {a, v, c, x, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withCore().withAnvil());
    }

    public class SojournerBootsItem
    extends ArcanaPolymerItem {
        public SojournerBootsItem() {
            super(SojournerBoots.this.getThis(), SojournerBoots.this.getEquipmentArcanaItemComponents().method_66332(class_1740.field_21977, class_8051.field_41937).method_57349(class_9334.field_49644, (Object)new class_9282(3385600)).method_57348(new class_9285(List.of(new class_9285.class_9287(class_5134.field_47761, new class_1322(class_2960.method_60655((String)"arcananovum", (String)SojournerBoots.STEP_TAG), 0.65, class_1322.class_1323.field_6328), class_9274.field_49220)))));
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            class_10192 equippableComponent = (class_10192)baseStack.method_58694(class_9334.field_54196);
            class_10192 newComp = class_10192.method_64202((class_1304)equippableComponent.comp_3174()).method_64205(equippableComponent.comp_3175()).method_64204(class_5321.method_29179(ArcanaRegistry.EQUIPMENT_ASSET_REGISTRY_KEY, (class_2960)class_2960.method_60655((String)"arcananovum", (String)SojournerBoots.ID))).method_64203();
            baseStack.method_57379(class_9334.field_54196, (Object)newComp);
            return baseStack;
        }

        public class_1799 method_7854() {
            return SojournerBoots.this.prefItem;
        }

        public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
            if (user.method_5715()) {
                class_1799 stack = user.method_5998(hand);
                boolean active = !ArcanaItem.getBooleanProperty(stack, "active");
                ArcanaItem.putProperty(stack, "active", active);
                if (active) {
                    user.method_7353((class_2561)class_2561.method_43470((String)"The Boots become energized with Arcana").method_27695(new class_124[]{class_124.field_1077, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)user), (class_3414)class_3417.field_14891, (float)0.8f, (float)2.0f);
                } else {
                    user.method_7353((class_2561)class_2561.method_43470((String)"The Boots' energy fades").method_27695(new class_124[]{class_124.field_1077, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)user), (class_3414)class_3417.field_19344, (float)2.0f, (float)0.8f);
                }
                SojournerBoots.this.rebuildAttributes(stack);
                if (user instanceof class_3222) {
                    class_3222 player = (class_3222)user;
                    class_1661 inv = player.method_31548();
                    player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), hand == class_1268.field_5808 ? 36 + inv.method_67532() : 45, stack));
                    player.field_13987.method_14364((class_2596)new class_2653(player.field_7498.field_7763, player.field_7498.method_37422(), 8, player.method_6118(class_1304.field_6166)));
                }
                return class_1269.field_52422;
            }
            return super.method_7836(world, user, hand);
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            try {
                if (stack == player.method_6118(class_1304.field_6166)) {
                    if (player.method_5624()) {
                        if (player.method_24828()) {
                            int curEnergy = SojournerBoots.this.getEnergy(stack);
                            int sprintLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SPRINTER.id));
                            SojournerBoots.this.addEnergy(stack, 2 * (1 + sprintLvl));
                            int newEnergy = SojournerBoots.this.getEnergy(stack);
                            if ((newEnergy % 50 == 0 || newEnergy % 50 == 1) && curEnergy != newEnergy) {
                                player.method_7353((class_2561)class_2561.method_43470((String)("Sojourner Boots Energy: " + newEnergy)).method_27692(class_124.field_1077), true);
                            }
                            if (world.method_8503().method_3780() % 20 == 0) {
                                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.SOJOURNERS_BOOTS_RUN_PER_SECOND));
                            }
                            if (newEnergy >= SojournerBoots.this.getMaxEnergy(stack)) {
                                Event.addEvent((Event)new SojournersMaxRunEvent(player));
                                if (Event.getEventsOfType(SojournersMaxRunEvent.class).stream().filter(event -> event.getPlayer().equals((Object)player)).count() >= (long)((TimedAchievement)ArcanaAchievements.RUNNING).getGoal()) {
                                    ArcanaAchievements.grant(player, ArcanaAchievements.RUNNING);
                                }
                            }
                        }
                    } else {
                        SojournerBoots.this.addEnergy(stack, -10);
                    }
                    SojournerBoots.this.rebuildAttributes(stack);
                } else if (SojournerBoots.this.getEnergy(stack) != 0) {
                    SojournerBoots.this.setEnergy(stack, 0);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

