/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class SpawnerHarness
extends ArcanaItem {
    public static final String ID = "spawner_harness";
    public static final String SPAWNER_TAG = "spawner";

    public SpawnerHarness() {
        this.id = ID;
        this.name = "Spawner Harness";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS, TomeGui.TomeFilter.BLOCKS};
        this.itemVersion = 1;
        this.vanillaItem = class_1802.field_8849;
        this.item = new SpawnerHarnessItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.spawner_harness", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1062});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_SILK_TOUCH, ResearchTasks.BREAK_SPAWNER, ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.UNLOCK_STELLAR_CORE, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        SpawnerHarness.putProperty(stack, SPAWNER_TAG, (class_2520)new class_2487());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"While ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"Silk Touch").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" fails to provide adequate finesse to obtain ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"spawners").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)",").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"through ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"magical enhancement").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" this harness should suffice.").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right click").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" on a ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"mob spawner").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to obtain it as an ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"item").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)""));
        String type = "Uncaptured";
        if (itemStack != null) {
            boolean hasSpawner;
            class_2487 spawnerTag = SpawnerHarness.getCompoundProperty(itemStack, SPAWNER_TAG);
            boolean bl = hasSpawner = !spawnerTag.method_33133();
            if (hasSpawner) {
                class_2487 spawnData;
                class_2487 entity;
                type = "Empty Spawner";
                if (spawnerTag.method_10545("SpawnData") && !(entity = (spawnData = spawnerTag.method_68568("SpawnData")).method_68568("entity")).method_33133()) {
                    String entityTypeId = entity.method_68564("id", "");
                    Optional entityType = class_1299.method_5898((String)entityTypeId);
                    type = entityType.isPresent() ? ((class_1299)entityType.get()).method_5897().getString() : "Unknown";
                }
            }
        }
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Type - ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)type).method_27692(class_124.field_1077)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_2487 spawnerNbt = SpawnerHarness.getCompoundProperty(stack, SPAWNER_TAG).method_10553();
        class_1799 newStack = super.updateItem(stack, server);
        SpawnerHarness.putProperty(newStack, SPAWNER_TAG, (class_2520)spawnerNbt);
        return this.buildItemLore(newStack, server);
    }

    private void giveScrap(class_1657 player) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_22021);
        int reduction = ArcanaConfig.getInt(ArcanaRegistry.INGREDIENT_REDUCTION);
        int scrapCost = (int)Math.ceil(4.0 / (double)reduction);
        stack.method_7939(scrapCost / 2);
        MinecraftUtils.giveStacks((class_1657)player, (class_1799[])new class_1799[]{stack});
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Spawner Harness").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nSpawners have always been one of the few blocks that are beyond the reach of the Silk Touch enchantment. Perhaps I can enhance the enchant a bit further by giving the magic a Harness to channel").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Spawner Harness").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nadditional Arcana to. \n\nThe Harness itself has to be incredibly durable to withstand the Arcana driving the enchant into overdrive, however, even with my best efforts, the Harness can break after use.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Spawner Harness").method_27695(new class_124[]{class_124.field_1062, class_124.field_1067}), class_2561.method_43470((String)"\nUse the Harness on a spawner to capture the spawner.\n\nThe Harness can then place the spawner elsewhere, with a 15% chance to break after use.\n").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22421, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9099), 1));
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8449, 4);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8076, 16);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_22020, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil().withEnchanter().withCore());
    }

    public class SpawnerHarnessItem
    extends ArcanaPolymerItem {
        public SpawnerHarnessItem() {
            super(SpawnerHarness.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            class_2487 spawnerData = ArcanaItem.getCompoundProperty(itemStack, SpawnerHarness.SPAWNER_TAG);
            boolean hasSpawner = spawnerData.method_10545("SpawnData");
            if (!hasSpawner) {
                stringList.add("empty");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return SpawnerHarness.this.prefItem;
        }

        public class_1269 method_7884(class_1838 context) {
            class_1937 world = context.method_8045();
            class_1657 player = context.method_8036();
            if (player == null) {
                return class_1269.field_5811;
            }
            try {
                class_1799 stack = context.method_8041();
                class_2487 spawnerTag = ArcanaItem.getCompoundProperty(stack, SpawnerHarness.SPAWNER_TAG);
                if (!spawnerTag.method_33133()) {
                    class_2350 side = context.method_8038();
                    class_2338 placePos = context.method_8037().method_10081(side.method_62675());
                    if (world.method_8320(placePos).method_26215()) {
                        boolean reinforced;
                        world.method_8652(placePos, class_2246.field_10260.method_9564(), 3);
                        class_2586 blockEntity = class_2586.method_11005((class_2338)placePos, (class_2680)class_2246.field_10260.method_9564(), (class_2487)spawnerTag, (class_7225.class_7874)world.method_30349());
                        if (blockEntity != null) {
                            world.method_8438(blockEntity);
                        }
                        boolean bl = reinforced = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.REINFORCED_CHASSIS.id)) > 0;
                        if (Math.random() > 0.15 || reinforced) {
                            player.method_7353((class_2561)class_2561.method_43470((String)"The harness successfully places the spawner.").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                            SoundUtils.playSongToPlayer((class_3222)((class_3222)player), (class_3414)class_3417.field_24063, (float)1.0f, (float)0.1f);
                            ArcanaItem.putProperty(stack, SpawnerHarness.SPAWNER_TAG, (class_2520)new class_2487());
                            SpawnerHarness.this.buildItemLore(stack, player.method_5682());
                        } else {
                            boolean scrap = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SALVAGEABLE_FRAME.id)) > 0;
                            player.method_7353((class_2561)class_2561.method_43470((String)"The harness shatters upon placing the spawner.").method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                            SoundUtils.playSongToPlayer((class_3222)((class_3222)player), (class_6880.class_6883)class_3417.field_15239, (float)1.0f, (float)0.5f);
                            ArcanaItem.putProperty(stack, SpawnerHarness.SPAWNER_TAG, (class_2520)new class_2487());
                            SpawnerHarness.this.buildItemLore(stack, player.method_5682());
                            stack.method_57008(stack.method_7947(), (class_1309)player);
                            if (scrap) {
                                SpawnerHarness.this.giveScrap(player);
                            }
                        }
                        ArcanaNovum.data(player).addXP((int)Math.max(0.0, (double)ArcanaConfig.getInt(ArcanaRegistry.SPAWNER_HARNESS_USE) * 0.15));
                        return class_1269.field_52422;
                    }
                    player.method_7353((class_2561)class_2561.method_43470((String)"The harness cannot be placed here.").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)player), (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                } else if (world.method_8320(context.method_8037()).method_26204() == class_2246.field_10260 && world.method_8321(context.method_8037()) instanceof class_2636) {
                    class_2636 spawner = (class_2636)world.method_8321(context.method_8037());
                    class_2487 spawnerNbt = spawner.method_38242((class_7225.class_7874)world.method_30349());
                    class_1297 renderedEntity = spawner.method_11390().method_8283(world, context.method_8037());
                    if (renderedEntity != null) {
                        String entityTypeId = class_1299.method_5890((class_1299)renderedEntity.method_5864()).toString();
                        String entityTypeName = ((class_1299)class_1299.method_5898((String)entityTypeId).get()).method_5897().getString();
                        player.method_7353((class_2561)class_2561.method_43470((String)("The harness captures the " + entityTypeName + " spawner.")).method_27695(new class_124[]{class_124.field_1062, class_124.field_1056}), true);
                        if (entityTypeId.equals(class_1299.method_5890((class_1299)class_1299.field_6125).toString())) {
                            ArcanaAchievements.grant((class_3222)player, ArcanaAchievements.FINALLY_USEFUL.id);
                        }
                    }
                    ArcanaItem.putProperty(stack, SpawnerHarness.SPAWNER_TAG, (class_2520)spawnerNbt);
                    world.method_22352(context.method_8037(), false);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)player), (class_3414)class_3417.field_24065, (float)1.0f, (float)0.1f);
                    SpawnerHarness.this.buildItemLore(stack, player.method_5682());
                    return class_1269.field_52422;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return class_1269.field_5811;
        }
    }
}

