/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.entities.StasisPearlEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.AlgoUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class StasisPearl
extends EnergyItem {
    public static final String ID = "stasis_pearl";
    public static final String PEARL_ID_TAG = "pearlID";

    public StasisPearl() {
        this.id = ID;
        this.name = "Stasis Pearl";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS};
        this.initEnergy = 60;
        this.vanillaItem = class_1802.field_8634;
        this.item = new StasisPearlItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.stasis_pearl", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1078});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_TEMPORAL_MOMENT, ResearchTasks.ADVANCEMENT_OBTAIN_ANCIENT_DEBRIS, ResearchTasks.USE_ENDER_PEARL, ResearchTasks.UNLOCK_TWILIGHT_ANVIL};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        StasisPearl.putProperty(stack, PEARL_ID_TAG, "");
        StasisPearl.putProperty(stack, "active", false);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"Ender Pearl").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" has the ability to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"freeze ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"its passage through ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"time").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"When ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"frozen ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"pearl ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"looks like it's '").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"hanging").method_27695(new class_124[]{class_124.field_1056, class_124.field_1075})).method_10852((class_2561)class_2561.method_43470((String)"' in the air.").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"It requires the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"flowing of time").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"recharge ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"it.").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"freeze ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"pearl ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"in flight.").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click again").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"release ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"pearl").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)""));
        if (itemStack == null) {
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Charged - ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"100%").method_27695(new class_124[]{class_124.field_1067, class_124.field_1078})));
        } else {
            int charge = this.getEnergy(itemStack) * 100 / this.getMaxEnergy(itemStack);
            String charging = charge == 100 ? "Charged" : "Charging";
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)(charging + " - ")).method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)(charge + "%")).method_27695(new class_124[]{class_124.field_1067, class_124.field_1078})));
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        return 60 - 10 * Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.STASIS_ACCELERATION.id));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        boolean active = StasisPearl.getBooleanProperty(stack, "active");
        String pearlID = StasisPearl.getStringProperty(stack, PEARL_ID_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        StasisPearl.putProperty(newStack, "active", active);
        StasisPearl.putProperty(newStack, PEARL_ID_TAG, pearlID);
        return this.buildItemLore(newStack, server);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8449, 4);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 12);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_22021, 1);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8137, 1);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8634, 8);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.TEMPORAL_MOMENT, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withAnvil());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Stasis Pearl").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nBy freezing an Ender Pearl in flight, I can leave it hanging in the air until I need it, out of phase from the timeline, unable to be destroyed. When unfrozen, it acts like a normal Ender Pearl.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Stasis Pearl").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nUse the Pearl to throw it like normal.\n\nUsing it again will freeze or unfreeze the Pearl from stasis.\n\nThe Pearl takes time after activation to resync to the timeline before subsequent use.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Stasis Pearl").method_27695(new class_124[]{class_124.field_1078, class_124.field_1067}), class_2561.method_43470((String)"\nThe Pearl cannot sustain stasis forever, and will decay if left in stasis for longer than 30 minutes.\n\nPerhaps a different item is more suitable for reliable teleportation over long periods of time.").method_27692(class_124.field_1074)));
        return list;
    }

    public class StasisPearlItem
    extends ArcanaPolymerItem {
        public StasisPearlItem() {
            super(StasisPearl.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            ArrayList<String> stringList = new ArrayList<String>();
            boolean active = ArcanaItem.getBooleanProperty(itemStack, "active");
            String pearlID = ArcanaItem.getStringProperty(itemStack, StasisPearl.PEARL_ID_TAG);
            if (pearlID.isEmpty()) {
                stringList.add(StasisPearl.this.getEnergy(itemStack) >= StasisPearl.this.getMaxEnergy(itemStack) ? "charged" : "cooldown");
            } else {
                stringList.add(active ? "stasis" : "flight");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        @Override
        public class_1792 getPolymerItem(class_1799 itemStack, PacketContext context) {
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return StasisPearl.this.vanillaItem;
            }
            boolean active = ArcanaItem.getBooleanProperty(itemStack, "active");
            return active ? class_1802.field_8449 : StasisPearl.this.vanillaItem;
        }

        public class_1799 method_7854() {
            return StasisPearl.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            class_3218 serverWorld;
            block10: {
                block9: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block9;
                    serverWorld = world;
                    if (entity instanceof class_3222) break block10;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            boolean active = ArcanaItem.getBooleanProperty(stack, "active");
            String pearlID = ArcanaItem.getStringProperty(stack, StasisPearl.PEARL_ID_TAG);
            if (!pearlID.isEmpty()) {
                class_1297 foundEntity = null;
                for (class_3218 possibleWorlds : serverWorld.method_8503().method_3738()) {
                    class_1297 possibleEntity = possibleWorlds.method_66347(AlgoUtils.getUUID((String)pearlID));
                    if (foundEntity != null || possibleEntity == null) continue;
                    foundEntity = possibleEntity;
                }
                if (foundEntity instanceof StasisPearlEntity) {
                    StasisPearlEntity pearlEntity = (StasisPearlEntity)foundEntity;
                } else {
                    ArcanaItem.putProperty(stack, "active", false);
                    ArcanaItem.putProperty(stack, StasisPearl.PEARL_ID_TAG, "");
                }
            }
            if (world.method_8503().method_3780() % 20 == 0) {
                StasisPearl.this.addEnergy(stack, 1);
                StasisPearl.this.buildItemLore(stack, world.method_8503());
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            boolean active = ArcanaItem.getBooleanProperty(stack, "active");
            String pearlID = ArcanaItem.getStringProperty(stack, StasisPearl.PEARL_ID_TAG);
            boolean canDelete = playerEntity.method_5715() && Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.SPATIAL_FOLD.id)) >= 1;
            try {
                if (pearlID.isEmpty()) {
                    if (StasisPearl.this.getEnergy(stack) >= StasisPearl.this.getMaxEnergy(stack)) {
                        SoundUtils.playSound((class_1937)world, (class_2338)playerEntity.method_24515(), (class_3414)class_3417.field_14757, (class_3419)class_3419.field_15248, (float)0.5f, (float)0.4f);
                        playerEntity.method_7357().method_62835(stack, 0);
                        if (!world.field_9236) {
                            StasisPearlEntity stasisPearlEntity = new StasisPearlEntity(world, (class_1309)playerEntity, ArcanaItem.getUUID(stack), ArcanaItem.getCompoundProperty(stack, "augments"));
                            stasisPearlEntity.method_24919((class_1297)playerEntity, playerEntity.method_36455(), playerEntity.method_36454(), 0.0f, 1.5f, 1.0f);
                            world.method_8649((class_1297)stasisPearlEntity);
                            String newPearlID = stasisPearlEntity.method_5845();
                            ArcanaItem.putProperty(stack, StasisPearl.PEARL_ID_TAG, newPearlID);
                            StasisPearl.this.setEnergy(stack, 0);
                            ArcanaNovum.data(playerEntity).addXP(ArcanaConfig.getInt(ArcanaRegistry.STASIS_PEARL_USE));
                        }
                    } else {
                        playerEntity.method_7357().method_62835(stack, 0);
                        if (playerEntity instanceof class_3222) {
                            class_3222 player = (class_3222)playerEntity;
                            playerEntity.method_7353((class_2561)class_2561.method_43470((String)("Pearl Recharging: " + StasisPearl.this.getEnergy(stack) * 100 / StasisPearl.this.getMaxEnergy(stack) + "%")).method_27692(class_124.field_1078), true);
                            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)1.0f, (float)0.5f);
                        }
                    }
                } else if (canDelete) {
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        class_1297 foundEntity = null;
                        for (class_3218 possibleWorlds : serverWorld.method_8503().method_3738()) {
                            class_1297 possibleEntity = possibleWorlds.method_66347(AlgoUtils.getUUID((String)pearlID));
                            if (foundEntity != null || possibleEntity == null) continue;
                            foundEntity = possibleEntity;
                        }
                        if (foundEntity != null) {
                            foundEntity.method_5768(serverWorld);
                        }
                        playerEntity.method_7357().method_62835(stack, 0);
                    }
                    ArcanaItem.putProperty(stack, "active", false);
                    ArcanaItem.putProperty(stack, StasisPearl.PEARL_ID_TAG, "");
                    if (playerEntity instanceof class_3222) {
                        class_3222 player = (class_3222)playerEntity;
                        playerEntity.method_7353((class_2561)class_2561.method_43470((String)"Pearl Cancelled").method_27692(class_124.field_1078), true);
                        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14890, (float)1.0f, (float)0.5f);
                    }
                } else if (active) {
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        class_1297 foundEntity = null;
                        for (class_3218 possibleWorlds : serverWorld.method_8503().method_3738()) {
                            class_1297 possibleEntity = possibleWorlds.method_66347(AlgoUtils.getUUID((String)pearlID));
                            if (foundEntity != null || possibleEntity == null) continue;
                            foundEntity = possibleEntity;
                        }
                        if (foundEntity instanceof StasisPearlEntity) {
                            StasisPearlEntity pearlEntity = (StasisPearlEntity)foundEntity;
                            pearlEntity.setStasis(false);
                            ArcanaItem.putProperty(stack, "active", false);
                            playerEntity.method_7357().method_62835(stack, 0);
                            return class_1269.field_52422;
                        }
                    }
                    ArcanaItem.putProperty(stack, "active", false);
                    ArcanaItem.putProperty(stack, StasisPearl.PEARL_ID_TAG, "");
                } else {
                    if (world instanceof class_3218) {
                        class_3218 serverWorld = (class_3218)world;
                        class_1297 foundEntity = null;
                        for (class_3218 possibleWorlds : serverWorld.method_8503().method_3738()) {
                            class_1297 possibleEntity = possibleWorlds.method_66347(AlgoUtils.getUUID((String)pearlID));
                            if (foundEntity != null || possibleEntity == null) continue;
                            foundEntity = possibleEntity;
                        }
                        if (foundEntity instanceof StasisPearlEntity) {
                            StasisPearlEntity pearlEntity = (StasisPearlEntity)foundEntity;
                            pearlEntity.setStasis(true);
                            ArcanaItem.putProperty(stack, "active", true);
                            playerEntity.method_7357().method_62835(stack, 0);
                            return class_1269.field_52422;
                        }
                    }
                    ArcanaItem.putProperty(stack, "active", false);
                    ArcanaItem.putProperty(stack, StasisPearl.PEARL_ID_TAG, "");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return class_1269.field_52422;
        }
    }
}

