/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.callbacks.BeaconMiningLaserCallback;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class TelescopingBeacon
extends ArcanaItem {
    public static final String ID = "telescoping_beacon";
    public static final String BLOCKS_TAG = "blocks";
    public static final String BEACON_TAG = "beacon";
    public static final String DATA_TAG = "data";
    public static int[] tiers = new int[]{9, 34, 83, 164};

    public TelescopingBeacon() {
        this.id = ID;
        this.name = "Telescoping Beacon";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS, TomeGui.TomeFilter.BLOCKS};
        this.vanillaItem = class_1802.field_8668;
        this.item = new TelescopingBeaconItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.telescoping_beacon", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_CREATE_FULL_BEACON, ResearchTasks.OBTAIN_PISTON};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        class_2487 initBlocks = new class_2487();
        initBlocks.method_10582("id", class_7923.field_41175.method_10221((Object)class_2246.field_10085).toString());
        initBlocks.method_10569("count", 164);
        class_2499 blocks = new class_2499();
        blocks.add((Object)initBlocks);
        TelescopingBeacon.putProperty(stack, BLOCKS_TAG, (class_2520)blocks);
        TelescopingBeacon.putProperty(stack, BEACON_TAG, true);
        TelescopingBeacon.putProperty(stack, DATA_TAG, (class_2520)new class_2487());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"beacon ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"automatically ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"deploys a ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"fully powered").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" base when placed.").method_27692(class_124.field_1062)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Using ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"the item again on a ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"fully powered").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" base ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"re-captures").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)" the construct.").method_27692(class_124.field_1062)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"There must be ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"adequate space").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"deploy ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"the ").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)BEACON_TAG).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1062)));
        lore.add(class_2561.method_43470((String)""));
        if (itemStack != null && TelescopingBeacon.getBooleanProperty(itemStack, BEACON_TAG)) {
            class_2499 blocks = TelescopingBeacon.getListProperty(itemStack, BLOCKS_TAG);
            int blockCount = 0;
            for (int i = 0; i < blocks.size(); ++i) {
                class_2487 blockType = blocks.method_68582(i);
                int count = blockType.method_68083("count", 0);
                blockCount += count;
            }
            int tier = TelescopingBeacon.blocksToTier(blockCount);
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Construct Status - ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)("Ready - Tier " + tier)).method_27692(class_124.field_1075)));
        } else {
            lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Construct Status - ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"Empty").method_27692(class_124.field_1080)));
        }
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        class_2499 blocksNbt = TelescopingBeacon.getListProperty(stack, BLOCKS_TAG).method_10612();
        boolean ready = TelescopingBeacon.getBooleanProperty(stack, BEACON_TAG);
        class_2487 data = TelescopingBeacon.getCompoundProperty(stack, DATA_TAG).method_10553();
        class_1799 newStack = super.updateItem(stack, server);
        TelescopingBeacon.putProperty(stack, DATA_TAG, (class_2520)data);
        TelescopingBeacon.putProperty(newStack, BLOCKS_TAG, (class_2520)blocksNbt);
        TelescopingBeacon.putProperty(newStack, BEACON_TAG, ready);
        return this.buildItemLore(newStack, server);
    }

    private static List<class_3545<class_2338, class_2680>> getBaseBlocks(class_1937 world, class_2338 pos) {
        int curY;
        ArrayList<class_3545<class_2338, class_2680>> blocks = new ArrayList<class_3545<class_2338, class_2680>>();
        int beaconX = pos.method_10263();
        int beaconY = pos.method_10264();
        int beaconZ = pos.method_10260();
        int index = 0;
        for (int curLevel = 1; curLevel <= 4 && (curY = beaconY - curLevel) >= world.method_31607(); ++curLevel) {
            for (int curX = beaconX - curLevel; curX <= beaconX + curLevel; ++curX) {
                for (int curZ = beaconZ - curLevel; curZ <= beaconZ + curLevel; ++curZ) {
                    class_2338 blockPos = new class_2338(curX, curY, curZ);
                    class_2680 blockState = world.method_8320(blockPos);
                    if (!blockState.method_26164(class_3481.field_22275)) continue;
                    blocks.add(index, (class_3545<class_2338, class_2680>)new class_3545((Object)blockPos, (Object)blockState));
                    ++index;
                }
            }
        }
        return blocks;
    }

    private boolean hasSpace(class_1937 world, class_2338 pos, int tier) {
        int beaconX = pos.method_10263();
        int beaconY = pos.method_10264();
        int beaconZ = pos.method_10260();
        for (int curLevel = 1; curLevel <= tier; ++curLevel) {
            int curY = beaconY - curLevel;
            if (curY < world.method_31607()) {
                return false;
            }
            for (int curX = beaconX - curLevel; curX <= beaconX + curLevel; ++curX) {
                for (int curZ = beaconZ - curLevel; curZ <= beaconZ + curLevel; ++curZ) {
                    class_2338 blockPos = new class_2338(curX, curY, curZ);
                    class_2680 blockState = world.method_8320(blockPos);
                    if (blockState.method_26164(class_3481.field_44471)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void placeBeacon(class_3222 player, class_1937 world, class_2338 pos, int tier, class_2499 blockTypes, class_2487 data, boolean mining) {
        try {
            class_2680 placeState;
            class_2586 blockEntity;
            ArrayList<class_2680> blocks = new ArrayList<class_2680>();
            HashMap<class_2248, Integer> blockTotals = new HashMap<class_2248, Integer>();
            class_2248 blockKey = null;
            for (int i = 0; i < blockTypes.size(); ++i) {
                class_2487 blockType = blockTypes.method_68582(i);
                int count = blockType.method_68083("count", 0);
                String id = blockType.method_68564("id", "");
                class_2248 block = class_7923.field_41175.method_17966(class_2960.method_60654((String)id)).orElse(null);
                if (block == null) {
                    ArcanaNovum.log(1, "Unknown Block Type Stored In Telescoping Beacon: " + id);
                    return;
                }
                for (int j = 0; j < count; ++j) {
                    blocks.add(block.method_9564());
                }
                if (blockTotals.containsKey(block)) {
                    blockTotals.put(block, (Integer)blockTotals.get(block) + count);
                    continue;
                }
                blockKey = block;
                blockTotals.put(block, count);
            }
            int beaconX = pos.method_10263();
            int beaconY = pos.method_10264();
            int beaconZ = pos.method_10260();
            int index = 0;
            for (int curLevel = 1; curLevel <= tier; ++curLevel) {
                int curY = beaconY - curLevel;
                if (curY < world.method_31607()) {
                    return;
                }
                for (int curX = beaconX - curLevel; curX <= beaconX + curLevel; ++curX) {
                    for (int curZ = beaconZ - curLevel; curZ <= beaconZ + curLevel; ++curZ) {
                        class_2680 blockState = (class_2680)blocks.get(index);
                        world.method_8652(new class_2338(curX, curY, curZ), blockState, 3);
                        ++index;
                    }
                }
            }
            world.method_8652(pos, class_2246.field_10327.method_9564(), 3);
            if (data != null && (blockEntity = class_2586.method_11005((class_2338)pos, (class_2680)(placeState = world.method_8320(pos)), (class_2487)data, (class_7225.class_7874)world.method_30349())) != null) {
                world.method_8438(blockEntity);
            }
            if (mining) {
                BorisLib.addTickTimerCallback((class_3218)player.method_51469(), (TickTimerCallback)new BeaconMiningLaserCallback(player.method_51469(), pos, pos.method_10084()));
            }
            player.method_5859((double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 2), (double)pos.method_10260() + 0.5);
            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.TELESCOPING_BEACON_PER_BLOCK) * index);
            for (int i = 0; i <= tier; ++i) {
                int j = i;
                BorisLib.addTickTimerCallback((class_3218)player.method_51469(), (TickTimerCallback)new GenericTimer(2 * (i + 1), () -> SoundUtils.playSound((class_1937)world, (class_2338)pos, (class_3414)class_3417.field_21077, (class_3419)class_3419.field_15248, (float)1.0f, (float)(0.8f + 0.2f * (float)j))));
            }
            if (blockTotals.size() == 1 && (Integer)blockTotals.get(blockKey) >= 164) {
                class_2680 blockType = (class_2680)blocks.get(0);
                if (blockType.method_27852(class_2246.field_10201)) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.BEJEWELED.id);
                } else if (blockType.method_27852(class_2246.field_10234)) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.ART_OF_THE_DEAL.id);
                } else if (blockType.method_27852(class_2246.field_10205)) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.ACQUISITION_RULES.id);
                } else if (blockType.method_27852(class_2246.field_22108)) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.CLINICALLY_INSANE.id);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int blocksToTier(int blocks) {
        for (int i = 0; i < tiers.length; ++i) {
            if (blocks >= tiers[i]) continue;
            return i;
        }
        return tiers.length;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_22421, 8);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 8);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8249, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8773, 32, true);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8668, 1, true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, c, h, c, b}, {c, h, m, h, c}, {b, c, h, c, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Telescoping\n       Beacon").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nA fully empowered beacon is a rather large construct. Their setup and breakdown is a great deal of effort. Through a combination of pistons and a reinforced chassis, the beacon   ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Telescoping\n       Beacon").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\ncan expand and retract with the press of a button.\n\nCollecting it will store enough base blocks to redeploy at the highest possible tier without collecting extra.\n ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Telescoping\n       Beacon").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nThere must be enough room for the beacon and its base to deploy in order to activate.\n\nThe beacon expands upwards from the location of placement.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class TelescopingBeaconItem
    extends ArcanaPolymerItem {
        public TelescopingBeaconItem() {
            super(TelescopingBeacon.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            if (!ArcanaItem.getBooleanProperty(itemStack, TelescopingBeacon.BEACON_TAG)) {
                stringList.add("empty");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return TelescopingBeacon.this.prefItem;
        }

        public class_1269 method_7884(class_1838 context) {
            class_2338 placePos;
            class_1657 playerEntity = context.method_8036();
            class_1268 hand = context.method_20287();
            class_1937 world = context.method_8045();
            class_1799 stack = context.method_8041();
            class_2499 blocks = ArcanaItem.getListProperty(stack, TelescopingBeacon.BLOCKS_TAG);
            boolean hasBeacon = ArcanaItem.getBooleanProperty(stack, TelescopingBeacon.BEACON_TAG);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_52422;
            }
            class_3222 player = (class_3222)playerEntity;
            class_2350 side = context.method_8038();
            class_2338 class_23382 = placePos = hasBeacon ? context.method_8037().method_10081(side.method_62675()) : context.method_8037();
            if (hasBeacon) {
                int blockCount = 0;
                for (int i = 0; i < blocks.size(); ++i) {
                    class_2487 blockType = blocks.method_68582(i);
                    int count = blockType.method_68083("count", 0);
                    blockCount += count;
                }
                int tier = TelescopingBeacon.blocksToTier(blockCount);
                if (TelescopingBeacon.this.hasSpace(world, placePos = placePos.method_10069(0, tier, 0), tier) && world.method_8320(placePos).method_26166(new class_1750(playerEntity, hand, stack, new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), context.method_17699())))) {
                    boolean mining;
                    boolean careful = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.CAREFUL_RECONSTRUCTION.id) >= 1;
                    boolean bl = mining = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.MINING_LASER.id) >= 1;
                    if (careful && !ArcanaItem.getCompoundProperty(stack, TelescopingBeacon.DATA_TAG).method_33133()) {
                        TelescopingBeacon.this.placeBeacon(player, world, placePos, tier, blocks, ArcanaItem.getCompoundProperty(stack, TelescopingBeacon.DATA_TAG), mining);
                    } else {
                        TelescopingBeacon.this.placeBeacon(player, world, placePos, tier, blocks, null, mining);
                    }
                    ArcanaItem.putProperty(stack, TelescopingBeacon.BLOCKS_TAG, (class_2520)new class_2499());
                    ArcanaItem.putProperty(stack, TelescopingBeacon.BEACON_TAG, false);
                    TelescopingBeacon.this.buildItemLore(stack, player.method_5682());
                    player.method_7357().method_62835(stack, 20);
                } else {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Beacon cannot be placed here.").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)playerEntity), (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                }
            } else {
                class_2680 placeState = world.method_8320(placePos);
                class_2586 blockEntity = world.method_8321(placePos);
                if (!placeState.method_27852(class_2246.field_10327) || !(blockEntity instanceof class_2580)) {
                    playerEntity.method_7353((class_2561)class_2561.method_43470((String)"No Beacon Present").method_27695(new class_124[]{class_124.field_1061, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)((class_3222)playerEntity), (class_3414)class_3417.field_15102, (float)1.0f, (float)1.0f);
                    return class_1269.field_52422;
                }
                class_2580 beaconBlock = (class_2580)blockEntity;
                List<class_3545<class_2338, class_2680>> baseBlocks = TelescopingBeacon.getBaseBlocks(world, placePos);
                int tier = TelescopingBeacon.blocksToTier(baseBlocks.size());
                boolean careful = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.CAREFUL_RECONSTRUCTION.id)) >= 1;
                blocks = new class_2499();
                if (tier != 0) {
                    class_2248 blockType;
                    HashMap<class_2248, Integer> blockTypes = new HashMap<class_2248, Integer>();
                    ArrayList<class_2248> orderedBlocks = new ArrayList<class_2248>();
                    for (int i = 0; i < tiers[tier - 1]; ++i) {
                        class_2680 class_26802 = (class_2680)baseBlocks.get(i).method_15441();
                        blockType = class_26802.method_26204();
                        if (blockTypes.containsKey(blockType)) {
                            blockTypes.put(blockType, (Integer)blockTypes.get(blockType) + 1);
                        } else {
                            blockTypes.put(blockType, 1);
                        }
                        orderedBlocks.add(blockType);
                        world.method_8652((class_2338)baseBlocks.get(i).method_15442(), class_2246.field_10124.method_9564(), 3);
                    }
                    if (careful) {
                        for (class_2248 class_22482 : orderedBlocks) {
                            blockType = new class_2487();
                            blockType.method_10582("id", class_7923.field_41175.method_10221((Object)class_22482).toString());
                            blockType.method_10569("count", 1);
                            blocks.add((Object)blockType);
                        }
                    } else {
                        for (Map.Entry entry : blockTypes.entrySet()) {
                            blockType = new class_2487();
                            blockType.method_10582("id", class_7923.field_41175.method_10221((Object)((class_2248)entry.getKey())).toString());
                            blockType.method_10569("count", ((Integer)entry.getValue()).intValue());
                            blocks.add((Object)blockType);
                        }
                    }
                }
                ArcanaItem.putProperty(stack, TelescopingBeacon.BLOCKS_TAG, (class_2520)blocks);
                ArcanaItem.putProperty(stack, TelescopingBeacon.BEACON_TAG, true);
                if (careful) {
                    ArcanaItem.putProperty(stack, TelescopingBeacon.DATA_TAG, (class_2520)beaconBlock.method_38242((class_7225.class_7874)player.method_5682().method_30611()));
                } else {
                    ArcanaItem.putProperty(stack, TelescopingBeacon.DATA_TAG, (class_2520)new class_2487());
                }
                world.method_8652(placePos, class_2246.field_10124.method_9564(), 3);
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    for (int i = 0; i <= tier; ++i) {
                        int j = i;
                        class_2338 class_23383 = placePos;
                        BorisLib.addTickTimerCallback((class_3218)serverWorld, (TickTimerCallback)new GenericTimer(2 * (i + 1), () -> SoundUtils.playSound((class_1937)world, (class_2338)finalPlacePos, (class_3414)class_3417.field_21076, (class_3419)class_3419.field_15248, (float)1.0f, (float)(2.0f - 0.3f * (float)j))));
                    }
                }
                TelescopingBeacon.this.buildItemLore(stack, player.method_5682());
                player.method_7357().method_62835(stack, 20);
            }
            return class_1269.field_52422;
        }
    }
}

