/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.callbacks.VengeanceTotemTimerCallback;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.SoulstoneIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10132;
import net.minecraft.class_10133;
import net.minecraft.class_10216;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class TotemOfVengeance
extends ArcanaItem {
    public static final String ID = "totem_of_vengeance";

    public TotemOfVengeance() {
        this.id = ID;
        this.name = "Totem Of Vengeance";
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS, TomeGui.TomeFilter.EQUIPMENT};
        this.vanillaItem = class_1802.field_8288;
        this.item = new TotemOfVengeanceItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.totem_of_vengeance", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1079});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_SOULSTONE, ResearchTasks.ADVANCEMENT_TOTEM_OF_UNDYING, ResearchTasks.KILL_EVOKER, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER, ResearchTasks.EFFECT_STRENGTH, ResearchTasks.EFFECT_FIRE_RESISTANCE, ResearchTasks.EFFECT_SWIFTNESS};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"This ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Totem's ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"benevolent protection").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" has been ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"twisted ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"by ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"violence").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Once ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"regenerative magic").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" is now ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"fueled ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"by ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"rage ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"for that which hunts you.").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Upon ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"fatal damage").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)", you become ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"Death Warded").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" for a ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"brief duration").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You will be ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"unable ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"to drop to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"zero health").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)" and gain an ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"offensive boost").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"If you do not get ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"revenge ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"before the protection ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"fades").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)", you will ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"perish").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    private static class_10216 getTotemComponent(int furyLevel, boolean byPlayer) {
        int duration = byPlayer ? 300 * (furyLevel + 1) / 2 : 300 * (furyLevel + 1);
        return new class_10216(List.of(new class_10133(), new class_10132(List.of(new class_1293(ArcanaRegistry.DEATH_WARD_EFFECT, duration, 1), new class_1293(class_1294.field_5910, duration, furyLevel + 1), new class_1293(class_1294.field_5904, duration, furyLevel + 1)))));
    }

    public class_1799 upgradeLevel(class_1799 stack, boolean byPlayer) {
        if (!(ArcanaItemUtils.identifyItem(stack) instanceof TotemOfVengeance)) {
            return stack;
        }
        int furyLevel = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.RETALIATIVE_FURY.id));
        stack.method_57379(class_9334.field_54274, (Object)TotemOfVengeance.getTotemComponent(furyLevel, byPlayer));
        return stack;
    }

    public void triggerTotem(class_1799 stack, class_1309 living, class_1282 source) {
        if (living instanceof class_3222) {
            class_3222 player = (class_3222)living;
            int furyLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.RETALIATIVE_FURY.id));
            class_1297 attacker = source.method_5529() != null ? source.method_5529() : (player.method_6124() != null ? player.method_6124() : null);
            boolean byPlayer = attacker instanceof class_1657;
            stack.method_57379(class_9334.field_54274, (Object)TotemOfVengeance.getTotemComponent(furyLvl, byPlayer));
            BorisLib.addTickTimerCallback((TickTimerCallback)new VengeanceTotemTimerCallback(byPlayer ? 300 * (furyLvl + 1) / 2 : 300 * (furyLvl + 1), stack, player, attacker));
            player.method_51469().method_65096((class_2394)class_2398.field_11231, player.method_19538().field_1352, player.method_19538().field_1351 + (double)(player.method_17682() / 2.0f), player.method_19538().field_1350, 25, 0.5, 0.6, 0.5, 0.05);
            if (source.method_49708(ArcanaDamageTypes.VENGEANCE_TOTEM)) {
                ArcanaAchievements.grant(player, ArcanaAchievements.REVENGEANCE.id);
            }
            ArcanaAchievements.progress(player, ArcanaAchievements.TOO_ANGRY_TO_DIE.id, 0);
            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.TOTEM_OF_VENGEANCE_ACTIVATE));
        }
    }

    @Override
    public class_1799 onAugment(class_1799 stack, ArcanaAugment augment, int level) {
        if (ArcanaItemUtils.identifyItem(stack) instanceof TotemOfVengeance && augment == ArcanaAugments.RETALIATIVE_FURY) {
            return this.upgradeLevel(stack, false);
        }
        return stack;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        SoulstoneIngredient r = new SoulstoneIngredient(100, false, false, true, null);
        ArcanaIngredient p = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8977);
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8281, 12);
        ArcanaIngredient t = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8966);
        ArcanaIngredient v = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8993);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8137, 1);
        ArcanaIngredient x = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8969);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_22421, 8);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8288, 1, true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, b, b, a}, {a, g, b, g, a}, {k, b, m, b, k}, {p, k, r, k, t}, {a, v, k, x, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withEnchanter());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"      Totem Of\n     Vengeance").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nTotems of Undying are some of the oldest, yet most advanced Arcana I have seen. Ancient, yet powerful. I wonder if I can push their capabilities further, perhaps even to the point of ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Totem Of\n     Vengeance").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nimmortality?\n\nMy experiments have yielded disturbing results. The Totems use soul magic, and the only way to enhance them is to use some of my tricks from the Nether to add more soul energy.  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Totem Of\n     Vengeance").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nHowever, this condensation of Nether soul magic into the ancient design of the Totem twists it into something sinister. My new Totem has become overwhelmed by the violence of stolen souls and now it seeks vengeance.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Totem Of\n     Vengeance").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nIt will not stop until the soul energy is expended or it succeeds in its task. If it runs out of souls then it will consume mine in the process.\n\nUpon taking fatal damage, the Totem prevents me from ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Totem Of\n     Vengeance").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nlosing my last bit of health until I get my revenge, or the totem expires. Upon expiration, my soul is consumed by the Totem\u2019s unstoppable rage. During my vengeful rage, I become faster and stronger to aid in ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Totem Of\n     Vengeance").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\ntracking down the creature that killed me. A death to purely environmental causes activates the Totem, but does not claim my soul upon expiration.\nA death to a fellow player results in a halved duration of the Totem. ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Totem Of\n     Vengeance").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nA second Totem of Vengeance can be used to prolong the effect.").method_27692(class_124.field_1074)));
        return list;
    }

    public class TotemOfVengeanceItem
    extends ArcanaPolymerItem {
        public TotemOfVengeanceItem() {
            super(TotemOfVengeance.this.getThis(), TotemOfVengeance.this.getArcanaItemComponents().method_57349(class_9334.field_54274, (Object)TotemOfVengeance.getTotemComponent(0, false)));
        }

        public class_1799 method_7854() {
            return TotemOfVengeance.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            return class_1269.field_5811;
        }
    }
}

