/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1593;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class ArcaneFlakArrows
extends RunicArrow {
    public static final String ID = "arcane_flak_arrows";
    public static final int armTime = 5;

    public ArcaneFlakArrows() {
        this.id = ID;
        this.name = "Arcane Flak Arrows";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new ArcaneFlakArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.arcane_flak_arrows", (String)this.name).method_27695(new class_124[]{class_124.field_1076, class_124.field_1067});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.USE_FIREWORK, ResearchTasks.ADVANCEMENT_DRAGON_BREATH};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Arcane Flak Arrows:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1076}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" explode").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" when passing by a ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"flying creature").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Deals ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"increased damage").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1064)).method_10852((class_2561)class_2561.method_43470((String)"airborne entities").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1064)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
        double radius = 4.0 + 1.25 * (double)arrow.getAugment(ArcanaAugments.AIRBURST.id);
        ArcaneFlakArrows.detonate((class_1665)arrow, radius);
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
        double radius = 4.0 + 1.25 * (double)arrow.getAugment(ArcanaAugments.AIRBURST.id);
        ArcaneFlakArrows.detonate((class_1665)arrow, radius);
    }

    public static void detonate(class_1665 arrow, double damageRange) {
        class_1937 class_19372 = arrow.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        int deadPhantomCount = 0;
        List triggerTargets = arrow.method_37908().method_8333((class_1297)arrow, arrow.method_5829().method_1014(damageRange * 2.0), e -> !e.method_7325() && (double)e.method_5739((class_1297)arrow) <= damageRange && e instanceof class_1309);
        for (class_1297 entity : triggerTargets) {
            if (!(entity instanceof class_1309)) continue;
            class_1309 e2 = (class_1309)entity;
            float damage = (float)class_3532.method_15350((double)(arrow.method_18798().method_1033() * 4.0), (double)1.0, (double)10.0);
            damage *= e2.method_24828() ? 0.5f : 3.5f;
            float f = (double)e2.method_5739((class_1297)arrow) > damageRange * 0.75 ? 0.5f : 1.0f;
            class_1282 source = arrow.method_48923().method_48819((class_1297)arrow, arrow.method_24921());
            e2.method_64397(serverWorld, source, damage *= f);
            if (!(e2 instanceof class_1593) || !e2.method_29504()) continue;
            ++deadPhantomCount;
        }
        class_1297 class_12972 = arrow.method_24921();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            if (deadPhantomCount >= 5) {
                ArcanaAchievements.grant(player, ArcanaAchievements.AA_ARTILLERY.id);
            }
        }
        ArcanaEffectUtils.arcaneFlakArrowDetonate(serverWorld, arrow.method_19538(), damageRange, 0);
        SoundUtils.playSound((class_1937)serverWorld, (class_2338)arrow.method_24515(), (class_3414)class_3417.field_15188, (class_3419)class_3419.field_15248, (float)1.0f, (float)1.0f);
        SoundUtils.playSound((class_1937)serverWorld, (class_2338)arrow.method_24515(), (class_3414)class_3417.field_14800, (class_3419)class_3419.field_15248, (float)1.0f, (float)1.0f);
        arrow.method_31472();
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8613, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8450, 12);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_8601, 32);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, g, h, g, a}, {k, h, m, h, k}, {a, g, h, g, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"    Arcane Flak\n       Arrows").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nPhantoms\u2026 Scourges of the night sky. I shall create a weapon that strikes fear into their undead hearts. These arrows detonate when near flying creatures, doing massive bonus ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"    Arcane Flak\n       Arrows").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), class_2561.method_43470((String)"\ndamage in a brilliant display.").method_27692(class_124.field_1074)));
        return list;
    }

    public class ArcaneFlakArrowsItem
    extends ArcanaPolymerArrowItem {
        public ArcaneFlakArrowsItem() {
            super(ArcaneFlakArrows.this.getThis(), ArcaneFlakArrows.this.getArcanaArrowItemComponents(7802273));
        }

        public class_1799 method_7854() {
            return ArcaneFlakArrows.this.prefItem;
        }
    }
}

