/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class DetonationArrows
extends RunicArrow {
    public static final String ID = "detonation_arrows";

    public DetonationArrows() {
        this.id = ID;
        this.name = "Detonation Arrows";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new DetonationArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.detonation_arrows", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1079});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.OBTAIN_TNT};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Detonation Arrows:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1079}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" explode").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" on impact ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"destroying").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" nearby terrain.").method_27692(class_124.field_1065)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" explosion").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" does ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"reduced damage").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"players").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1065)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
        int blastLvl = arrow.getAugment(ArcanaAugments.BLAST_MINE.id);
        int personLvl = arrow.getAugment(ArcanaAugments.ANTI_PERSONNEL.id);
        this.explode((class_1665)arrow, entityHitResult.method_17784(), blastLvl, personLvl);
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
        int blastLvl = arrow.getAugment(ArcanaAugments.BLAST_MINE.id);
        int personLvl = arrow.getAugment(ArcanaAugments.ANTI_PERSONNEL.id);
        this.explode((class_1665)arrow, blockHitResult.method_17784(), blastLvl, personLvl);
    }

    private void explode(class_1665 arrow, class_243 pos, int blastLvl, int personLvl) {
        double power = class_3532.method_15350((double)(2.0 * arrow.method_18798().method_1033()), (double)1.5, (double)8.0);
        class_1282 source1 = ArcanaDamageTypes.of(arrow.method_37908(), ArcanaDamageTypes.DETONATION_TERRAIN, (class_1297)arrow, arrow.method_24921());
        class_1282 source2 = ArcanaDamageTypes.of(arrow.method_37908(), ArcanaDamageTypes.DETONATION_DAMAGE, (class_1297)arrow, arrow.method_24921());
        if (personLvl != 3) {
            float terrainPower = (float)(blastLvl >= 1 ? power * 2.5 : power);
            arrow.method_37908().method_55117(null, source1, null, pos.field_1352, pos.field_1351, pos.field_1350, terrainPower, false, class_1937.class_7867.field_40891);
        }
        if (blastLvl == 0) {
            arrow.method_37908().method_55117(null, source2, null, pos.field_1352, pos.field_1351, pos.field_1350, (float)(power * 0.75 * (1.0 + 0.25 * (double)personLvl)), false, class_1937.class_7867.field_40888);
        }
        arrow.method_31472();
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8626, 8);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, c, h, c, a}, {c, h, m, h, c}, {a, c, h, c, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"Detonation Arrows").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nThis Runic Matrix has been stuffed full of volatile Arcana, ready to blow at the slightest impact. However, the blast seems to be less effective on players compared to other creatures.").method_27692(class_124.field_1074)));
        return list;
    }

    public class DetonationArrowsItem
    extends ArcanaPolymerArrowItem {
        public DetonationArrowsItem() {
            super(DetonationArrows.this.getThis(), DetonationArrows.this.getArcanaArrowItemComponents(11035949));
        }

        public class_1799 method_7854() {
            return DetonationArrows.this.prefItem;
        }
    }
}

