/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.damage.ArcanaDamageTypes;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class PhotonicArrows
extends RunicArrow {
    public static final String ID = "photonic_arrows";

    public PhotonicArrows() {
        this.id = ID;
        this.name = "Photonic Arrows";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new PhotonicArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.photonic_arrows", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1075});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.ADVANCEMENT_CREATE_FULL_BEACON, ResearchTasks.OBTAIN_AMETHYST_CLUSTER, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Photonic Arrows:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1075}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" fly perfectly ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"straight ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"through the air.").method_27692(class_124.field_1068)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"arrows ").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)"pierce ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"all ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"entities ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"before hitting a ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"block").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1068)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    public void shoot(class_1937 world, class_1309 entity, class_1676 proj, int alignmentLvl) {
        class_1297 class_12972;
        class_3222 player;
        class_1297 hit2;
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        MinecraftUtils.LasercastResult lasercast = MinecraftUtils.lasercast((class_1937)world, (class_243)entity.method_33571(), (class_243)entity.method_5663(), (double)100.0, (boolean)true, (class_1297)entity);
        float damage = (float)class_3532.method_15350((double)(proj.method_18798().method_1033() * 5.0), (double)1.0, (double)20.0);
        if (alignmentLvl == 5) {
            damage += (float)(4.0 + (double)damage * 0.2);
        }
        float bonusDmg = 0.0f;
        int killCount = 0;
        for (class_1297 hit2 : lasercast.sortedHits()) {
            class_1308 mob;
            double dp;
            class_3222 hitPlayer;
            float finalDmg = (float)((double)(damage + bonusDmg) * Math.min(1.0, -0.01 * (hit2.method_19538().method_1022(lasercast.startPos()) - 100.0) + 0.25)) * (hit2 instanceof class_3222 ? 0.5f : 1.0f);
            if (hit2 instanceof class_3222 && (hitPlayer = (class_3222)hit2).method_6039() && (dp = hitPlayer.method_5663().method_1029().method_1026(lasercast.direction().method_1029())) < -0.6) {
                ArcanaUtils.blockWithShield((class_1309)hitPlayer, finalDmg);
                continue;
            }
            hit2.method_64397(serverWorld, ArcanaDamageTypes.of(entity.method_37908(), ArcanaDamageTypes.PHOTONIC, (class_1297)proj, (class_1297)entity), finalDmg);
            if (hit2 instanceof class_1308 && (mob = (class_1308)hit2).method_29504()) {
                ++killCount;
            }
            bonusDmg = Math.min(25.0f, bonusDmg + (float)alignmentLvl);
        }
        hit2 = proj.method_24921();
        if (hit2 instanceof class_3222) {
            player = (class_3222)hit2;
            if (killCount >= 10) {
                ArcanaAchievements.grant(player, ArcanaAchievements.X.id);
            }
        }
        if ((class_12972 = proj.method_24921()) instanceof class_3222) {
            player = (class_3222)class_12972;
            if (!lasercast.sortedHits().isEmpty() && proj instanceof RunicArrowEntity) {
                RunicArrowEntity runicArrowEntity = (RunicArrowEntity)proj;
                runicArrowEntity.incArrowForEveryFoe(player);
            }
        }
        ArcanaEffectUtils.photonArrowShot(serverWorld, entity.method_33571().method_1023(0.0, (double)(entity.method_17682() / 4.0f), 0.0), lasercast.endPos(), class_3532.method_15363((float)(damage / 15.0f), (float)0.4f, (float)1.0f), 0);
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_27069, 32);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8668, 1);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_28410, 32);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, g, h, g, a}, {k, h, m, h, k}, {a, g, h, g, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery().withEnchanter());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Photonic Arrows").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\n\u2018Straight as an arrow\u2019. What a joke of a saying, I\u2019ll show them what straight looks like. Some solar runes coupled with a focusing prism makes quite the combo. This brings a new meaning to \u2018Shooting Lazers\u2019.").method_27692(class_124.field_1074)));
        return list;
    }

    public class PhotonicArrowsItem
    extends ArcanaPolymerArrowItem {
        public PhotonicArrowsItem() {
            super(PhotonicArrows.this.getThis(), PhotonicArrows.this.getArcanaArrowItemComponents(0xABFBFF));
        }

        public class_1799 method_7854() {
            return PhotonicArrows.this.prefItem;
        }
    }
}

