/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.arrows;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.callbacks.OverhealTimerCallback;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerArrowItem;
import net.borisshoes.arcananovum.entities.RunicArrowEntity;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.items.arrows.RunicArrow;
import net.borisshoes.arcananovum.mixins.PersistentProjectileEntityAccessor;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.recipes.arcana.GenericArcanaIngredient;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class SiphoningArrows
extends RunicArrow {
    public static final String ID = "siphoning_arrows";
    public static final class_2960 EFFECT_ID = class_2960.method_60655((String)"arcananovum", (String)"siphoning_arrows.overheal");
    private static final int[] overhealCap = new int[]{0, 2, 4, 10};

    public SiphoningArrows() {
        this.id = ID;
        this.name = "Siphoning Arrows";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ARROWS};
        this.vanillaItem = class_1802.field_8087;
        this.item = new SiphoningArrowsItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.siphoning_arrows", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1079});
        this.researchTasks = new class_5321[]{ResearchTasks.UNLOCK_RUNIC_MATRIX, ResearchTasks.UNLOCK_RADIANT_FLETCHERY, ResearchTasks.OBTAIN_SPECTRAL_ARROW, ResearchTasks.ADVANCEMENT_BREW_POTION, ResearchTasks.OBTAIN_GLISTERING_MELON};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        this.addRunicArrowLore(lore);
        lore.add(class_2561.method_43470((String)"Siphoning Arrows:").method_27695(new class_124[]{class_124.field_1067, class_124.field_1079}));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"These ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"Runic Arrows").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" siphon health ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"from hit ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"entities").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1061)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The amount ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"siphoned ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"is proportional to the ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"damage ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"dealt.").method_27692(class_124.field_1061)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public void entityHit(RunicArrowEntity arrow, class_3966 entityHitResult) {
        class_1297 class_12972 = arrow.method_24921();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            double damage = (double)class_3532.method_15384((double)class_3532.method_15350((double)(arrow.method_18798().method_1033() * ((PersistentProjectileEntityAccessor)((Object)arrow)).getDamage()), (double)0.0, (double)2.147483647E9)) / 5.5;
            damage += arrow.method_7443() ? damage / 4.0 : 0.0;
            if (player.method_6032() < 1.5f) {
                BorisLib.addTickTimerCallback((class_3218)player.method_51469(), (TickTimerCallback)new GenericTimer(2, () -> {
                    class_1308 mob;
                    class_1297 patt0$temp = entityHitResult.method_17782();
                    if (patt0$temp instanceof class_1308 && (mob = (class_1308)patt0$temp).method_29504()) {
                        ArcanaAchievements.grant(player, ArcanaAchievements.CIRCLE_OF_LIFE.id);
                    }
                }));
            }
            int overhealLvl = arrow.getAugment(ArcanaAugments.OVERHEAL.id);
            float overheal = (float)class_3532.method_15350((double)(damage + (double)player.method_6032() - (double)player.method_6063()), (double)0.0, (double)overhealCap[overhealLvl]);
            if (overheal > 0.0f) {
                float curAbs = player.method_6067();
                BorisLib.addTickTimerCallback((TickTimerCallback)new OverhealTimerCallback(100, player, overheal));
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15119, (float)1.0f, (float)1.8f);
                MinecraftUtils.addMaxAbsorption((class_1309)player, (class_2960)EFFECT_ID, (double)overheal);
                player.method_6073(curAbs + overheal);
            }
            player.method_6025((float)damage);
            player.method_51469().method_65096((class_2394)class_2398.field_11201, player.method_23317(), player.method_23318() + (double)(player.method_17682() / 2.0f), player.method_23321(), (int)Math.ceil(damage), 0.5, 0.5, 0.5, 1.0);
        }
    }

    @Override
    public void blockHit(RunicArrowEntity arrow, class_3965 blockHitResult) {
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = ArcanaIngredient.EMPTY;
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8973);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8711, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8236, 16);
        ArcanaIngredient i = new ArcanaIngredient(class_1802.field_8597, 16);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8980);
        GenericArcanaIngredient m = new GenericArcanaIngredient(ArcanaRegistry.RUNIC_MATRIX, 1);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, a, c, a, a}, {a, g, h, i, a}, {k, h, m, h, k}, {a, i, h, g, a}, {a, a, c, a, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withFletchery());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Siphoning Arrows").method_27695(new class_124[]{class_124.field_1079, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nHealth manipulation is something that I have rarely explored. I\u2019ve invoked some simple life runes to draw upon the health lost from my arrows and draw it back to me.").method_27692(class_124.field_1074)));
        return list;
    }

    public class SiphoningArrowsItem
    extends ArcanaPolymerArrowItem {
        public SiphoningArrowsItem() {
            super(SiphoningArrows.this.getThis(), SiphoningArrows.this.getArcanaArrowItemComponents(15866018));
        }

        public class_1799 method_7854() {
            return SiphoningArrows.this.prefItem;
        }
    }
}

