/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.charms;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.LeftClickItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaEffectUtils;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2530;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3545;
import net.minecraft.class_3922;
import net.minecraft.class_3956;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4770;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5544;
import net.minecraft.class_5545;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.class_9695;
import net.minecraft.class_9696;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class CindersCharm
extends EnergyItem
implements LeftClickItem {
    public static final String ID = "cinders_charm";
    private final double range = 7.0;
    private final double closeW = 2.5;
    private final double farW = 6.5;
    private final double angle = 2.0 * Math.atan2(2.0, 7.0);
    private final double ha = this.angle / 2.0;
    private final double ri = 2.5 / (2.0 * Math.sin(this.ha));
    private final double ro = 6.5 / (2.0 * Math.sin(this.ha));

    public CindersCharm() {
        this.id = ID;
        this.name = "Charm of Cinders";
        this.initEnergy = 100;
        this.rarity = ArcanaRarity.SOVEREIGN;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.CHARMS, TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 1;
        this.vanillaItem = class_1802.field_8183;
        this.item = new CindersCharmItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.cinders_charm", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_NETHERITE_INGOT, ResearchTasks.KILL_BLAZE, ResearchTasks.KILL_MAGMA_CUBE, ResearchTasks.EFFECT_FIRE_RESISTANCE, ResearchTasks.USE_FLINT_AND_STEEL, ResearchTasks.UNLOCK_STELLAR_CORE};
        this.attributions = new class_3545[]{new class_3545((Object)class_2561.method_43471((String)"credits_and_attribution.arcananovum.inspired_by"), (Object)class_2561.method_43470((String)"sarhecker"))};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        CindersCharm.putProperty(stack, "active", false);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"charm ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"burns ").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)"with ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"focused intensity").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1061)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Flames ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"welcome you with a ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"warm embrace").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1061)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Left Click").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" a block or creature to set it ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"ablaze").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1061)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Hold Right Click").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"breathe ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"a ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"cone of fire").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" in front of you.").method_27692(class_124.field_1061)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1079)).method_10852((class_2561)class_2561.method_43470((String)" to toggle ").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"auto-smelting").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" of picked up items.").method_27692(class_124.field_1061)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public boolean attackBlock(class_1657 playerEntity, class_1937 world, class_1268 hand, class_2338 blockPos, class_2350 direction) {
        int cinderConsumption;
        class_124 color;
        class_1799 itemStack = playerEntity.method_5998(hand);
        class_2680 blockState = world.method_8320(blockPos);
        boolean cremation = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.CREMATION.id) >= 1;
        class_124 class_1242 = color = cremation ? class_124.field_1075 : class_124.field_1061;
        if (blockState.method_27852(class_2246.field_10036) || blockState.method_27852(class_2246.field_22089)) {
            if (playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                player.field_13987.method_14364((class_2596)new class_2626(blockPos, blockState));
            }
            return false;
        }
        int n = cinderConsumption = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.FIRESTARTER.id) >= 1 ? 0 : 5;
        if (this.getEnergy(itemStack) < cinderConsumption) {
            playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Charm has no Cinders").method_27692(color), true);
            return true;
        }
        if (!(class_3922.method_30035((class_2680)blockState) || class_5544.method_31630((class_2680)blockState) || class_5545.method_31635((class_2680)blockState))) {
            class_2338 blockPos2 = blockPos.method_10093(direction);
            if (blockState.method_27852(class_2246.field_10375)) {
                class_2530.method_10738((class_1937)world, (class_2338)blockPos);
                world.method_8652(blockPos, class_2246.field_10124.method_9564(), 11);
                this.addEnergy(itemStack, -cinderConsumption);
                Object message = "Cinders: ";
                for (int i = 1; i <= this.getMaxEnergy(itemStack) / 20; ++i) {
                    message = (String)message + (this.getEnergy(itemStack) >= i * 20 ? "\u2726 " : "\u2727 ");
                }
                playerEntity.method_7353((class_2561)class_2561.method_43470((String)((String)message).toString()).method_27692(color), true);
                if (playerEntity instanceof class_3222) {
                    class_3222 player = (class_3222)playerEntity;
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CINDERS_CHARM_IGNITE_TNT) * cinderConsumption);
                }
                return !playerEntity.method_68878();
            }
            if (class_4770.method_30032((class_1937)world, (class_2338)blockPos2, (class_2350)direction)) {
                SoundUtils.playSound((class_1937)world, (class_2338)blockPos, (class_3414)class_3417.field_15145, (class_3419)class_3419.field_15245, (float)1.0f, (float)(world.method_8409().method_43057() * 0.4f + 0.8f));
                class_2680 blockState2 = class_4770.method_24416((class_1922)world, (class_2338)blockPos2);
                world.method_8652(blockPos2, blockState2, 11);
                world.method_33596((class_1297)playerEntity, (class_6880)class_5712.field_28164, blockPos);
                this.addEnergy(itemStack, -cinderConsumption);
                Object message = "Cinders: ";
                for (int i = 1; i <= this.getMaxEnergy(itemStack) / 20; ++i) {
                    message = (String)message + (this.getEnergy(itemStack) >= i * 20 ? "\u2726 " : "\u2727 ");
                }
                playerEntity.method_7353((class_2561)class_2561.method_43470((String)((String)message).toString()).method_27692(color), true);
                if (playerEntity instanceof class_3222) {
                    class_3222 player = (class_3222)playerEntity;
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CINDERS_CHARM_IGNITE_BLOCK) * cinderConsumption);
                }
                return !playerEntity.method_68878();
            }
            return !playerEntity.method_68878();
        }
        if (class_5545.method_31635((class_2680)blockState) && playerEntity instanceof class_3222) {
            class_3222 player = (class_3222)playerEntity;
            ArcanaAchievements.grant(player, ArcanaAchievements.CAKE_DAY.id);
        }
        SoundUtils.playSound((class_1937)world, (class_2338)blockPos, (class_3414)class_3417.field_15145, (class_3419)class_3419.field_15245, (float)1.0f, (float)(world.method_8409().method_43057() * 0.4f + 0.8f));
        world.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(true)), 11);
        world.method_33596((class_1297)playerEntity, (class_6880)class_5712.field_28733, blockPos);
        this.addEnergy(itemStack, -cinderConsumption);
        Object message = "Cinders: ";
        for (int i = 1; i <= this.getMaxEnergy(itemStack) / 20; ++i) {
            message = (String)message + (this.getEnergy(itemStack) >= i * 20 ? "\u2726 " : "\u2727 ");
        }
        playerEntity.method_7353((class_2561)class_2561.method_43470((String)((String)message).toString()).method_27692(color), true);
        if (playerEntity instanceof class_3222) {
            class_3222 player = (class_3222)playerEntity;
            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CINDERS_CHARM_LIGHT_BLOCK) * cinderConsumption);
        }
        return !playerEntity.method_68878();
    }

    public class_1799 smelt(class_1799 charm, class_1657 player, class_1799 stack) {
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        try {
            boolean active = CindersCharm.getBooleanProperty(charm, "active");
            boolean cremation = ArcanaAugments.getAugmentOnItem(charm, ArcanaAugments.CREMATION.id) >= 1;
            boolean smelter = ArcanaAugments.getAugmentOnItem(charm, ArcanaAugments.SUPERSMELTER.id) >= 1;
            class_124 color = cremation ? class_124.field_1075 : class_124.field_1061;
            int energyToConsume = (int)Math.ceil((double)stack.method_7947() / (smelter ? 8.0 : 2.0));
            if (active && this.getEnergy(charm) >= energyToConsume) {
                class_1863.class_7266 matchGetter = class_1863.method_42302((class_3956)class_3956.field_17546);
                class_8786 recipeEntry = matchGetter.method_42303((class_9695)new class_9696(stack), serverWorld).orElse(null);
                if (recipeEntry == null) {
                    return null;
                }
                class_1874 recipe = (class_1874)recipeEntry.comp_1933();
                if (recipe == null) {
                    return null;
                }
                class_1799 recipeOutput = recipe.method_59998(new class_9696(stack), (class_7225.class_7874)serverWorld.method_30349());
                if (recipeOutput.method_7960()) {
                    return null;
                }
                class_1661 inv = player.method_31548();
                class_1799 result = recipeOutput.method_7972();
                if (recipeOutput.method_7947() * stack.method_7947() <= recipeOutput.method_7909().method_7882()) {
                    result.method_7939(recipeOutput.method_7947() * stack.method_7947());
                    if (inv.method_7390(result) == -1 && inv.method_7376() == -1) {
                        return null;
                    }
                    player.method_7255(class_3532.method_15375((float)(recipe.method_8171() * (float)stack.method_7947())));
                    int oldEnergy = this.getEnergy(charm);
                    this.addEnergy(charm, -energyToConsume);
                    int newEnergy = this.getEnergy(charm);
                    if (oldEnergy / 20 != newEnergy / 20) {
                        Object message = "Cinders: ";
                        for (int i = 1; i <= this.getMaxEnergy(charm) / 20; ++i) {
                            message = (String)message + (newEnergy >= i * 20 ? "\u2726 " : "\u2727 ");
                        }
                        player.method_7353((class_2561)class_2561.method_43470((String)((String)message).toString()).method_27692(color), true);
                    }
                    stack = result;
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        ArcanaNovum.data((class_1657)serverPlayer).addXP(ArcanaConfig.getInt(ArcanaRegistry.CINDERS_CHARM_SMELT_PER_CINDER) * energyToConsume);
                        if (recipeOutput.method_31574(class_1802.field_8280)) {
                            ArcanaAchievements.progress(serverPlayer, ArcanaAchievements.GLASSBLOWER.id, stack.method_7947());
                        }
                    }
                    return stack;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private class_1269 coneOfFlame(class_1657 playerEntity, class_1937 world, class_1268 hand) {
        class_124 color;
        class_1799 itemStack = playerEntity.method_5998(hand);
        if (!(world instanceof class_3218)) {
            return class_1269.field_5811;
        }
        class_3218 serverWorld = (class_3218)world;
        int energy = this.getEnergy(itemStack);
        boolean cremation = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.CREMATION.id) >= 1;
        class_2400 particleType = cremation ? class_2398.field_22246 : class_2398.field_11240;
        class_124 class_1242 = color = cremation ? class_124.field_1075 : class_124.field_1061;
        if (energy < 12) {
            playerEntity.method_7353((class_2561)class_2561.method_43470((String)"The Charm has no Cinders").method_27692(color), true);
            return class_1269.field_5811;
        }
        this.addEnergy(itemStack, -3);
        if (energy / 20 != this.getEnergy(itemStack) / 20) {
            energy = this.getEnergy(itemStack);
            StringBuilder message = new StringBuilder("Cinders: ");
            for (int i = 1; i <= this.getMaxEnergy(itemStack) / 20; ++i) {
                message.append(energy >= i * 20 ? "\u2726 " : "\u2727 ");
            }
            playerEntity.method_7353((class_2561)class_2561.method_43470((String)message.toString()).method_27692(color), true);
        }
        double mul = 10.5;
        class_243 boxStart = playerEntity.method_19538().method_1023(mul, mul, mul);
        class_243 boxEnd = playerEntity.method_19538().method_1031(mul, mul, mul);
        class_238 rangeBox = new class_238(boxStart, boxEnd);
        SoundUtils.playSound((class_1937)world, (class_2338)playerEntity.method_24515(), (class_3414)class_3417.field_14970, (class_3419)class_3419.field_15248, (float)0.6f, (float)((float)(Math.random() * 0.5 + 0.5)));
        List entities = serverWorld.method_8333((class_1297)playerEntity, rangeBox, e -> e instanceof class_1309);
        int ignited = 0;
        for (class_1297 e2 : entities) {
            if (!(e2 instanceof class_1309)) continue;
            class_1309 entity = (class_1309)e2;
            if (!this.inCone(playerEntity, e2.method_33571()) || entity.method_5753()) continue;
            entity.method_5639((float)((2 * energy + 60) / 20));
            entity.method_64397(serverWorld, new class_1282(entity.method_48923().method_48813().method_48793(), (class_1297)playerEntity), cremation ? 5.0f : 2.5f);
            if (entity instanceof class_1308) {
                ++ignited;
            }
            if (!(playerEntity instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)playerEntity;
            ArcanaNovum.data((class_1657)serverPlayer).addXP(ArcanaConfig.getInt(ArcanaRegistry.CINDERS_CHARM_CONE_PER_TARGET));
        }
        if (playerEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)playerEntity;
            if (ignited >= 12) {
                ArcanaAchievements.grant(serverPlayer, ArcanaAchievements.PYROMANIAC.id);
            }
        }
        double angle = 2.0 * Math.atan2(2.0, 7.0);
        float yaw = playerEntity.method_5802().field_1342;
        class_243 rot = class_243.method_1030((float)0.0f, (float)yaw);
        double pC = Math.atan2(rot.field_1350, rot.field_1352);
        class_243 rotVec = class_243.method_1030((float)60.0f, (float)yaw).method_1036(class_243.method_1030((float)0.0f, (float)yaw)).method_1029();
        class_243 origin = playerEntity.method_33571().method_1019(playerEntity.method_5663().method_1021(-this.ri * Math.cos(this.ha)));
        for (int i = 0; i < 40; ++i) {
            double nZ;
            float ab;
            float cd;
            double nY;
            float ac;
            float bd;
            float ad;
            float bc;
            float d;
            float dd;
            float c;
            float cc;
            float b;
            float bb;
            float dT;
            float a;
            float aa;
            double nX;
            class_243 offset;
            class_243 pos;
            int tries = 0;
            do {
                double pD = Math.random() * angle - angle / 2.0;
                offset = new class_243(Math.cos(pC + pD), 0.0, Math.sin(pC + pD)).method_1021(Math.random() * this.ro);
            } while (!this.inCone(playerEntity, pos = (offset = new class_243(nX = (double)((aa = (a = (float)Math.cos((double)(dT = (float)(Math.toRadians(-playerEntity.method_5802().field_1343) + (Math.random() * angle - angle / 2.0))) / 2.0)) * a) + (bb = (b = (float)(-rotVec.field_1352 * Math.sin((double)dT / 2.0))) * b) - (cc = (c = (float)(-rotVec.field_1351 * Math.sin((double)dT / 2.0))) * c) - (dd = (d = (float)(-rotVec.field_1350 * Math.sin((double)dT / 2.0))) * d)) * offset.field_1352 + (double)(2.0f * ((bc = b * c) + (ad = a * d))) * offset.field_1351 + (double)(2.0f * ((bd = b * d) - (ac = a * c))) * offset.field_1350, nY = (double)(2.0f * (bc - ad)) * offset.field_1352 + (double)(aa + cc - bb - dd) * offset.field_1351 + (double)(2.0f * ((cd = c * d) + (ab = a * b))) * offset.field_1350, nZ = (double)(2.0f * (bd + ac)) * offset.field_1352 + (double)(2.0f * (cd - ab)) * offset.field_1351 + (double)(aa + dd - bb - cc) * offset.field_1350)).method_1019(origin)) && ++tries < 12);
            serverWorld.method_65096((class_2394)particleType, pos.method_10216(), pos.method_10214(), pos.method_10215(), 1, 0.1, 0.1, 0.1, 0.0);
        }
        return class_1269.field_52422;
    }

    private class_1269 pyroblast(class_1657 playerEntity, class_1937 world, class_1799 itemStack, int lvl) {
        class_124 color;
        class_3218 serverWorld;
        block9: {
            block8: {
                if (!(world instanceof class_3218)) break block8;
                serverWorld = (class_3218)world;
                if (playerEntity instanceof class_3222) break block9;
            }
            return class_1269.field_5811;
        }
        class_3222 player = (class_3222)playerEntity;
        int energy = this.getEnergy(itemStack);
        boolean cremation = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.CREMATION.id) >= 1;
        class_2400 particleType = cremation ? class_2398.field_22246 : class_2398.field_11240;
        class_124 class_1242 = color = cremation ? class_124.field_1075 : class_124.field_1061;
        if (energy < 50) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Not Enough Cinders").method_27692(color), true);
            return class_1269.field_5811;
        }
        int consumedEnergy = energy;
        this.addEnergy(itemStack, -energy);
        if (energy / 20 != this.getEnergy(itemStack) / 20) {
            energy = this.getEnergy(itemStack);
            StringBuilder message = new StringBuilder("Cinders: ");
            for (int i = 1; i <= this.getMaxEnergy(itemStack) / 20; ++i) {
                message.append(energy >= i * 20 ? "\u2726 " : "\u2727 ");
            }
            player.method_7353((class_2561)class_2561.method_43470((String)message.toString()).method_27692(color), true);
        }
        class_243 startPos = player.method_33571();
        class_243 view = player.method_5663();
        class_243 rayEnd = startPos.method_1019(view.method_1021(35.0));
        class_3965 raycast = world.method_17742(new class_3959(startPos, rayEnd, class_3959.class_3960.field_17558, class_3959.class_242.field_1347, (class_1297)player));
        class_243 center = raycast.method_17784();
        double explosionRange = 3 + lvl;
        class_238 rangeBox = new class_238(center.field_1352 + 12.0, center.field_1351 + 12.0, center.field_1350 + 12.0, center.field_1352 - 12.0, center.field_1351 - 12.0, center.field_1350 - 12.0);
        List entities = world.method_8333(null, rangeBox, e -> !e.method_7325() && e.method_5707(center) < 1.25 * explosionRange * explosionRange && e instanceof class_1309);
        SoundUtils.playSound((class_1937)world, (class_2338)playerEntity.method_24515(), (class_6880.class_6883)class_3417.field_15152, (class_3419)class_3419.field_15248, (float)0.6f, (float)1.7f);
        int ignited = 0;
        for (class_1297 e2 : entities) {
            class_1309 entity;
            if (!(e2 instanceof class_1309) || (entity = (class_1309)e2).method_5753()) continue;
            float dmg = (float)(Math.max(0.0, 1.2 - entity.method_19538().method_1022(center) / explosionRange) * ((double)consumedEnergy / 10.0) * (0.8 + (double)lvl * 0.2));
            entity.method_5639((float)consumedEnergy / 20.0f);
            entity.method_64397(serverWorld, new class_1282(entity.method_48923().method_48813().method_48793(), (class_1297)playerEntity), cremation ? 2.0f * dmg : dmg);
            ++ignited;
            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CINDERS_CHARM_PYROBLAST_PER_TARGET));
        }
        if (ignited >= 12) {
            ArcanaAchievements.grant(player, ArcanaAchievements.PYROMANIAC.id);
        }
        ArcanaEffectUtils.pyroblastExplosion(serverWorld, (class_2394)particleType, center, explosionRange, 0);
        ArcanaEffectUtils.line((class_3218)serverWorld, null, (class_243)startPos.method_1023(0.0, 0.3, 0.0), (class_243)center, (class_2394)particleType, (int)((int)(center.method_1022(startPos) * 4.0)), (int)1, (double)0.0, (double)0.0);
        serverWorld.method_65096((class_2394)particleType, center.method_10216(), center.method_10214(), center.method_10215(), 100, 0.1, 0.1, 0.1, 0.4);
        return class_1269.field_52422;
    }

    private class_1269 fireweb(class_1657 playerEntity, class_1937 world, class_1799 itemStack, int lvl) {
        class_124 color;
        class_3218 serverWorld;
        block11: {
            block10: {
                if (!(world instanceof class_3218)) break block10;
                serverWorld = (class_3218)world;
                if (playerEntity instanceof class_3222) break block11;
            }
            return class_1269.field_5811;
        }
        class_3222 player = (class_3222)playerEntity;
        int energy = this.getEnergy(itemStack);
        boolean cremation = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.CREMATION.id) >= 1;
        class_2400 particleType = cremation ? class_2398.field_22246 : class_2398.field_11240;
        class_124 class_1242 = color = cremation ? class_124.field_1075 : class_124.field_1061;
        if (energy < 50) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Not Enough Cinders").method_27692(color), true);
            return class_1269.field_5811;
        }
        int consumedEnergy = energy;
        class_243 center = player.method_19538();
        double effectRange = 2 + lvl * 2;
        int numTargets = 5 * lvl;
        class_238 rangeBox = new class_238(center.field_1352 + 12.0, center.field_1351 + 12.0, center.field_1350 + 12.0, center.field_1352 - 12.0, center.field_1351 - 12.0, center.field_1350 - 12.0);
        List entities = world.method_8333((class_1297)player, rangeBox, e -> !e.method_7325() && e.method_5707(center) < 1.25 * effectRange * effectRange && e instanceof class_1309);
        entities.sort(Comparator.comparingDouble(e -> e.method_5739((class_1297)player)));
        if (entities.isEmpty()) {
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)0.3f, (float)0.8f);
            player.method_7353((class_2561)class_2561.method_43470((String)"No Targets in Range").method_27692(color), true);
            return class_1269.field_5811;
        }
        SoundUtils.playSound((class_1937)world, (class_2338)playerEntity.method_24515(), (class_3414)class_3417.field_15013, (class_3419)class_3419.field_15248, (float)1.0f, (float)0.5f);
        ArrayList<class_1309> hits = new ArrayList<class_1309>();
        for (class_1297 e2 : entities) {
            if (!(e2 instanceof class_1309)) continue;
            class_1309 entity = (class_1309)e2;
            if (!entity.method_5753()) {
                float dmg = (float)((double)consumedEnergy / 15.0 * (0.8 + (double)lvl * 0.2));
                entity.method_5639((float)consumedEnergy / 20.0f);
                entity.method_64397(serverWorld, new class_1282(entity.method_48923().method_48813().method_48793(), (class_1297)playerEntity), cremation ? 2.0f * dmg : dmg);
                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CINDERS_CHARM_WEB_PER_TARGET));
                hits.add(entity);
            }
            if (hits.size() < numTargets) continue;
            break;
        }
        if (hits.size() >= 12) {
            ArcanaAchievements.grant(player, ArcanaAchievements.PYROMANIAC.id);
        }
        ArcanaEffectUtils.webOfFireCast(serverWorld, (class_2394)particleType, player, hits, effectRange, 0);
        this.addEnergy(itemStack, -energy);
        if (energy / 20 != this.getEnergy(itemStack) / 20) {
            energy = this.getEnergy(itemStack);
            StringBuilder message = new StringBuilder("Cinders: ");
            for (int i = 1; i <= this.getMaxEnergy(itemStack) / 20; ++i) {
                message.append(energy >= i * 20 ? "\u2726 " : "\u2727 ");
            }
            player.method_7353((class_2561)class_2561.method_43470((String)message.toString()).method_27692(color), true);
        }
        return class_1269.field_52422;
    }

    private class_1269 toggleActive(class_3222 player, class_1799 item) {
        boolean active = !CindersCharm.getBooleanProperty(item, "active");
        boolean cremation = ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.CREMATION.id) >= 1;
        class_124 color = cremation ? class_124.field_1075 : class_124.field_1061;
        CindersCharm.putProperty(item, "active", active);
        if (active) {
            player.method_7353((class_2561)class_2561.method_43470((String)"The Charm's Heat Intensifies").method_27695(new class_124[]{color, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14991, (float)0.5f, (float)1.0f);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"The Charm's Heat Calms").method_27695(new class_124[]{color, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15102, (float)0.3f, (float)0.8f);
        }
        return class_1269.field_52422;
    }

    private boolean inCone(class_1657 user, class_243 targetPos) {
        class_243 origin = user.method_33571().method_1019(user.method_5663().method_1021(-this.ri * Math.cos(this.ha)));
        class_243 u = user.method_33571().method_1020(origin).method_1029();
        class_243 uvr = targetPos.method_1020(origin).method_1029();
        double targetAngle = Math.acos(uvr.method_1026(u));
        double dist = targetPos.method_1022(origin);
        double scalProj = targetPos.method_1020(user.method_33571()).method_1026(user.method_5663().method_1029());
        boolean inAngle = targetAngle <= this.ha;
        boolean inRadius = dist <= this.ro;
        boolean inFront = scalProj > 0.0;
        return inAngle && inRadius && inFront;
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        int wildfireLevel = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.WILDFIRE.id));
        return 100 + 20 * wildfireLevel;
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        boolean active = CindersCharm.getBooleanProperty(stack, "active");
        class_1799 newStack = super.updateItem(stack, server);
        CindersCharm.putProperty(newStack, "active", active);
        return this.buildItemLore(newStack, server);
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8137, 2);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8894, 24);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8814, 32);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8135, 32);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_22020, 1);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8797, 32);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withCore().withAnvil());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Charm of Cinders").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nHaving spent much time in the Nether has given me ample opportunity to study the fire dwelling creatures. I believe I can replicate many of their abilities and make them my own.").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Charm of Cinders").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nThis Charm grants a variety of skills from base fire immunity to a simple flint and steel, to flaming breath and even the precise heat to smelt items as I pick them up.\n\nPunching mimics a flint and steel and can ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Charm of Cinders").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\neven set creatures ablaze.\n\nUsing the Charm sends a cone of flame out in a wide area, igniting creatures.\n\nSneak Using it toggles the auto-smelt ability for gathered items.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class CindersCharmItem
    extends ArcanaPolymerItem {
        public CindersCharmItem() {
            super(CindersCharm.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            boolean active = ArcanaItem.getBooleanProperty(itemStack, "active");
            boolean cremation = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.CREMATION.id) >= 1;
            ArrayList<String> stringList = new ArrayList<String>();
            if (active) {
                if (cremation) {
                    stringList.add("cremation_on");
                } else {
                    stringList.add("on");
                }
            } else if (cremation) {
                stringList.add("cremation_off");
            } else {
                stringList.add("off");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return CindersCharm.this.prefItem;
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            if (playerEntity.method_5715()) {
                return CindersCharm.this.toggleActive((class_3222)playerEntity, playerEntity.method_5998(hand));
            }
            class_1799 itemStack = playerEntity.method_5998(hand);
            int pyroblast = Math.max(0, ArcanaAugments.getAugmentOnItem(itemStack, "pyroblast"));
            int fireweb = Math.max(0, ArcanaAugments.getAugmentOnItem(itemStack, "web_of_fire"));
            if (pyroblast > 0) {
                return CindersCharm.this.pyroblast(playerEntity, world, itemStack, pyroblast);
            }
            if (fireweb > 0) {
                return CindersCharm.this.fireweb(playerEntity, world, itemStack, fireweb);
            }
            return CindersCharm.this.coneOfFlame(playerEntity, world, hand);
        }

        public void method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
            class_124 color;
            if (!(attacker instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)attacker;
            boolean cremation = ArcanaAugments.getAugmentOnItem(stack, "cremation") >= 1;
            class_124 class_1242 = color = cremation ? class_124.field_1075 : class_124.field_1061;
            if (CindersCharm.this.getEnergy(stack) < 5) {
                player.method_7353((class_2561)class_2561.method_43470((String)"The Charm has no Cinders").method_27692(color), true);
                return;
            }
            if (target instanceof class_1548) {
                class_1548 creeper = (class_1548)target;
                creeper.method_7004();
                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CINDERS_CHARM_IGNITE_CREEPER));
            } else {
                target.method_5639(5.0f);
                ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CINDERS_CHARM_IGNITE_ENTITY));
            }
            SoundUtils.playSound((class_1937)player.method_51469(), (class_2338)target.method_24515(), (class_3414)class_3417.field_15145, (class_3419)class_3419.field_15245, (float)1.0f, (float)(player.method_51469().method_8409().method_43057() * 0.4f + 0.8f));
            CindersCharm.this.addEnergy(stack, -5);
            Object message = "Cinders: ";
            for (int i = 1; i <= CindersCharm.this.getMaxEnergy(stack) / 20; ++i) {
                message = (String)message + (CindersCharm.this.getEnergy(stack) >= i * 20 ? "\u2726 " : "\u2727 ");
            }
            player.method_7353((class_2561)class_2561.method_43470((String)((String)message).toString()).method_27692(color), true);
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            boolean cremation = ArcanaAugments.getAugmentOnItem(stack, "cremation") >= 1;
            class_124 color = cremation ? class_124.field_1075 : class_124.field_1061;
            int oldEnergy = CindersCharm.this.getEnergy(stack);
            if (oldEnergy < CindersCharm.this.getMaxEnergy(stack) && world.method_8503().method_3780() % 15 == 0) {
                int bonusEnergy = ArcanaAugments.getAugmentOnItem(stack, "wildfire") == 5 ? 7 : 0;
                CindersCharm.this.addEnergy(stack, 3 + bonusEnergy);
                int newEnergy = CindersCharm.this.getEnergy(stack);
                if (oldEnergy / 20 != newEnergy / 20) {
                    StringBuilder message = new StringBuilder("Cinders: ");
                    for (int i = 1; i <= CindersCharm.this.getMaxEnergy(stack) / 20; ++i) {
                        message.append(newEnergy >= i * 20 ? "\u2726 " : "\u2727 ");
                    }
                    player.method_7353((class_2561)class_2561.method_43470((String)message.toString().toString()).method_27692(color), true);
                }
            }
            if (world.method_8503().method_3780() % 20 == 0 && !cremation) {
                class_1293 fireRes = new class_1293(class_1294.field_5918, 100, 0, false, false, false);
                player.method_6092(fireRes);
                if (player.method_5809()) {
                    player.method_5646();
                }
            }
        }
    }
}

