/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.charms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.EnergyItem;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.events.CleansingCharmEvent;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.events.Event;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4081;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class CleansingCharm
extends EnergyItem {
    public static final String ID = "cleansing_charm";

    public CleansingCharm() {
        this.id = ID;
        this.name = "Charm of Cleansing";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.ITEMS, TomeGui.TomeFilter.CHARMS};
        this.itemVersion = 0;
        this.vanillaItem = class_1802.field_8434;
        this.item = new CleansingCharmItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.cleansing_charm", (String)this.name).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067});
        this.researchTasks = new class_5321[]{ResearchTasks.MILK_CLEANSE, ResearchTasks.HONEY_CLEANSE, ResearchTasks.EFFECT_POISON, ResearchTasks.EFFECT_NAUSEA, ResearchTasks.EFFECT_BLINDNESS, ResearchTasks.ADVANCEMENT_FURIOUS_COCKTAIL};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        CleansingCharm.putProperty(stack, "active", true);
        this.setPrefStack(stack);
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        boolean active = CleansingCharm.getBooleanProperty(stack, "active");
        class_1799 newStack = super.updateItem(stack, server);
        CleansingCharm.putProperty(newStack, "active", active);
        return this.buildItemLore(newStack, server);
    }

    @Override
    public int getMaxEnergy(class_1799 item) {
        int cdLvl = Math.max(0, ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.INFUSED_CHARCOAL.id));
        return 30 - 5 * cdLvl;
    }

    public void cleanseEffect(class_3222 player, class_1799 stack) {
        if (!(ArcanaItemUtils.identifyItem(stack) instanceof CleansingCharm)) {
            return;
        }
        if (this.getEnergy(stack) > 0) {
            return;
        }
        ArrayList<Map.Entry> canCleanse = new ArrayList<Map.Entry>(player.method_6088().entrySet().stream().filter(entry -> ((class_1291)((class_6880)entry.getKey()).comp_349()).method_18792() == class_4081.field_18272 && !((class_6880)entry.getKey()).equals(ArcanaRegistry.GREATER_BLINDNESS_EFFECT)).toList());
        Collections.shuffle(canCleanse);
        if (canCleanse.size() >= 10) {
            ArcanaAchievements.grant(player, ArcanaAchievements.SEPTIC_SHOCK);
        }
        int toRemove = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.ANTIDOTE) > 0 ? 2 : 1;
        for (int i = 0; i < toRemove && !canCleanse.isEmpty(); ++i) {
            class_6880 effect = (class_6880)((Map.Entry)canCleanse.removeFirst()).getKey();
            player.method_6016(effect);
            Event.addEvent((Event)new CleansingCharmEvent(player, (class_6880<class_1291>)effect));
            if (ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.REJUVENATION) > 0) {
                class_1293 regen = new class_1293(class_1294.field_5924, 100, 1, false, false, true);
                player.method_6092(regen);
            }
            if (effect.equals((Object)class_1294.field_5903)) {
                ArcanaAchievements.grant(player, ArcanaAchievements.FOOD_POISONT);
            }
            this.setEnergy(stack, this.getMaxEnergy(stack));
            ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.CLEANSING_CHARM_CLEANSE));
        }
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"charm ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"emanates ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"a smell of ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"freshly washed clothes").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" and ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"clean air").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"charm ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"will periodically ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"remove ").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"one ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"negative effect").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1080)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" to toggle the ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"charm's").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" ability.").method_27692(class_124.field_1080)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8103, 1);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_20417, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8665, 48);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8477, 8);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8155, 32);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8603, 2);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {c, h, m, h, c}, {b, g, h, g, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"Charm of Cleansing").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nBy coalescing the cleansing effects of milk and honey into a pure carbon and silica matrix, I have made their effects renewable. \n\nWhile active, the Charm will cleanse a negative  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"Charm of Cleansing").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_2561.method_43470((String)"\neffect when it is applied, or a currently active effect. \n\nThis ability takes about a minute to recharge.\n\nSneak Use the Charm to toggle its effect.\n").method_27692(class_124.field_1074)));
        return list;
    }

    public class CleansingCharmItem
    extends ArcanaPolymerItem {
        public CleansingCharmItem() {
            super(CleansingCharm.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            boolean active = ArcanaItem.getBooleanProperty(itemStack, "active");
            ArrayList<String> stringList = new ArrayList<String>();
            if (active) {
                stringList.add("on");
            } else {
                stringList.add("off");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return CleansingCharm.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            if (ArcanaItem.getBooleanProperty(stack, "active")) {
                CleansingCharm.this.cleanseEffect(player, stack);
            }
            if (world.method_8503().method_3780() % 20 == 0) {
                CleansingCharm.this.addEnergy(stack, -1);
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            if (player.method_5715()) {
                boolean active = !ArcanaItem.getBooleanProperty(stack, "active");
                ArcanaItem.putProperty(stack, "active", active);
                if (active) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Charm glows with iridescence").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14891, (float)0.5f, (float)2.0f);
                } else {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Charm's glow fades").method_27695(new class_124[]{class_124.field_1075, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_19344, (float)0.5f, (float)0.8f);
                }
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }
    }
}

