/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.charms;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_10124;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4174;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FeastingCharm
extends ArcanaItem {
    public static final String ID = "feasting_charm";
    private static final int[] gluttonyFoodBoost = new int[]{0, 2, 4, 6};
    private static final float[] gluttonySatBoost = new float[]{0.0f, 0.25f, 0.5f, 1.0f};

    public FeastingCharm() {
        this.id = ID;
        this.name = "Charm of Feasting";
        this.rarity = ArcanaRarity.EXOTIC;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.CHARMS, TomeGui.TomeFilter.ITEMS};
        this.vanillaItem = class_1802.field_8308;
        this.item = new FeastingCharmItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.feasting_charm", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1065});
        this.researchTasks = new class_5321[]{ResearchTasks.ADVANCEMENT_BALANCED_DIET, ResearchTasks.HUNGER_DAMAGE, ResearchTasks.OBTAIN_ENCHANTED_GOLDEN_APPLE};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        FeastingCharm.putProperty(stack, "mode", 0);
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Just carrying the charm makes you feel ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"well nourished").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1077)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The charm ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"feeds").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)" you from your").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" inventory.").method_27692(class_124.field_1065)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right click").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" toggle ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"the charm between feeding modes.").method_27692(class_124.field_1077)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    public void toggleMode(class_3222 player, class_1799 stack) {
        int mode = (FeastingCharm.getIntProperty(stack, "mode") + 1) % 4;
        FeastingCharm.putProperty(stack, "mode", mode);
        switch (mode) {
            case 0: {
                player.method_7353((class_2561)class_2561.method_43470((String)"Feasting Mode: Optimal").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                break;
            }
            case 1: {
                player.method_7353((class_2561)class_2561.method_43470((String)"Feasting Mode: Regen").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                break;
            }
            case 2: {
                player.method_7353((class_2561)class_2561.method_43470((String)"Feasting Mode: Optimal + Emergency").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                break;
            }
            case 3: {
                player.method_7353((class_2561)class_2561.method_43470((String)"Feasting Mode: Regen + Emergency").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
            }
        }
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Charm of Feasting").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nA simple infusion of Arcana can go a long way. Returning to the Enchanted Golden Apple, a bit of extra Arcana supplemented it to become a pseudo-infinite food source.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Charm of Feasting").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nAny food in my inventory will get ingested by the Charm when I am hungry, as long as it is not an Enchanted Golden Apple.\n\nSimply wearing the Charm also causes my hunger to be satiated periodically.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Charm of Feasting").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nUsing the Charm switches the feeding mode.\n \nOptimal mode waits for me to be as hungry as the food will restore.\n\nRegen mode keeps me within the threshold for health regeneration. ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Charm of Feasting").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nEmergency mode feeds me whenever possible when I am below half health.").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8509, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_28659, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8176, 16);
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_8741, 16);
        ArcanaIngredient e = new ArcanaIngredient(class_1802.field_8229, 16);
        ArcanaIngredient f = new ArcanaIngredient(class_1802.field_8423, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8071, 8);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8463, 4);
        ArcanaIngredient j = new ArcanaIngredient(class_1802.field_8497, 16);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_8544, 16);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8367, 1, true);
        ArcanaIngredient o = new ArcanaIngredient(class_1802.field_8347, 16);
        ArcanaIngredient p = new ArcanaIngredient(class_1802.field_8186, 16);
        ArcanaIngredient t = new ArcanaIngredient(class_1802.field_8551, 16);
        ArcanaIngredient u = new ArcanaIngredient(class_1802.field_8752, 16);
        ArcanaIngredient v = new ArcanaIngredient(class_1802.field_8512, 16);
        ArcanaIngredient w = new ArcanaIngredient(class_1802.field_8261, 16);
        ArcanaIngredient x = new ArcanaIngredient(class_1802.field_16998, 16);
        ArcanaIngredient y = new ArcanaIngredient(class_1802.field_8373, 16);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, d, e}, {f, g, h, g, j}, {k, h, m, h, o}, {p, g, h, g, t}, {u, v, w, x, y}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    public class FeastingCharmItem
    extends ArcanaPolymerItem {
        public FeastingCharmItem() {
            super(FeastingCharm.this.getThis());
        }

        public class_1799 method_7854() {
            return FeastingCharm.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            int mode = ArcanaItem.getIntProperty(stack, "mode");
            int time = 400 - 100 * Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.ENZYMES.id));
            int gluttony = Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.GLUTTONY.id));
            if (world.method_8503().method_3780() % time == 0) {
                class_1661 inv = player.method_31548();
                class_1702 hunger = player.method_7344();
                ArrayList<Pair> availableFoods = new ArrayList<Pair>();
                int bestFoodInd = -1;
                for (int i = 0; i < inv.method_5439(); ++i) {
                    class_4174 foodComponent;
                    class_1799 invItem = inv.method_5438(i);
                    if (invItem.method_7960() || !invItem.method_57826(class_9334.field_50075) || !invItem.method_57826(class_9334.field_53964) || ArcanaItemUtils.isArcane(invItem) || invItem.method_7909() == class_1802.field_8367 || (foodComponent = (class_4174)invItem.method_58694(class_9334.field_50075)).comp_2491() < 1) continue;
                    availableFoods.add(new Pair((Object)i, (Object)foodComponent));
                    if (bestFoodInd != -1 && ((class_4174)inv.method_5438(bestFoodInd).method_58694(class_9334.field_50075)).comp_2491() >= foodComponent.comp_2491()) continue;
                    bestFoodInd = i;
                }
                if (bestFoodInd != -1) {
                    boolean consume;
                    class_1799 selectedFood = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.PICKY_EATER.id) >= 1 ? inv.method_5438(bestFoodInd) : inv.method_5438(((Integer)((Pair)availableFoods.getFirst()).getFirst()).intValue());
                    class_4174 foodComponent = (class_4174)selectedFood.method_58694(class_9334.field_50075);
                    int foodValue = foodComponent.comp_2491();
                    switch (mode) {
                        case 0: {
                            boolean bl;
                            if (20 - hunger.method_7586() >= foodValue) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 1: {
                            boolean bl;
                            if (hunger.method_7586() < 18) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 2: {
                            boolean bl;
                            if (20 - hunger.method_7586() >= foodValue || player.method_6032() < 10.0f) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        case 3: {
                            boolean bl;
                            if (hunger.method_7586() < 18 || player.method_6032() < 10.0f) {
                                bl = true;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        default: {
                            boolean bl = consume = false;
                        }
                    }
                    if (consume) {
                        player.method_7353((class_2561)class_2561.method_43470((String)("Your Feasting Charm consumes a " + selectedFood.method_7964().getString())).method_27695(new class_124[]{class_124.field_1065, class_124.field_1056}), true);
                        hunger.method_7585(gluttonyFoodBoost[gluttony], gluttonySatBoost[gluttony]);
                        if (selectedFood.method_31574(class_1802.field_8635)) {
                            ArcanaAchievements.setCondition(player, ArcanaAchievements.TARRARE.id, "Poisonous Potato", true);
                        } else if (selectedFood.method_31574(class_1802.field_8680)) {
                            ArcanaAchievements.setCondition(player, ArcanaAchievements.TARRARE.id, "Spider Eye", true);
                        } else if (selectedFood.method_31574(class_1802.field_8511)) {
                            ArcanaAchievements.setCondition(player, ArcanaAchievements.TARRARE.id, "Rotten Flesh", true);
                        } else if (selectedFood.method_31574(class_1802.field_8766)) {
                            ArcanaAchievements.setCondition(player, ArcanaAchievements.TARRARE.id, "Suspicious Stew", true);
                        } else if (selectedFood.method_31574(class_1802.field_8726)) {
                            ArcanaAchievements.setCondition(player, ArcanaAchievements.TARRARE.id, "Raw Chicken", true);
                        } else if (selectedFood.method_31574(class_1802.field_8323)) {
                            ArcanaAchievements.setCondition(player, ArcanaAchievements.TARRARE.id, "Pufferfish", true);
                        }
                        class_10124 consumableComponent = (class_10124)selectedFood.method_58694(class_9334.field_53964);
                        consumableComponent.method_62847((class_1937)world, (class_1309)player, selectedFood);
                        ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.FEASTING_CHARM_PER_FOOD_VALUE) * foodValue);
                    }
                }
            }
            if (world.method_8503().method_3780() % (time * 6) == 0) {
                player.method_7344().method_7585(1 + gluttony, (float)(1 + gluttony) * 0.25f);
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            FeastingCharm.this.toggleMode((class_3222)playerEntity, playerEntity.method_5998(hand));
            return class_1269.field_52422;
        }
    }
}

