/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.charms;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.MinecraftUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class FelidaeCharm
extends ArcanaItem {
    public static final String ID = "felidae_charm";

    public FelidaeCharm() {
        this.id = ID;
        this.name = "Charm of Felidae";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.CHARMS, TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 1;
        this.vanillaItem = class_1802.field_8276;
        this.item = new FelidaeCharmItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.felidae_charm", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1054});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_CREEPER_HEAD, ResearchTasks.ADVANCEMENT_COMPLETE_CATALOGUE, ResearchTasks.CAT_SCARE, ResearchTasks.FEATHER_FALL, ResearchTasks.UNLOCK_MIDNIGHT_ENCHANTER};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The charm ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"purrs ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"softly when worn.").method_27692(class_124.field_1065)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Keeping this ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"charm ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)"on your person gives you ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"cat-like").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" abilities.").method_27692(class_124.field_1065)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Your ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"falls ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"become somewhat ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"graceful ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"cushioned").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1065)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Creepers ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"and ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"Phantoms ").method_27692(class_124.field_1078)).method_10852((class_2561)class_2561.method_43470((String)"give you a ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"wide berth").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1065)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8054, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8276, 12);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8323, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8614, 4);
        ArcanaIngredient w = new ArcanaIngredient(class_1802.field_8209, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8598, 1).withEnchantments(new class_1889(MinecraftUtils.getEnchantment((class_5321)class_1893.field_9129), 4));
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_8429, 16);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8681, 1, true);
        ArcanaIngredient o = new ArcanaIngredient(class_1802.field_8846, 16);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, g, h, g, b}, {k, h, m, h, o}, {b, g, h, g, b}, {a, b, w, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement().withEnchanter());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)" Charm of Felidae").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nCats are quite powerful creatures, managing to frighten phantoms and creepers. They can even fall from any height without care.\n\nThis Charm seeks to mimic a fraction of  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)" Charm of Felidae").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\ntheir majestic power.\n\nThe Charm halves all fall damage, stops phantoms from swooping the holder, and gives creepers a good scare if they get too close.").method_27692(class_124.field_1074)));
        return list;
    }

    public class FelidaeCharmItem
    extends ArcanaPolymerItem {
        public FelidaeCharmItem() {
            super(FelidaeCharm.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            ArrayList<String> stringList = new ArrayList<String>();
            if (ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.PANTHERA.id) >= 1) {
                stringList.add("panthera");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return FelidaeCharm.this.prefItem;
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15051, (float)1.0f, (float)((float)(0.5 * (Math.random() - 0.5) + 1.0)));
            return class_1269.field_52422;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            if (world.method_8503().method_3780() % 20 == 0 && !player.method_7325()) {
                class_243 pos = player.method_19538();
                class_238 rangeBox = new class_238(pos.field_1352 + 5.0, pos.field_1351 + 3.0, pos.field_1350 + 5.0, pos.field_1352 - 5.0, pos.field_1351 - 3.0, pos.field_1350 - 5.0);
                List entities = world.method_8333(null, rangeBox, e -> !e.method_7325() && e instanceof class_1548);
                if (entities.size() >= 4) {
                    ArcanaAchievements.grant(player, ArcanaAchievements.INFILTRATION.id);
                }
            }
        }
    }
}

