/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.charms;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3545;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6089;
import net.minecraft.class_6880;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class LightCharm
extends ArcanaItem {
    public static final String ID = "light_charm";
    public static final String VISION_TAG = "vision";
    public static final String BRIGHTNESS_TAG = "brightness";
    public static final String THRESHOLD_TAG = "threshold";
    public static final String NOVA_TAG = "novaCD";

    public LightCharm() {
        this.id = ID;
        this.name = "Charm of Light";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.CHARMS, TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 1;
        this.vanillaItem = class_1802.field_17525;
        this.item = new LightCharmItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.light_charm", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1054});
        this.researchTasks = new class_5321[]{ResearchTasks.EFFECT_NIGHT_VISION, ResearchTasks.PLACE_TORCHES, ResearchTasks.ADVANCEMENT_CREATE_FULL_BEACON};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        LightCharm.putProperty(stack, VISION_TAG, false);
        LightCharm.putProperty(stack, "active", false);
        LightCharm.putProperty(stack, BRIGHTNESS_TAG, 11);
        LightCharm.putProperty(stack, "mode", 0);
        LightCharm.putProperty(stack, THRESHOLD_TAG, 1);
        LightCharm.putProperty(stack, NOVA_TAG, 0);
        this.setPrefStack(stack);
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"The charm ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"radiates").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" a warm glow.").method_27692(class_124.field_1065)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Its light seems to ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"linger").method_27692(class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)" behind you.").method_27692(class_124.field_1065)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right click").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to adjust the ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"setting").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1065)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right click").method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" to toggle the charm ").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"mode").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1065)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    public void changeSetting(class_3222 player, class_1799 item) {
        boolean vision = LightCharm.getBooleanProperty(item, VISION_TAG);
        boolean active = LightCharm.getBooleanProperty(item, "active");
        int mode = LightCharm.getIntProperty(item, "mode");
        int threshold = LightCharm.getIntProperty(item, THRESHOLD_TAG);
        int brightness = LightCharm.getIntProperty(item, BRIGHTNESS_TAG);
        int novaCD = LightCharm.getIntProperty(item, NOVA_TAG);
        switch (mode) {
            case 0: {
                active = !active;
                LightCharm.putProperty(item, "active", active);
                if (active) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Charm's Light Brightens").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14703, (float)1.0f, (float)2.0f);
                    break;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"The Charm's Light Dims").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_19344, (float)1.0f, (float)0.5f);
                break;
            }
            case 1: {
                vision = !vision;
                LightCharm.putProperty(item, VISION_TAG, vision);
                if (vision) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"You can now see the arcane lights").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14703, (float)1.0f, (float)2.0f);
                    break;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"You can no longer see the arcane lights").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_19344, (float)1.0f, (float)0.5f);
                break;
            }
            case 2: {
                threshold = (threshold + 1) % 16;
                player.method_7353((class_2561)class_2561.method_43470((String)("Light Threshold: " + threshold)).method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                LightCharm.putProperty(item, THRESHOLD_TAG, threshold);
                break;
            }
            case 3: {
                brightness = (brightness + 1) % 16;
                player.method_7353((class_2561)class_2561.method_43470((String)("Light Brightness: " + brightness)).method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                LightCharm.putProperty(item, BRIGHTNESS_TAG, brightness);
                break;
            }
            case 4: {
                if (novaCD == 0) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"The Charm's Light Flares!").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                    this.nova(player, item);
                    LightCharm.putProperty(item, NOVA_TAG, 30);
                    break;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)("Radiant Nova Cooldown: " + novaCD + " seconds")).method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                break;
            }
        }
    }

    private void nova(class_3222 player, class_1799 stack) {
        int limit;
        class_3218 world = player.method_51469();
        class_2338 center = player.method_24515();
        int range = 32;
        int threshold = 3;
        class_2338 max = center.method_10069(range, 10, range);
        class_2338 min = center.method_10069(-range, -3 * range, -range);
        HashSet<class_2338> possiblePositions = new HashSet<class_2338>();
        for (int x = min.method_10263(); x <= max.method_10263(); ++x) {
            for (int y = min.method_10264(); y <= max.method_10264(); ++y) {
                for (int z = min.method_10260(); z <= max.method_10260(); ++z) {
                    class_2680 class_26802;
                    class_2338 pos = new class_2338(x, y, z);
                    if (!world.method_24794(pos) || !(class_26802 = world.method_8320(pos)).method_26215() || world.method_8314(class_1944.field_9282, pos) > threshold) continue;
                    possiblePositions.add(pos);
                }
            }
        }
        ArrayList<class_3545<class_2338, Integer>> pairTree = new ArrayList<class_3545<class_2338, Integer>>();
        int n = limit = threshold == 15 ? 1 : 15 - threshold;
        while (!possiblePositions.isEmpty()) {
            class_2338 root = (class_2338)possiblePositions.iterator().next();
            this.iterativeNovaSearch(limit, (class_3545<class_2338, Integer>)new class_3545((Object)root, (Object)0), possiblePositions, pairTree);
        }
        int placedCount = 0;
        for (class_3545 class_35452 : pairTree) {
            if ((Integer)class_35452.method_15441() != 0) continue;
            world.method_8652((class_2338)class_35452.method_15442(), (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_6089.field_31187, (Comparable)Integer.valueOf(15)), 3);
            world.method_33596((class_1297)player, (class_6880)class_5712.field_28164, (class_2338)class_35452.method_15442());
            ++placedCount;
        }
        ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.LIGHT_CHARM_NOVA_PER_LIGHT) * placedCount);
        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_15013, (float)1.0f, (float)0.5f);
    }

    private void iterativeNovaSearch(int limit, class_3545<class_2338, Integer> startPair, Set<class_2338> posSet, List<class_3545<class_2338, Integer>> pairTree) {
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(startPair);
        class_2382[] diagonals = new class_2382[]{new class_2382(1, 1, 0), new class_2382(-1, 1, 0), new class_2382(0, 1, 1), new class_2382(0, 1, -1), new class_2382(1, -1, 0), new class_2382(-1, -1, 0), new class_2382(0, -1, 1), new class_2382(0, -1, -1), new class_2382(1, 0, 1), new class_2382(-1, 0, 1), new class_2382(1, 0, -1), new class_2382(-1, 0, -1)};
        while (!queue.isEmpty()) {
            class_2338 offset;
            class_3545 pair = (class_3545)queue.poll();
            class_2338 pos = (class_2338)pair.method_15442();
            if (!posSet.remove(pos)) continue;
            pairTree.add((class_3545<class_2338, Integer>)pair);
            for (class_2350 class_23502 : class_2350.values()) {
                offset = pos.method_10093(class_23502);
                if (!posSet.contains(offset) || (Integer)pair.method_15441() + 1 > limit) continue;
                queue.add(new class_3545((Object)offset, (Object)((Integer)pair.method_15441() + 1)));
            }
            for (class_2350 class_23503 : diagonals) {
                offset = pos.method_25503().method_10081((class_2382)class_23503);
                if (!posSet.contains(offset) || (Integer)pair.method_15441() + 2 > limit) continue;
                queue.add(new class_3545((Object)offset, (Object)((Integer)pair.method_15441() + 2)));
            }
        }
    }

    public void selectMode(class_3222 player, class_1799 item) {
        boolean vision = LightCharm.getBooleanProperty(item, VISION_TAG);
        boolean active = LightCharm.getBooleanProperty(item, "active");
        int mode = LightCharm.getIntProperty(item, "mode");
        int threshold = LightCharm.getIntProperty(item, THRESHOLD_TAG);
        int brightness = LightCharm.getIntProperty(item, BRIGHTNESS_TAG);
        int novaCD = LightCharm.getIntProperty(item, NOVA_TAG);
        boolean hasThresh = ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.MOOD_LIGHTING.id) >= 1;
        boolean hasBright = ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.DIMMER_SWITCH.id) >= 1;
        boolean hasNova = ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.RADIANCE.id) >= 1;
        boolean hasManual = ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.SELECTIVE_PLACEMENT.id) >= 1;
        ArrayList<Integer> possibleModes = new ArrayList<Integer>();
        possibleModes.add(0);
        possibleModes.add(1);
        if (hasThresh) {
            possibleModes.add(2);
        }
        if (hasBright) {
            possibleModes.add(3);
        }
        if (hasNova) {
            possibleModes.add(4);
        }
        if (hasManual) {
            possibleModes.add(5);
        }
        int curInd = possibleModes.indexOf(mode);
        int newInd = (curInd + 1) % possibleModes.size();
        mode = (Integer)possibleModes.get(newInd);
        switch (mode) {
            case 0: {
                player.method_7353((class_2561)class_2561.method_43470((String)"Mode: Toggle Light Placement").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                break;
            }
            case 1: {
                player.method_7353((class_2561)class_2561.method_43470((String)"Mode: Toggle Light Visibility").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                break;
            }
            case 2: {
                player.method_7353((class_2561)class_2561.method_43470((String)"Mode: Threshold Selection").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                break;
            }
            case 3: {
                player.method_7353((class_2561)class_2561.method_43470((String)"Mode: Brightness Selection").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                break;
            }
            case 4: {
                player.method_7353((class_2561)class_2561.method_43470((String)"Mode: Radiant Nova").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
                break;
            }
            case 5: {
                player.method_7353((class_2561)class_2561.method_43470((String)"Mode: Manual Placement").method_27695(new class_124[]{class_124.field_1054, class_124.field_1056}), true);
            }
        }
        LightCharm.putProperty(item, "mode", mode);
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"   Charm of Light").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nI\u2019ve placed too many torches, surely there is an alternative beyond risking the darkness. A beacon is a solid place to start.\n\nAfter combining some other light sources and a few potions, I ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Charm of Light").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nhave a renewable light source that leaves lingering, invisible, arcane lights behind in the darkness.\n\nThe potions in the Charm allow me to see the lights when needed, in case I wish to remove them.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Charm of Light").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nUsing the Charm switches its mode.\n\nSneak Using toggles the selected mode.\n\nThe Charm can be toggled to stop leaving lights, or to make the lights become visible.\n").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"   Charm of Light").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}), class_2561.method_43470((String)"\nThe lights are immovable by pistons, and can be removed by placing a block in them.").method_27692(class_124.field_1074)));
        return list;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_8574, 1).withPotions(class_1847.field_8981);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8810, 32);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_37540, 16);
        ArcanaIngredient d = new ArcanaIngredient(class_1802.field_22016, 32);
        ArcanaIngredient f = new ArcanaIngredient(class_1802.field_8230, 16);
        ArcanaIngredient g = new ArcanaIngredient(class_1802.field_8305, 8);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8801, 8);
        ArcanaIngredient j = new ArcanaIngredient(class_1802.field_27024, 16);
        ArcanaIngredient k = new ArcanaIngredient(class_1802.field_37541, 16);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_8668, 1, true);
        ArcanaIngredient o = new ArcanaIngredient(class_1802.field_22017, 16);
        ArcanaIngredient p = new ArcanaIngredient(class_1802.field_8693, 16);
        ArcanaIngredient t = new ArcanaIngredient(class_1802.field_47018, 16);
        ArcanaIngredient v = new ArcanaIngredient(class_1802.field_16539, 32);
        ArcanaIngredient w = new ArcanaIngredient(class_1802.field_37539, 16);
        ArcanaIngredient x = new ArcanaIngredient(class_1802.field_22001, 32);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, d, a}, {f, g, h, g, j}, {k, h, m, h, o}, {p, g, h, g, t}, {a, v, w, x, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    public class LightCharmItem
    extends ArcanaPolymerItem {
        public LightCharmItem() {
            super(LightCharm.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            boolean active = ArcanaItem.getBooleanProperty(itemStack, "active");
            ArrayList<String> stringList = new ArrayList<String>();
            if (active) {
                stringList.add("on");
            } else {
                stringList.add("off");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return LightCharm.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            class_2338 pos;
            class_3218 serverWorld;
            block11: {
                block10: {
                    if (!ArcanaItemUtils.isArcane(stack)) {
                        return;
                    }
                    if (!(world instanceof class_3218)) break block10;
                    serverWorld = world;
                    if (entity instanceof class_3222) break block11;
                }
                return;
            }
            class_3222 player = (class_3222)entity;
            boolean vision = ArcanaItem.getBooleanProperty(stack, LightCharm.VISION_TAG);
            boolean active = ArcanaItem.getBooleanProperty(stack, "active");
            int threshold = ArcanaItem.getIntProperty(stack, LightCharm.THRESHOLD_TAG);
            int brightness = ArcanaItem.getIntProperty(stack, LightCharm.BRIGHTNESS_TAG);
            int novaCD = ArcanaItem.getIntProperty(stack, LightCharm.NOVA_TAG);
            if (world.method_8503().method_3780() % 60 == 0) {
                pos = player.method_24515();
                if (active && world.method_22339(pos) <= threshold && world.method_8320(pos).method_26215()) {
                    world.method_8652(pos, (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_6089.field_31187, (Comparable)Integer.valueOf(brightness)), 3);
                    world.method_33596((class_1297)player, (class_6880)class_5712.field_28164, pos);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_23116, (float)0.3f, (float)2.0f);
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.LIGHT_CHARM_AUTOMATIC));
                    ArcanaAchievements.progress(player, ArcanaAchievements.ENLIGHTENED.id, 1);
                }
            }
            if (world.method_8503().method_3780() % 20 == 0) {
                if (novaCD > 0) {
                    ArcanaItem.putProperty(stack, LightCharm.NOVA_TAG, novaCD - 1);
                }
                pos = player.method_24515();
                if (vision) {
                    for (class_2338 block : class_2338.method_25996((class_2338)pos, (int)10, (int)10, (int)10)) {
                        class_2680 state = world.method_8320(block);
                        if (!state.method_26204().equals(class_2246.field_31037)) continue;
                        serverWorld.method_14166(player, (class_2394)new class_2388(class_2398.field_35434, state), true, true, (double)block.method_10263() + 0.5, (double)block.method_10264() + 0.5, (double)block.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
        }

        public class_1269 method_7884(class_1838 context) {
            class_1657 playerEntity = context.method_8036();
            class_1937 world = context.method_8045();
            class_1268 hand = context.method_20287();
            class_1799 stack = context.method_8041();
            if (playerEntity == null) {
                return class_1269.field_5811;
            }
            int mode = ArcanaItem.getIntProperty(stack, "mode");
            int brightness = ArcanaItem.getIntProperty(stack, LightCharm.BRIGHTNESS_TAG);
            class_2350 side = context.method_8038();
            class_2338 pos = context.method_8037().method_10081(side.method_62675());
            boolean placeable = world.method_8320(pos).method_26166(new class_1750(playerEntity, hand, new class_1799((class_1935)class_1802.field_30904), new class_3965(context.method_17698(), context.method_8038(), context.method_8037(), context.method_17699())));
            if (mode == 5 && playerEntity instanceof class_3222) {
                class_3222 player = (class_3222)playerEntity;
                if (placeable) {
                    world.method_8652(pos, (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_6089.field_31187, (Comparable)Integer.valueOf(brightness)), 3);
                    world.method_33596((class_1297)player, (class_6880)class_5712.field_28164, pos);
                    SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_23116, (float)0.3f, (float)2.0f);
                    ArcanaNovum.data((class_1657)player).addXP(ArcanaConfig.getInt(ArcanaRegistry.LIGHT_CHARM_MANUAL));
                    ArcanaAchievements.progress(player, ArcanaAchievements.ENLIGHTENED.id, 1);
                    return class_1269.field_52422;
                }
            }
            return class_1269.field_5811;
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            if (playerEntity.method_5715()) {
                LightCharm.this.selectMode((class_3222)playerEntity, playerEntity.method_5998(hand));
            } else {
                LightCharm.this.changeSetting((class_3222)playerEntity, playerEntity.method_5998(hand));
            }
            return class_1269.field_52422;
        }
    }
}

