/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.items.charms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaNovum;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.achievements.ArcanaAchievements;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.core.ArcanaRarity;
import net.borisshoes.arcananovum.core.polymer.ArcanaPolymerItem;
import net.borisshoes.arcananovum.gui.arcanetome.TomeGui;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaRecipe;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.borisshoes.borislib.utils.SoundUtils;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5575;
import net.minecraft.class_7923;
import net.minecraft.class_9280;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.PacketContext;

public class MagnetismCharm
extends ArcanaItem {
    public static final String ID = "magnetism_charm";
    public static final String FILTER_TAG = "filter";

    public MagnetismCharm() {
        this.id = ID;
        this.name = "Charm of Magnetism";
        this.rarity = ArcanaRarity.EMPOWERED;
        this.categories = new TomeGui.TomeFilter[]{ArcanaRarity.getTomeFilter(this.rarity), TomeGui.TomeFilter.CHARMS, TomeGui.TomeFilter.ITEMS};
        this.itemVersion = 2;
        this.vanillaItem = class_1802.field_8620;
        this.item = new MagnetismCharmItem();
        this.displayName = class_2561.method_48321((String)"item.arcananovum.magnetism_charm", (String)this.name).method_27695(new class_124[]{class_124.field_1067, class_124.field_1080});
        this.researchTasks = new class_5321[]{ResearchTasks.OBTAIN_HEAVY_CORE, ResearchTasks.FISH_ITEM};
        class_1799 stack = new class_1799((class_1935)this.item);
        this.initializeArcanaTag(stack);
        stack.method_7939(this.item.method_7882());
        MagnetismCharm.putProperty(stack, "mode", 0);
        MagnetismCharm.putProperty(stack, "cooldown", 0);
        MagnetismCharm.putProperty(stack, FILTER_TAG, (class_2520)new class_2487());
        this.setPrefStack(stack);
    }

    @Override
    public List<class_2561> getItemLore(@Nullable class_1799 itemStack) {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"You can feel the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"charm").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)" tugging ").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)"on surrounding objects.").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"drag ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"nearby items to you.").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak Right Click").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to toggle the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"magnetism ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)"passively").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        lore.add(class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Sneak").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)" to temporarily disable the ").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"passive").method_27692(class_124.field_1077)).method_10852((class_2561)class_2561.method_43470((String)" pull").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1063)));
        return lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public class_1799 updateItem(class_1799 stack, MinecraftServer server) {
        int cooldown = MagnetismCharm.getIntProperty(stack, "cooldown");
        int mode = MagnetismCharm.getIntProperty(stack, "mode");
        class_2487 filter = MagnetismCharm.getCompoundProperty(stack, FILTER_TAG);
        class_1799 newStack = super.updateItem(stack, server);
        MagnetismCharm.putProperty(newStack, "cooldown", cooldown);
        MagnetismCharm.putProperty(newStack, "mode", mode);
        MagnetismCharm.putProperty(newStack, FILTER_TAG, (class_2520)filter);
        return this.buildItemLore(newStack, server);
    }

    public void activeUse(class_3222 player, class_1937 world, class_1799 charm) {
        int activeLength = 15 + 3 * Math.max(0, ArcanaAugments.getAugmentOnItem(charm, ArcanaAugments.ELECTROMAGNET.id));
        int activeRange = 3;
        int cooldown = MagnetismCharm.getIntProperty(charm, "cooldown");
        if (cooldown != 0) {
            return;
        }
        player.method_7357().method_62835(charm, 20);
        MagnetismCharm.putProperty(charm, "cooldown", 1);
        class_243 playerPos = player.method_33571();
        class_243 view = player.method_5663();
        class_243 rayEnd = playerPos.method_1019(view.method_1021((double)activeLength));
        class_238 box = new class_238(playerPos, playerPos).method_1014((double)(activeLength + activeRange));
        List items = world.method_18023((class_5575)class_1299.field_6052, box, entity -> this.itemInRange(entity.method_19538(), playerPos, rayEnd, activeRange) && this.canAffectItem(charm, entity.method_6983().method_7909()));
        SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_24630, (float)1.0f, (float)0.9f);
        for (class_1542 item : items) {
            double x = playerPos.method_10216() - item.method_23317();
            double y = playerPos.method_10214() - item.method_23318();
            double z = playerPos.method_10215() - item.method_23321();
            double speed = 0.1;
            double heightMod = 0.08;
            item.method_18800(x * speed, y * speed + Math.sqrt(Math.sqrt(x * x + y * y + z * z)) * heightMod, z * speed);
        }
        ArcanaNovum.data((class_1657)player).addXP(Math.min(ArcanaConfig.getInt(ArcanaRegistry.MAGNETISM_CHARM_CAP), ArcanaConfig.getInt(ArcanaRegistry.MAGNETISM_CHARM_PER_ITEM) * items.size()));
        if (items.size() >= 25) {
            ArcanaAchievements.grant(player, ArcanaAchievements.MAGNETS.id);
        }
        if (ArcanaAugments.getAugmentOnItem(charm, ArcanaAugments.NEODYMIUM.id) >= 1) {
            List entities = world.method_8333((class_1297)player, box, entity -> this.itemInRange(entity.method_19538(), playerPos, rayEnd, activeRange) && entity instanceof class_1309);
            for (class_1297 entity2 : entities) {
                class_1309 e = (class_1309)entity2;
                if (e instanceof class_3222) {
                    class_3222 hitPlayer = (class_3222)e;
                    if (!hitPlayer.method_6039()) continue;
                    hitPlayer.method_7357().method_62835(hitPlayer.method_62821(), 100);
                    hitPlayer.method_6021();
                    hitPlayer.method_51469().method_8421((class_1297)hitPlayer, (byte)30);
                    continue;
                }
                HashMap<class_1304, class_1799> equipment = new HashMap<class_1304, class_1799>();
                class_1799 head = e.method_6118(class_1304.field_6169);
                class_1799 chest = e.method_6118(class_1304.field_6174);
                class_1799 legs = e.method_6118(class_1304.field_6172);
                class_1799 feet = e.method_6118(class_1304.field_6166);
                class_1799 hand1 = e.method_6118(class_1304.field_6173);
                class_1799 hand2 = e.method_6118(class_1304.field_6171);
                equipment.put(class_1304.field_6169, head);
                equipment.put(class_1304.field_6174, chest);
                equipment.put(class_1304.field_6172, legs);
                equipment.put(class_1304.field_6166, feet);
                equipment.put(class_1304.field_6173, hand1);
                equipment.put(class_1304.field_6171, hand2);
                for (Map.Entry entry : equipment.entrySet()) {
                    class_1799 item = (class_1799)entry.getValue();
                    if (!item.method_31573(ArcanaRegistry.NEODYMIUM_STEALABLE)) continue;
                    class_1542 droppedItem = e.method_5775(player.method_51469(), item);
                    if (droppedItem != null) {
                        double x = playerPos.method_10216() - droppedItem.method_23317();
                        double y = playerPos.method_10214() - droppedItem.method_23318();
                        double z = playerPos.method_10215() - droppedItem.method_23321();
                        double speed = 0.1;
                        double heightMod = 0.08;
                        droppedItem.method_18800(x * speed, y * speed + Math.sqrt(Math.sqrt(x * x + y * y + z * z)) * heightMod, z * speed);
                    }
                    e.method_5673((class_1304)entry.getKey(), class_1799.field_8037);
                }
            }
        }
    }

    private boolean itemInRange(class_243 itemPos, class_243 start, class_243 end, int activeRange) {
        double dist = itemPos.method_1020(start).method_1036(end.method_1020(start)).method_1033() / end.method_1020(start).method_1033();
        return dist <= (double)activeRange;
    }

    public void toggleMode(class_3222 player, class_1799 item) {
        boolean canRepel = ArcanaAugments.getAugmentOnItem(item, ArcanaAugments.POLARITY_REVERSAL.id) >= 1;
        int mode = (MagnetismCharm.getIntProperty(item, "mode") + 1) % (canRepel ? 3 : 2);
        MagnetismCharm.putProperty(item, "mode", mode);
        if (mode == 1) {
            player.method_7353((class_2561)class_2561.method_43470((String)"The Charm's Pull Strengthens").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14833, (float)1.0f, (float)2.0f);
        } else if (mode == 2) {
            player.method_7353((class_2561)class_2561.method_43470((String)"The Charm's Pull Reverses").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14833, (float)1.0f, (float)1.0f);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"The Charm's Pull Weakens").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}), true);
            SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14833, (float)0.3f, (float)0.5f);
        }
    }

    public boolean canAffectItem(class_1799 magnet, class_1792 filterItem) {
        class_2487 filter = MagnetismCharm.getCompoundProperty(magnet, FILTER_TAG);
        String itemId = class_7923.field_41178.method_10221((Object)filterItem).toString();
        boolean hasWhitelist = filter.method_10541().stream().anyMatch(s -> filter.method_68083(s, 0) == 1);
        int status = filter.method_68083(itemId, 0);
        return hasWhitelist && status == 1 || !hasWhitelist && status != 2;
    }

    public void toggleFilterItem(class_3222 player, class_1799 magnet, class_1792 filterItem) {
        class_2487 filter = MagnetismCharm.getCompoundProperty(magnet, FILTER_TAG);
        String itemId = class_7923.field_41178.method_10221((Object)filterItem).toString();
        int itemStatus = 0;
        if (filter.method_10545(itemId)) {
            itemStatus = filter.method_68083(itemId, 0);
        }
        if ((itemStatus = (itemStatus + 1) % 3) == 0) {
            filter.method_10551(itemId);
            player.method_7353((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Removed ").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43471((String)filterItem.method_7876()).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" from the filter").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})), true);
        } else if (itemStatus == 1) {
            filter.method_10569(itemId, itemStatus);
            player.method_7353((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Whitelisted ").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43471((String)filterItem.method_7876()).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" in the filter").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})), true);
        } else if (itemStatus == 2) {
            filter.method_10569(itemId, itemStatus);
            player.method_7353((class_2561)class_2561.method_43470((String)"").method_10852((class_2561)class_2561.method_43470((String)"Blacklisted ").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})).method_10852((class_2561)class_2561.method_43471((String)filterItem.method_7876()).method_27695(new class_124[]{class_124.field_1063, class_124.field_1056})).method_10852((class_2561)class_2561.method_43470((String)" from the filter").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})), true);
        }
        MagnetismCharm.putProperty(magnet, FILTER_TAG, (class_2520)filter);
    }

    @Override
    public boolean blocksHandInteractions(class_1799 item) {
        return true;
    }

    @Override
    protected ArcanaRecipe makeRecipe() {
        ArcanaIngredient a = new ArcanaIngredient(class_1802.field_27051, 16);
        ArcanaIngredient b = new ArcanaIngredient(class_1802.field_8620, 16);
        ArcanaIngredient c = new ArcanaIngredient(class_1802.field_8076, 16);
        ArcanaIngredient h = new ArcanaIngredient(class_1802.field_8773, 8);
        ArcanaIngredient m = new ArcanaIngredient(class_1802.field_49813, 1, true);
        ArcanaIngredient[][] ingredients = new ArcanaIngredient[][]{{a, b, c, b, a}, {b, c, h, c, b}, {c, h, m, h, c}, {b, c, h, c, b}, {a, b, c, b, a}};
        return new ArcanaRecipe(ingredients, new ForgeRequirement());
    }

    @Override
    public List<List<class_2561>> getBookLore() {
        ArrayList<List<class_2561>> list = new ArrayList<List<class_2561>>();
        list.add(List.of(class_2561.method_43470((String)"      Charm of\n      Magnetism").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\nRarity: ").method_27692(class_124.field_1074).method_10852(ArcanaRarity.getColoredLabel(this.getRarity(), false)), class_2561.method_43470((String)"\nMagnets, how do they work? Well, they pull stuff sometimes\u2026 Unfortunately, they only work on some materials, and with limited range. I believe this Heavy Core that I have found presents  ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Charm of\n      Magnetism").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\ngravitic properties that can supercharge a magnet\u2019s abilities. Surrounding the Core in iron and striking it with lightning should leave an empowered permanent magnet.\n\nSneak Using the Charm toggles it passively ").method_27692(class_124.field_1074)));
        list.add(List.of(class_2561.method_43470((String)"      Charm of\n      Magnetism").method_27695(new class_124[]{class_124.field_1080, class_124.field_1067}), class_2561.method_43470((String)"\npulling items around me.\n\nUsing the charm directs a magnetic field a greater distance in the direction of my gaze that pulls items towards me. ").method_27692(class_124.field_1074)));
        return list;
    }

    public class MagnetismCharmItem
    extends ArcanaPolymerItem {
        public MagnetismCharmItem() {
            super(MagnetismCharm.this.getThis());
        }

        @Override
        public class_1799 getPolymerItemStack(class_1799 itemStack, class_1836 tooltipType, PacketContext context) {
            class_1799 baseStack = super.getPolymerItemStack(itemStack, tooltipType, context);
            if (!ArcanaItemUtils.isArcane(itemStack)) {
                return baseStack;
            }
            int mode = ArcanaItem.getIntProperty(itemStack, "mode");
            boolean neo = ArcanaAugments.getAugmentOnItem(itemStack, ArcanaAugments.NEODYMIUM.id) >= 1;
            ArrayList<String> stringList = new ArrayList<String>();
            if (neo) {
                if (mode == 2) {
                    stringList.add("neo_reverse");
                } else if (mode == 1) {
                    stringList.add("neo_on");
                } else {
                    stringList.add("neo_off");
                }
            } else if (mode == 2) {
                stringList.add("reverse");
            } else if (mode == 1) {
                stringList.add("on");
            } else {
                stringList.add("off");
            }
            baseStack.method_57379(class_9334.field_49637, (Object)new class_9280(new ArrayList(), new ArrayList(), stringList, new ArrayList()));
            return baseStack;
        }

        public class_1799 method_7854() {
            return MagnetismCharm.this.prefItem;
        }

        public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, @Nullable class_1304 slot) {
            int mode;
            if (!ArcanaItemUtils.isArcane(stack)) {
                return;
            }
            if (!(world instanceof class_3218) || !(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            int passiveRange = 5 + Math.max(0, ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.FERRITE_CORE.id));
            int cooldown = ArcanaItem.getIntProperty(stack, "cooldown");
            if (!player.method_5715() && (mode = ArcanaItem.getIntProperty(stack, "mode")) > 0 && world.method_8503().method_3780() % 10 == 0) {
                class_243 playerPos = player.method_33571();
                class_238 box = new class_238(playerPos, playerPos).method_1014((double)passiveRange);
                List items = world.method_18023((class_5575)class_1299.field_6052, box, e -> MagnetismCharm.this.canAffectItem(stack, e.method_6983().method_7909()));
                Collections.shuffle(items);
                int i = 0;
                for (class_1542 item : items) {
                    double x = playerPos.method_10216() - item.method_23317();
                    double y = playerPos.method_10214() - item.method_23318();
                    double z = playerPos.method_10215() - item.method_23321();
                    double speed = 0.06;
                    double heightMod = 0.04;
                    if (mode == 2) {
                        x = -x;
                        z = -z;
                    }
                    item.method_18800(x * speed, y * speed + Math.sqrt(Math.sqrt(x * x + y * y + z * z)) * heightMod, z * speed);
                    if (i >= 25) break;
                    ++i;
                }
            }
            if (world.method_8503().method_3780() % 20 == 0 && cooldown > 0) {
                ArcanaItem.putProperty(stack, "cooldown", cooldown - 1);
            }
        }

        public class_1269 method_7836(class_1937 world, class_1657 playerEntity, class_1268 hand) {
            class_1799 stack = playerEntity.method_5998(hand);
            if (!(playerEntity instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 player = (class_3222)playerEntity;
            boolean canFilter = ArcanaAugments.getAugmentOnItem(stack, ArcanaAugments.FARADAY_CAGE.id) >= 1;
            class_1799 offHand = playerEntity.method_5998(class_1268.field_5810);
            if (canFilter && hand == class_1268.field_5810 && playerEntity.method_5715()) {
                ArcanaItem.putProperty(stack, MagnetismCharm.FILTER_TAG, (class_2520)new class_2487());
                player.method_7353((class_2561)class_2561.method_43470((String)"Filter Cleared").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056}), true);
                SoundUtils.playSongToPlayer((class_3222)player, (class_3414)class_3417.field_14833, (float)0.5f, (float)1.0f);
            } else if (canFilter && hand == class_1268.field_5808 && !offHand.method_7960() && playerEntity.method_5715()) {
                MagnetismCharm.this.toggleFilterItem(player, stack, offHand.method_7909());
            } else if (playerEntity.method_5715()) {
                MagnetismCharm.this.toggleMode((class_3222)playerEntity, stack);
            } else {
                MagnetismCharm.this.activeUse((class_3222)playerEntity, world, stack);
            }
            return class_1269.field_52422;
        }
    }
}

