/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes.arcana;

import java.util.ArrayList;
import java.util.HashMap;
import net.borisshoes.arcananovum.ArcanaConfig;
import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.blocks.forge.StarlightForgeBlockEntity;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.recipes.arcana.ForgeRequirement;
import net.minecraft.class_1799;
import net.minecraft.class_3545;

public class ArcanaRecipe {
    private final ArcanaIngredient[][] trueIngredients;
    private final ForgeRequirement forgeRequirement;

    public ArcanaRecipe(ArcanaIngredient[][] ingredients) {
        this(ingredients, new ForgeRequirement());
    }

    public ArcanaRecipe(ArcanaIngredient[][] ingredients, ForgeRequirement forgeRequirement) {
        this.trueIngredients = ingredients;
        this.forgeRequirement = forgeRequirement;
    }

    public boolean satisfiesRecipe(class_1799[][] items, StarlightForgeBlockEntity forge) {
        ArcanaIngredient[][] ingredients = this.getAlteredIngredients();
        if (ingredients.length != items.length || ingredients[0].length != items[0].length) {
            return false;
        }
        for (int i = 0; i < ingredients.length; ++i) {
            for (int j = 0; j < ingredients[0].length; ++j) {
                if (ingredients[i][j].validStack(items[i][j])) continue;
                return false;
            }
        }
        return this.forgeRequirement.forgeMeetsRequirement(forge, false, null);
    }

    public class_1799[][] getRemainders(class_1799[][] items, StarlightForgeBlockEntity forge, int resourceLvl) {
        if (!this.satisfiesRecipe(items, forge)) {
            return null;
        }
        class_1799[][] remainders = new class_1799[items.length][items[0].length];
        ArcanaIngredient[][] ingredients = this.getAlteredIngredients();
        for (int i = 0; i < ingredients.length; ++i) {
            for (int j = 0; j < ingredients[0].length; ++j) {
                remainders[i][j] = ingredients[i][j].getRemainder(items[i][j], resourceLvl);
            }
        }
        return remainders;
    }

    public ArcanaIngredient[][] getIngredients() {
        return this.getAlteredIngredients();
    }

    public ForgeRequirement getForgeRequirement() {
        return this.forgeRequirement;
    }

    public HashMap<String, class_3545<Integer, class_1799>> getIngredientList() {
        HashMap<String, class_3545<Integer, class_1799>> map = new HashMap<String, class_3545<Integer, class_1799>>();
        ArcanaIngredient[][] ingredients = this.getAlteredIngredients();
        for (int i = 0; i < ingredients.length; ++i) {
            for (int j = 0; j < ingredients[0].length; ++j) {
                class_3545 pair;
                class_1799 stack = ingredients[i][j].ingredientAsStack();
                if (stack.method_7960()) continue;
                String ingred = ingredients[i][j].getName();
                if (map.containsKey(ingred)) {
                    int oldCount = (Integer)map.get(ingred).method_15442();
                    pair = new class_3545((Object)(ingredients[i][j].count + oldCount), (Object)stack);
                } else {
                    pair = new class_3545((Object)ingredients[i][j].count, (Object)stack);
                }
                map.put(ingred, (class_3545<Integer, class_1799>)pair);
            }
        }
        return map;
    }

    public ArrayList<ArcanaItem> getForgeRequirementList() {
        ArrayList<ArcanaItem> list = new ArrayList<ArcanaItem>();
        if (this.forgeRequirement.needsFletchery()) {
            list.add(ArcanaRegistry.RADIANT_FLETCHERY);
        }
        if (this.forgeRequirement.needsAnvil()) {
            list.add(ArcanaRegistry.TWILIGHT_ANVIL);
        }
        if (this.forgeRequirement.needsCore()) {
            list.add(ArcanaRegistry.STELLAR_CORE);
        }
        if (this.forgeRequirement.needsEnchanter()) {
            list.add(ArcanaRegistry.MIDNIGHT_ENCHANTER);
        }
        if (this.forgeRequirement.needsSingularity()) {
            list.add(ArcanaRegistry.ARCANE_SINGULARITY);
        }
        return list;
    }

    private ArcanaIngredient[][] getAlteredIngredients() {
        int reduction = ArcanaConfig.getInt(ArcanaRegistry.INGREDIENT_REDUCTION);
        ArcanaIngredient[][] alteredIngredients = new ArcanaIngredient[this.trueIngredients.length][this.trueIngredients[0].length];
        for (int i = 0; i < this.trueIngredients.length; ++i) {
            for (int j = 0; j < this.trueIngredients[0].length; ++j) {
                int newCount = (int)Math.ceil((double)this.trueIngredients[i][j].getCount() / (double)reduction);
                alteredIngredients[i][j] = this.trueIngredients[i][j].copyWithCount(newCount);
            }
        }
        return alteredIngredients;
    }
}

