/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes.arcana;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.borislib.utils.TextUtils;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class ExplainIngredient
extends ArcanaIngredient {
    private final String ingredientName;
    public final boolean show;
    private class_2561 displayName;
    private List<class_2561> lore;
    private final class_1799 displayOverride;

    public ExplainIngredient(class_1799 itemStack, int count, String ingredientName, boolean show) {
        super(itemStack.method_7909(), count);
        this.ingredientName = ingredientName;
        this.show = show;
        this.displayOverride = itemStack.method_7972();
    }

    public ExplainIngredient(class_1792 item, int count, String ingredientName) {
        super(item, count);
        this.ingredientName = ingredientName;
        this.show = true;
        this.displayOverride = null;
    }

    public ExplainIngredient(class_1792 item, int count, String ingredientName, boolean show) {
        super(item, count);
        this.ingredientName = ingredientName;
        this.show = show;
        this.displayOverride = null;
    }

    public ExplainIngredient withName(class_2561 name) {
        this.exampleStack.method_57379(class_9334.field_50239, (Object)name);
        if (this.displayOverride != null) {
            this.displayOverride.method_57379(class_9334.field_50239, (Object)name);
        }
        this.displayName = name;
        return this;
    }

    public ExplainIngredient withLore(List<class_2561> lore) {
        this.lore = lore.stream().map(TextUtils::removeItalics).collect(Collectors.toCollection(ArrayList::new));
        this.exampleStack.method_57379(class_9334.field_49632, (Object)new class_9290(this.lore));
        if (this.displayOverride != null) {
            this.displayOverride.method_57379(class_9334.field_49632, (Object)new class_9290(this.lore));
        }
        return this;
    }

    @Override
    public ArcanaIngredient copyWithCount(int newCount) {
        ExplainIngredient ingredient = this.displayOverride != null ? new ExplainIngredient(this.displayOverride, this.count, this.ingredientName, this.show) : new ExplainIngredient(this.itemType, this.count, this.ingredientName, this.show);
        if (this.displayName != null) {
            ingredient = ingredient.withName(this.displayName);
        }
        if (this.lore != null) {
            ingredient = ingredient.withLore(this.lore);
        }
        return ingredient;
    }

    @Override
    public boolean validStack(class_1799 stack) {
        return false;
    }

    @Override
    public boolean validStackIgnoreCount(class_1799 stack) {
        return false;
    }

    @Override
    public String getName() {
        return this.ingredientName;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ExplainIngredient)) {
            return false;
        }
        ExplainIngredient o = (ExplainIngredient)other;
        return this.exampleStack.equals(o.ingredientAsStack()) && this.ingredientName.equals(o.getName());
    }

    @Override
    public class_1799 ingredientAsStack() {
        if (this.displayOverride != null) {
            return this.displayOverride.method_7972();
        }
        return super.ingredientAsStack();
    }
}

