/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes.arcana;

import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.items.ShulkerCore;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.minecraft.class_1799;

public class ShulkerCoreIngredient
extends ArcanaIngredient {
    private final boolean needsStone;
    private final int minSouls;

    public ShulkerCoreIngredient(boolean needsStone, int minSouls) {
        super(ArcanaRegistry.SHULKER_CORE.getPrefItem().method_7909(), 1, true);
        this.needsStone = needsStone;
        this.minSouls = minSouls;
    }

    @Override
    public ArcanaIngredient copyWithCount(int newCount) {
        return new ShulkerCoreIngredient(this.needsStone, this.minSouls);
    }

    @Override
    public boolean validStack(class_1799 stack) {
        ArcanaItem arcanaItem = ArcanaItemUtils.identifyItem(stack);
        if (arcanaItem instanceof ShulkerCore) {
            ShulkerCore core = (ShulkerCore)arcanaItem;
            if (this.needsStone) {
                boolean hasStone = core.hasStone(stack);
                if (hasStone) {
                    return core.getEnergy(stack) >= this.minSouls;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean validStackIgnoreCount(class_1799 stack) {
        return this.validStack(stack);
    }

    @Override
    public String getName() {
        Object name = ArcanaRegistry.SHULKER_CORE.getNameString();
        if (this.needsStone) {
            name = (String)name + " (" + this.minSouls + "+ Souls)";
        }
        return name;
    }

    @Override
    public class_1799 ingredientAsStack() {
        return ArcanaRegistry.SHULKER_CORE.getPrefItem();
    }
}

