/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes.arcana;

import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.items.Soulstone;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class SoulstoneIngredient
extends ArcanaIngredient {
    private final int souls;
    private final String type;
    private final boolean consume;
    private final boolean repeatable;
    private final boolean ignoreEssenceEggTypes;

    public SoulstoneIngredient(int souls, boolean repeatable, boolean consume, boolean ignoreEssenceEggTypes, @Nullable String type) {
        super(ArcanaRegistry.SOULSTONE.getPrefItem().method_7909(), 1, true);
        this.souls = souls;
        this.repeatable = repeatable;
        this.consume = consume;
        this.ignoreEssenceEggTypes = ignoreEssenceEggTypes;
        this.type = type;
    }

    @Override
    public ArcanaIngredient copyWithCount(int newCount) {
        return new SoulstoneIngredient(this.souls, this.repeatable, this.consume, this.ignoreEssenceEggTypes, this.type);
    }

    @Override
    public boolean validStack(class_1799 stack) {
        if (ArcanaItemUtils.identifyItem(stack) instanceof Soulstone) {
            class_1299 eType;
            if (this.type != null && !this.type.equals(Soulstone.getType(stack))) {
                return false;
            }
            if (!this.ignoreEssenceEggTypes && (eType = (class_1299)class_1299.method_5898((String)Soulstone.getType(stack)).orElse(null)) != null && eType.method_20210(ArcanaRegistry.ESSENCE_EGG_DISALLOWED)) {
                return false;
            }
            return Soulstone.getSouls(stack) >= this.souls;
        }
        return false;
    }

    @Override
    public boolean validStackIgnoreCount(class_1799 stack) {
        return this.validStack(stack);
    }

    @Override
    public class_1799 getRemainder(class_1799 stack, int resourceLvl) {
        if (!this.validStack(stack)) {
            return class_1799.field_8037;
        }
        if (this.consume) {
            return class_1799.field_8037;
        }
        if (this.souls == 0) {
            return stack;
        }
        if (this.repeatable) {
            return Soulstone.setSouls(stack, Soulstone.getSouls(stack) % this.souls);
        }
        return Soulstone.setSouls(stack, Soulstone.getSouls(stack) - this.souls);
    }

    @Override
    public String getName() {
        Object name = ArcanaRegistry.SOULSTONE.getNameString();
        if (!this.consume) {
            name = (String)name + " (Not Consumed)";
        }
        if (this.type != null) {
            name = (String)name + " (" + this.souls + "+ " + ((class_1299)class_1299.method_5898((String)this.type).get()).method_5897().getString() + ")";
        }
        return name;
    }

    @Override
    public class_1799 ingredientAsStack() {
        return Soulstone.getShowcaseItem(this.souls, this.type);
    }
}

