/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.recipes.arcana;

import net.borisshoes.arcananovum.ArcanaRegistry;
import net.borisshoes.arcananovum.items.Waystone;
import net.borisshoes.arcananovum.recipes.arcana.ArcanaIngredient;
import net.borisshoes.arcananovum.utils.ArcanaUtils;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_5321;

public class WaystoneIngredient
extends ArcanaIngredient {
    private boolean consumed;
    private boolean requireUnattuned;
    private boolean requireAttuned;
    private class_5321<class_1937> worldKey;

    private WaystoneIngredient(int count, boolean consumed, boolean requireUnattuned, boolean requireAttuned, class_5321<class_1937> worldKey) {
        super(ArcanaRegistry.WAYSTONE.getPrefItem().method_7909(), count, true);
        this.requireAttuned = requireAttuned;
        this.requireUnattuned = requireUnattuned;
        this.worldKey = worldKey;
        this.consumed = consumed;
    }

    public WaystoneIngredient(boolean consumed) {
        super(ArcanaRegistry.WAYSTONE.getPrefItem().method_7909(), 1, true);
        this.consumed = consumed;
    }

    public WaystoneIngredient requireUnattuned() {
        this.requireUnattuned = true;
        this.requireAttuned = false;
        this.worldKey = null;
        return this;
    }

    public WaystoneIngredient requireAttuned() {
        this.requireUnattuned = false;
        this.requireAttuned = true;
        this.worldKey = null;
        return this;
    }

    public WaystoneIngredient requireAttuned(class_5321<class_1937> world) {
        this.requireUnattuned = false;
        this.requireAttuned = true;
        this.worldKey = world;
        return this;
    }

    @Override
    public boolean validStack(class_1799 stack) {
        if (!stack.method_31574(ArcanaRegistry.WAYSTONE.getItem())) {
            return false;
        }
        if (this.requireUnattuned) {
            return Waystone.isUnattuned(stack);
        }
        if (this.requireAttuned) {
            if (Waystone.isUnattuned(stack) || Waystone.getTarget(stack) == null) {
                return false;
            }
            if (this.worldKey != null && !Waystone.getTarget(stack).world().method_29177().equals((Object)this.worldKey.method_29177())) {
                return false;
            }
        }
        return true;
    }

    @Override
    public ArcanaIngredient copyWithCount(int newCount) {
        return new WaystoneIngredient(newCount, this.consumed, this.requireUnattuned, this.requireAttuned, this.worldKey);
    }

    @Override
    public boolean validStackIgnoreCount(class_1799 stack) {
        return this.validStack(stack);
    }

    @Override
    public class_1799 getRemainder(class_1799 stack, int resourceLvl) {
        if (!this.validStack(stack)) {
            return class_1799.field_8037;
        }
        if (this.consumed) {
            return class_1799.field_8037;
        }
        return stack;
    }

    @Override
    public String getName() {
        Object name = ArcanaRegistry.WAYSTONE.getNameString();
        if (!this.consumed) {
            name = (String)name + " (Not Consumed)";
        }
        if (this.worldKey != null) {
            name = (String)name + " Attuned [" + ArcanaUtils.getFormattedDimName(this.worldKey).getString() + "]";
        } else if (this.requireAttuned) {
            name = (String)name + " Attuned";
        } else if (this.requireUnattuned) {
            name = (String)name + " Unattuned";
        }
        return name;
    }

    @Override
    public class_1799 ingredientAsStack() {
        if (this.requireAttuned) {
            class_1799 waystone = ArcanaRegistry.WAYSTONE.getPrefItem().method_7972();
            Waystone.saveTarget(waystone, new Waystone.WaystoneTarget(this.worldKey != null ? this.worldKey : class_3218.field_25179, new class_243(0.0, 0.0, 0.0), 0.0f, 0.0f));
            return waystone;
        }
        return ArcanaRegistry.WAYSTONE.getPrefItem().method_7972();
    }
}

