/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.research;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.borisshoes.arcananovum.research.ResearchTasks;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

public abstract class ResearchTask {
    public final String id;
    public final Type type;
    private final class_2561 name;
    private final class_2561[] description;
    private final class_1799 displayItem;
    protected final class_5321<ResearchTask>[] prerequisites;

    protected ResearchTask(String id, Type type, class_2561 name, class_2561[] description, class_1799 displayItem, class_5321<ResearchTask> ... prerequisites) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.description = description;
        this.displayItem = displayItem;
        this.prerequisites = prerequisites;
    }

    protected ResearchTask(String id, Type type, class_2561 name, class_2561[] description, class_1799 displayItem) {
        this.id = id;
        this.type = type;
        this.name = name;
        this.description = description;
        this.displayItem = displayItem;
        this.prerequisites = new class_5321[0];
    }

    public String getTranslationKey() {
        return "research.arcananovum.name." + this.id;
    }

    public boolean satisfiedPreReqs(class_3222 player) {
        for (class_5321<ResearchTask> prerequisite : this.prerequisites) {
            Optional opt = ResearchTasks.RESEARCH_TASKS.method_31189(prerequisite);
            if (!opt.isPresent() || ((ResearchTask)opt.get()).isAcquired(player)) continue;
            return false;
        }
        return true;
    }

    public boolean satisfiedPrePreReqs(class_3222 player) {
        for (class_5321<ResearchTask> prerequisite : this.prerequisites) {
            Optional opt = ResearchTasks.RESEARCH_TASKS.method_31189(prerequisite);
            if (!opt.isPresent() || ((ResearchTask)opt.get()).satisfiedPreReqs(player)) continue;
            return false;
        }
        return true;
    }

    public List<ResearchTask> getPreReqs() {
        ArrayList<ResearchTask> prereqs = new ArrayList<ResearchTask>();
        for (class_5321<ResearchTask> prerequisite : this.prerequisites) {
            ResearchTasks.RESEARCH_TASKS.method_31189(prerequisite).ifPresent(prereqs::add);
        }
        return prereqs;
    }

    public abstract boolean isAcquired(class_3222 var1);

    public class_2561 getName() {
        return this.name.method_27661();
    }

    public String getId() {
        return this.id;
    }

    public class_2561[] getDescription() {
        class_2561[] copy = new class_2561[this.description.length];
        for (int i = 0; i < this.description.length; ++i) {
            copy[i] = this.description[i].method_27661();
        }
        return copy;
    }

    public class_1799 getDisplayItem() {
        return this.displayItem.method_7972();
    }

    public boolean equals(Object obj) {
        ResearchTask task;
        return obj instanceof ResearchTask && (task = (ResearchTask)obj).getId().equals(this.id);
    }

    public String toString() {
        return this.type.name() + " - " + this.id;
    }

    public static enum Type {
        STATISTIC,
        OBTAIN_ITEM,
        ADVANCEMENT,
        ARCANA_ITEM_UNLOCK,
        CUSTOM_EVENT;

    }
}

