/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.borisshoes.arcananovum.augments.ArcanaAugment;
import net.borisshoes.arcananovum.augments.ArcanaAugments;
import net.borisshoes.arcananovum.core.ArcanaItem;
import net.borisshoes.arcananovum.items.ArcanistsBelt;
import net.borisshoes.arcananovum.items.ShieldOfFortitude;
import net.borisshoes.arcananovum.utils.ArcanaItemUtils;
import net.minecraft.class_11343;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9288;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9636;

public class ArcanaUtils {
    public static final Codec<class_11343> BIG_STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("Slot").orElse((Object)0).forGetter(class_11343::comp_4211), (App)class_1799.field_55709.forGetter(class_11343::comp_4212)).apply((Applicative)instance, class_11343::new));

    public static void readBigInventory(class_11368 view, class_2371<class_1799> stacks) {
        for (class_11343 stackWithSlot : view.method_71437("Items", BIG_STACK_CODEC)) {
            if (!stackWithSlot.method_71368(stacks.size())) continue;
            stacks.set(stackWithSlot.comp_4211(), (Object)stackWithSlot.comp_4212());
        }
    }

    public static void writeBigInventory(class_11372 view, class_2371<class_1799> stacks, boolean setIfEmpty) {
        class_11372.class_11373 listAppender = view.method_71467("Items", BIG_STACK_CODEC);
        for (int i = 0; i < stacks.size(); ++i) {
            class_1799 itemStack = (class_1799)stacks.get(i);
            if (itemStack.method_7960()) continue;
            listAppender.method_71484((Object)new class_11343(i, itemStack));
        }
        if (listAppender.method_71483() && !setIfEmpty) {
            view.method_71478("Items");
        }
    }

    public static class_5250 getFormattedDimName(class_5321<class_1937> worldKey) {
        if (worldKey.method_29177().toString().equals(class_3218.field_25179.method_29177().toString())) {
            return class_2561.method_43470((String)"Overworld").method_27692(class_124.field_1060);
        }
        if (worldKey.method_29177().toString().equals(class_3218.field_25180.method_29177().toString())) {
            return class_2561.method_43470((String)"The Nether").method_27692(class_124.field_1061);
        }
        if (worldKey.method_29177().toString().equals(class_3218.field_25181.method_29177().toString())) {
            return class_2561.method_43470((String)"The End").method_27692(class_124.field_1064);
        }
        return class_2561.method_43470((String)worldKey.method_29177().toString()).method_27692(class_124.field_1054);
    }

    public static void blockWithShield(class_1309 entity, float damage) {
        class_1799 activeItem;
        ArcanaItem arcanaItem;
        if (entity.method_6039() && (arcanaItem = ArcanaItemUtils.identifyItem(activeItem = entity.method_6030())) instanceof ShieldOfFortitude) {
            ShieldOfFortitude shield = (ShieldOfFortitude)arcanaItem;
            shield.shieldBlock(entity, activeItem, damage);
        }
    }

    public static List<class_1799> getArcanaItems(class_1657 player, ArcanaItem arcanaItem) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 item = inv.method_5438(i);
            if (item.method_7960()) continue;
            ArcanaItem arcItem = ArcanaItemUtils.identifyItem(item);
            if (arcItem != null && arcItem.getId().equals(arcanaItem.getId())) {
                stacks.add(item);
            }
            if (!(arcItem instanceof ArcanistsBelt)) continue;
            class_9288 containerItems = (class_9288)item.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
            for (class_1799 stack : containerItems.method_59714()) {
                ArcanaItem aItem = ArcanaItemUtils.identifyItem(stack);
                if (aItem == null || !aItem.getId().equals(arcanaItem.getId())) continue;
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public static List<class_1799> getArcanaItemsWithAug(class_1657 player, ArcanaItem arcanaItem, ArcanaAugment augment, int level) {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 item = inv.method_5438(i);
            if (item.method_7960()) continue;
            ArcanaItem arcItem = ArcanaItemUtils.identifyItem(item);
            if (arcItem != null && arcItem.getId().equals(arcanaItem.getId()) && (augment == null || ArcanaAugments.getAugmentOnItem(item, augment) >= level)) {
                stacks.add(item);
            }
            if (!(arcItem instanceof ArcanistsBelt)) continue;
            class_9288 containerItems = (class_9288)item.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
            for (class_1799 stack : containerItems.method_59714()) {
                ArcanaItem aItem = ArcanaItemUtils.identifyItem(stack);
                if (aItem == null || !aItem.getId().equals(arcanaItem.getId()) || augment != null && ArcanaAugments.getAugmentOnItem(stack, augment) < level) continue;
                stacks.add(stack);
            }
        }
        return stacks;
    }

    public static List<class_3545<List<class_1799>, class_1799>> getAllItems(class_1657 player) {
        ArrayList<class_3545<List<class_1799>, class_1799>> allItems = new ArrayList<class_3545<List<class_1799>, class_1799>>();
        class_1661 playerInv = player.method_31548();
        ArrayList<class_1799> invItems = new ArrayList<class_1799>();
        for (int i = 0; i < playerInv.method_5439(); ++i) {
            class_1799 item = playerInv.method_5438(i);
            if (item.method_7960()) continue;
            invItems.add(item);
            ArcanaItem mitem = ArcanaItemUtils.identifyItem(item);
            if (!(mitem instanceof ArcanistsBelt)) continue;
            ArcanistsBelt belt = (ArcanistsBelt)mitem;
            class_9288 beltItems = (class_9288)item.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
            ArrayList beltList = new ArrayList();
            beltItems.method_59714().forEach(beltList::add);
            allItems.add((class_3545<List<class_1799>, class_1799>)new class_3545(beltList, (Object)item));
        }
        allItems.add(new class_3545(invItems, (Object)class_1799.field_8037));
        return allItems;
    }

    public static int calcEssenceFromEnchants(class_1799 itemStack) {
        class_9304 comp = class_1890.method_57532((class_1799)itemStack);
        int count = 0;
        for (class_6880 entry : comp.method_57534()) {
            int lvl = comp.method_57536(entry);
            count += (int)((double)ArcanaUtils.calcEssenceValue((class_6880<class_1887>)entry, lvl) / 2.0);
        }
        return count;
    }

    public static int calcEssenceValue(class_6880<class_1887> enchant, int lvl) {
        int essence = (int)(0.25 * (double)lvl * (double)((class_1887)enchant.comp_349()).method_20742(1));
        if (enchant.method_40220(class_9636.field_51551)) {
            essence = 0;
        } else if (enchant.method_40220(class_9636.field_51557)) {
            essence *= 2;
        }
        return essence;
    }
}

