/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.utils;

import java.util.ArrayList;
import java.util.List;
import net.borisshoes.arcananovum.utils.Dialog;
import net.borisshoes.borislib.BorisLib;
import net.borisshoes.borislib.timers.GenericTimer;
import net.borisshoes.borislib.timers.TickTimerCallback;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class DialogHelper {
    private final ArrayList<Dialog> dialogs;
    private boolean[] conditions;

    public DialogHelper() {
        this.dialogs = new ArrayList();
        this.conditions = new boolean[0];
    }

    public DialogHelper(ArrayList<Dialog> dialogs, boolean[] conditions) {
        this.dialogs = dialogs;
        this.conditions = conditions;
    }

    public void setConditions(boolean[] conditions) {
        this.conditions = conditions;
    }

    public void addDialog(Dialog dialog) {
        this.dialogs.add(dialog);
    }

    public Dialog getWeightedResult() {
        int i;
        ArrayList<Integer> pool = new ArrayList<Integer>();
        int[] weights = new int[this.dialogs.size()];
        for (i = 0; i < this.dialogs.size(); ++i) {
            weights[i] = this.dialogs.get(i).getWeight(this.conditions);
        }
        for (i = 0; i < weights.length; ++i) {
            if (weights[i] == -1) {
                return this.dialogs.get(i);
            }
            for (int j = 0; j < weights[i]; ++j) {
                pool.add(i);
            }
        }
        return this.dialogs.get((Integer)pool.get((int)(Math.random() * (double)pool.size())));
    }

    public void sendDialog(List<class_3222> players, Dialog dialog, boolean sounds) {
        int index = 0;
        int curDelay = 0;
        int[] delay = dialog.delay();
        for (class_5250 msg : dialog.message()) {
            if (index < delay.length) {
                curDelay += delay[index];
            }
            if (curDelay != 0) {
                int finalIndex = index;
                BorisLib.addTickTimerCallback((TickTimerCallback)new GenericTimer(curDelay, () -> {
                    for (class_3222 player : players) {
                        Dialog.DialogSound soundEvent;
                        player.method_7353((class_2561)msg, false);
                        if (!sounds || finalIndex >= dialog.sounds().size() || (soundEvent = dialog.sounds().get(finalIndex)) == null) continue;
                        soundEvent.playSound(player);
                    }
                }));
            } else {
                for (class_3222 player : players) {
                    Dialog.DialogSound soundEvent;
                    player.method_7353((class_2561)msg, false);
                    if (!sounds || index >= dialog.sounds().size() || (soundEvent = dialog.sounds().get(index)) == null) continue;
                    soundEvent.playSound(player);
                }
            }
            ++index;
        }
    }
}

