/*
 * Decompiled with CFR 0.152.
 */
package net.borisshoes.arcananovum.utils;

public class LevelUtils {
    public static int levelFromXp(int xp) {
        return (int)Math.min(100.0, Math.floor((-1000.0 + Math.sqrt(4000.0 * (double)xp + 9000000.0)) / 2000.0));
    }

    public static int levelToTotalXp(int lvl) {
        return 1000 * (lvl * lvl + lvl - 2);
    }

    public static int xpToNextLevel(int xp) {
        return LevelUtils.levelToTotalXp(LevelUtils.levelFromXp(xp) + 1) - xp;
    }

    public static int concFromLevel(int lvl, int resolve) {
        int conc = lvl < 1 ? 0 : (lvl <= 5 ? (int)Math.floor(8.0 * Math.sqrt(lvl - 1) + 5.0) : (lvl <= 50 ? (int)Math.floor(2 * lvl + 11) : (int)Math.floor(37.95 * Math.sqrt(lvl + 40) - 249.0)));
        return conc + 10 * resolve;
    }

    public static int getLevelSkillPoints(int level) {
        return level * 4;
    }

    public static String readableInt(int num) {
        return String.format("%,d", num);
    }

    public static int concFromXp(int xp, int resolve) {
        return LevelUtils.concFromLevel(LevelUtils.levelFromXp(xp), resolve);
    }

    public static int getCurLevelXp(int xp) {
        return xp - LevelUtils.levelToTotalXp(LevelUtils.levelFromXp(xp));
    }

    public static int nextLevelNewXp(int lvl) {
        return LevelUtils.levelToTotalXp(lvl + 1) - LevelUtils.levelToTotalXp(lvl);
    }

    public static int vanillaXpToLevel(int xp) {
        if (xp < 0) {
            return 0;
        }
        if (xp <= 352) {
            return (int)(Math.sqrt(xp + 9) - 3.0);
        }
        if (xp <= 1507) {
            return (int)(8.1 + Math.sqrt(0.4 * ((double)xp - 195.975)));
        }
        return (int)(18.055555555555557 + Math.sqrt(0.2222222222222222 * ((double)xp - 752.9861111111111)));
    }

    public static int vanillaLevelToTotalXp(int lvl) {
        if (lvl < 0) {
            return 0;
        }
        if (lvl <= 16) {
            return lvl * lvl + 6 * lvl;
        }
        if (lvl <= 31) {
            return (int)(2.5 * (double)(lvl * lvl) - 40.5 * (double)lvl + 360.0);
        }
        return (int)(4.5 * (double)(lvl * lvl) - 162.5 * (double)lvl + 2220.0);
    }

    public static String intToRoman(int num) {
        int[] values = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        String[] romanLetters = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        StringBuilder roman = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            while (num >= values[i]) {
                num -= values[i];
                roman.append(romanLetters[i]);
            }
        }
        return roman.toString();
    }
}

