/*
 * Decompiled with CFR 0.152.
 */
package dev.bvengo.mineprevention.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.bvengo.mineprevention.MinePreventionMod;
import dev.bvengo.mineprevention.config.Configs;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class ConfigParser {
    private static final File file = new File(FabricLoader.getInstance().getConfigDir().toFile(), "mineprevention.json");
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static Configs load() {
        Configs configs;
        if (!file.exists()) {
            MinePreventionMod.LOGGER.info("Config file not found. Creating a new one.");
            return ConfigParser.createNewConfig();
        }
        FileReader reader = new FileReader(file);
        try {
            configs = (Configs)gson.fromJson((Reader)reader, Configs.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                MinePreventionMod.LOGGER.error("Error reading config file, creating a new one. Original error: ", (Throwable)e);
                ConfigParser.moveOldConfig();
                return ConfigParser.createNewConfig();
            }
        }
        ((Reader)reader).close();
        return configs;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(file);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            MinePreventionMod.LOGGER.error("Unable to save sound config to file.", (Throwable)e);
        }
    }

    private static void moveOldConfig() {
        File oldFile = new File(file.getParentFile(), "old." + file.getName());
        if (file.renameTo(oldFile)) {
            MinePreventionMod.LOGGER.info("Renamed old config file to {}", (Object)oldFile.getName());
        } else {
            MinePreventionMod.LOGGER.error("Failed to rename old config file.");
        }
    }

    private static Configs createNewConfig() {
        Configs config = new Configs();
        config.save();
        return config;
    }
}

