/*
 * Decompiled with CFR 0.152.
 */
package dev.bvengo.mineprevention.ui;

import dev.bvengo.mineprevention.MinePreventionClientMod;
import dev.bvengo.mineprevention.ui.CenteredTextWidget;
import dev.bvengo.mineprevention.ui.ItemContainerWidget;
import dev.bvengo.mineprevention.ui.ItemWidget;
import dev.bvengo.mineprevention.ui.TriggerButtonWidget;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_7842;

@Environment(value=EnvType.CLIENT)
public class ConfigsScreen
extends class_437 {
    ArrayList<ItemWidget> allItems = new ArrayList();
    ItemContainerWidget allowedContainer;
    ItemContainerWidget deniedContainer;
    TriggerButtonWidget allowAllButton;
    TriggerButtonWidget denyAllButton;
    class_7842 titleWidget;
    class_342 searchField;

    public ConfigsScreen() {
        super((class_2561)class_2561.method_43471((String)"mineprevention.screen.options.title"));
    }

    protected void method_25426() {
        this.allItems = Stream.concat(MinePreventionClientMod.CONFIGS.allowList.stream().map(itemId -> new ItemWidget(this.field_22787, (String)itemId, true)), MinePreventionClientMod.CONFIGS.denyList.stream().map(itemId -> new ItemWidget(this.field_22787, (String)itemId, false))).sorted().collect(Collectors.toCollection(ArrayList::new));
        this.initTitle();
        this.initSearchField();
        this.initMoveButtons();
        this.initItemContainers();
        this.refreshItemLists(true);
    }

    private void initTitle() {
        this.titleWidget = new CenteredTextWidget(0, 12, this.field_22789, 12, this.method_25440(), this.field_22793);
        this.method_37060((class_4068)this.titleWidget);
    }

    private void initSearchField() {
        this.searchField = new class_342(this.field_22793, 4, this.titleWidget.method_55443() + 4, this.field_22789 - 16 - 40, 20, (class_2561)class_2561.method_43471((String)"mineprevention.screen.options.search"));
        this.searchField.method_1863(string -> this.refreshItemLists(true));
        this.searchField.method_1856(false);
        this.method_25429((class_364)this.searchField);
    }

    private void initMoveButtons() {
        this.allowAllButton = new TriggerButtonWidget("left", this.searchField.method_55442() + 4, this.searchField.method_46427(), 20, 20, button -> {
            this.allItems.forEach(item -> item.setAllowed(true));
            this.refreshItemLists(true);
        });
        this.method_25429((class_364)this.allowAllButton);
        this.denyAllButton = new TriggerButtonWidget("right", this.allowAllButton.method_55442() + 4, this.searchField.method_46427(), 20, 20, button -> {
            this.allItems.forEach(item -> item.setAllowed(false));
            this.refreshItemLists(true);
        });
        this.method_25429((class_364)this.denyAllButton);
    }

    private void initItemContainers() {
        int containerWidth = this.field_22789 / 2 - 8;
        int containerHeight = this.field_22790 - this.searchField.method_55443() - 4 - 4;
        this.allowedContainer = new ItemContainerWidget(this.field_22793, 4, this.searchField.method_55443() + 4, containerWidth, containerHeight, (class_2561)class_2561.method_43471((String)"mineprevention.screen.options.allowed"));
        this.method_25429((class_364)this.allowedContainer);
        this.deniedContainer = new ItemContainerWidget(this.field_22793, this.field_22789 - containerWidth - 4, this.allowedContainer.method_46427(), containerWidth, containerHeight, (class_2561)class_2561.method_43471((String)"mineprevention.screen.options.denied"));
        this.method_25429((class_364)this.deniedContainer);
    }

    private void refreshItemLists(boolean shouldResetScroll) {
        String searchQuery = this.searchField.method_1882().toLowerCase();
        ArrayList allowedItems = this.allItems.stream().filter(item -> item.isAllowed() && item.getItemStack().method_7964().getString().toLowerCase().contains(searchQuery)).collect(Collectors.toCollection(ArrayList::new));
        this.allowedContainer.setItems(allowedItems, shouldResetScroll);
        ArrayList deniedItems = this.allItems.stream().filter(item -> !item.isAllowed() && item.getItemStack().method_7964().getString().toLowerCase().contains(searchQuery)).collect(Collectors.toCollection(ArrayList::new));
        this.deniedContainer.setItems(deniedItems, shouldResetScroll);
    }

    private void save() {
        MinePreventionClientMod.CONFIGS.allowList = this.allItems.stream().filter(ItemWidget::isAllowed).map(ItemWidget::getItemId).collect(Collectors.toCollection(ArrayList::new));
        MinePreventionClientMod.CONFIGS.denyList = this.allItems.stream().filter(item -> !item.isAllowed()).map(ItemWidget::getItemId).collect(Collectors.toCollection(ArrayList::new));
        MinePreventionClientMod.CONFIGS.save();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.searchField.method_25394(context, mouseX, mouseY, delta);
        this.allowAllButton.method_25394(context, mouseX, mouseY, delta);
        this.denyAllButton.method_25394(context, mouseX, mouseY, delta);
        this.allowedContainer.method_25394(context, mouseX, mouseY, delta);
        this.deniedContainer.method_25394(context, mouseX, mouseY, delta);
        context.method_51742(this.field_22789 / 2, this.searchField.method_55443() + 4, this.field_22790 - 4, -6250336);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        boolean clicked = super.method_25402(click, doubled);
        class_364 focused = this.method_25399();
        if (focused != this.searchField) {
            this.searchField.method_25365(false);
            if (focused instanceof ItemContainerWidget) {
                this.refreshItemLists(false);
            }
        }
        return clicked;
    }

    public void method_25419() {
        this.save();
        super.method_25419();
    }
}

