/*
 * Decompiled with CFR 0.152.
 */
package dev.bvengo.mineprevention.ui;

import dev.bvengo.mineprevention.ui.CenteredTextWidget;
import dev.bvengo.mineprevention.ui.ItemWidget;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.class_9017;

@Environment(value=EnvType.CLIENT)
public class ItemContainerWidget
extends class_9017 {
    private static final class_2960 SCROLLER_TEXTURE = class_2960.method_60656((String)"widget/scroller");
    private static final class_2960 SCROLLER_BACKGROUND_TEXTURE = class_2960.method_60656((String)"widget/scroller_background");
    private List<ItemWidget> items;
    private final class_7842 titleWidget;
    private final int TOP_ROW_Y;
    private final int DISPLAY_WIDTH;
    private final int DISPLAY_HEIGHT;
    private final int CENTERING_OFFSET;

    public ItemContainerWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 title) {
        super(x, y, width, height, title);
        this.titleWidget = new CenteredTextWidget(x, y, width, 12, title, textRenderer);
        this.TOP_ROW_Y = this.titleWidget.method_55443() + 4;
        this.DISPLAY_WIDTH = width - 8 - 6;
        this.DISPLAY_HEIGHT = (height - this.titleWidget.method_25364() - 4) / 16 * 16;
        this.CENTERING_OFFSET = this.DISPLAY_WIDTH % 16 / 2;
    }

    public void setItems(List<ItemWidget> items, boolean refreshScroll) {
        this.items = items;
        if (refreshScroll) {
            this.method_44382(0.0);
        }
    }

    public List<ItemWidget> method_25396() {
        return this.items;
    }

    private int getItemsPerRow() {
        return this.DISPLAY_WIDTH / 16;
    }

    private int getNumVisibleRows() {
        return (this.method_25364() - this.titleWidget.method_25364() - 4) / 16;
    }

    protected int method_44395() {
        return (int)Math.ceil((float)this.items.size() * 16.0f / (float)this.getItemsPerRow());
    }

    protected double method_44393() {
        return 16.0;
    }

    protected int method_65507() {
        return this.method_55442() - 6 - 4;
    }

    public int method_44390() {
        return Math.max(0, this.method_44395() - this.DISPLAY_HEIGHT);
    }

    protected int method_44394() {
        return class_3532.method_15340((int)((int)((float)(this.DISPLAY_HEIGHT * this.DISPLAY_HEIGHT) / (float)this.method_44395())), (int)16, (int)this.DISPLAY_HEIGHT);
    }

    protected int method_65508() {
        return Math.max(this.TOP_ROW_Y, (int)this.method_44387() * (this.DISPLAY_HEIGHT - this.method_44394()) / this.method_44390() + this.TOP_ROW_Y);
    }

    protected void method_44396(class_332 context, int mouseX, int mouseY) {
        int x = this.method_65507();
        context.method_52706(class_10799.field_56883, SCROLLER_BACKGROUND_TEXTURE, x, this.TOP_ROW_Y, 6, this.DISPLAY_HEIGHT);
        if (this.method_44392()) {
            context.method_52706(class_10799.field_56883, SCROLLER_TEXTURE, x, this.method_65508(), 6, this.method_44394());
        } else {
            context.method_52706(class_10799.field_56883, SCROLLER_TEXTURE, x, this.TOP_ROW_Y, 6, this.DISPLAY_HEIGHT);
        }
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.titleWidget.method_25394(context, mouseX, mouseY, delta);
        this.method_44396(context, mouseX, mouseY);
        int row = (int)Math.ceil(this.method_44387() / 16.0);
        int start = row * this.getItemsPerRow();
        int end = Math.min(this.items.size(), start + this.getItemsPerRow() * this.getNumVisibleRows());
        for (int i = 0; i < end - start; ++i) {
            int x = this.method_46426() + 4 + this.CENTERING_OFFSET + i % this.getItemsPerRow() * 16;
            int y = this.TOP_ROW_Y + i / this.getItemsPerRow() * 16;
            ItemWidget item = this.items.get(start + i);
            item.method_48229(x, y);
            item.method_25394(context, mouseX, mouseY, delta);
        }
    }

    protected void method_47399(class_6382 builder) {
    }
}

