/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.runecraft.blocks;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.runecraft.utils.RuneHelper;
import xxrexraptorxx.runecraft.utils.SpellHelper;
import xxrexraptorxx.runecraft.utils.enums.ParticleShapeTypes;

public class BlockRune
extends FallingBlock {
    public static final MapCodec<BlockRune> CODEC = BlockRune.simpleCodec(BlockRune::new);
    protected static final VoxelShape CUSTOM_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public BlockRune(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean p_451772_) {
        if (!level.isClientSide() && entity instanceof LivingEntity) {
            LivingEntity entityIn = (LivingEntity)entity;
            entityIn.addEffect(new MobEffectInstance(MobEffects.GLOWING, 10));
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        SpellHelper.spawnParticleEffects(ParticleShapeTypes.BLOCK_EVENT, (ParticleOptions)ParticleTypes.ENCHANT, level, pos);
        if (!level.isClientSide()) {
            ItemEntity drop = new ItemEntity(level, (double)pos.getX(), (double)((float)pos.getY() + 0.8f), (double)pos.getZ(), new ItemStack((ItemLike)RuneHelper.getRuneFromType(BuiltInRegistries.BLOCK.getKey((Object)this).toString().substring(21))));
            level.addFreshEntity((Entity)drop);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CUSTOM_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return BlockRune.canSupportCenter((LevelReader)level, (BlockPos)pos.below(), (Direction)Direction.DOWN);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (level.getGameTime() % 10L == 0L) {
            SpellHelper.spawnParticleEffects(ParticleShapeTypes.BLOCK_AMBIENT, (ParticleOptions)ParticleTypes.CRIMSON_SPORE, level, pos.below());
            SpellHelper.spawnParticleEffects(ParticleShapeTypes.BLOCK_AMBIENT, (ParticleOptions)ParticleTypes.SMOKE, level, pos.below());
        }
    }

    public int getDustColor(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return this.defaultMapColor().calculateARGBColor(MapColor.Brightness.NORMAL);
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }
}

