/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.runecraft.utils;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import xxrexraptorxx.runecraft.utils.enums.ParticleShapeTypes;
import xxrexraptorxx.runecraft.utils.enums.SpellShapes;

public class SpellHelper {
    public static void spawnSpellEffect(SpellShapes shape, ParticleOptions particleType, int duration, float radius, @Nullable ArrayList<MobEffectInstance> effects, Level level, Position pos) {
        ArrayList<AreaEffectCloud> areaEffectClouds = new ArrayList<AreaEffectCloud>();
        if (!level.isClientSide()) {
            if (shape == SpellShapes.RING) {
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x() + 7.0, pos.y() + 0.5, pos.z()));
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x() - 7.0, pos.y() + 0.5, pos.z()));
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x(), pos.y() + 0.5, pos.z() + 7.0));
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x(), pos.y() + 0.5, pos.z() - 7.0));
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x() + 4.0, pos.y() + 0.5, pos.z() + 5.0));
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x() - 4.0, pos.y() + 0.5, pos.z() - 5.0));
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x() - 4.0, pos.y() + 0.5, pos.z() + 5.0));
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x() + 5.0, pos.y() + 0.5, pos.z() - 4.0));
            } else if (shape == SpellShapes.SINGLE) {
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x(), pos.y() + 0.5, pos.z()));
            } else if (shape == SpellShapes.STACKED) {
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x(), pos.y() + 0.5, pos.z()));
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x(), pos.y() + 1.0, pos.z()));
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x(), pos.y() + 1.5, pos.z()));
                areaEffectClouds.add(new AreaEffectCloud(level, pos.x(), pos.y() + 2.0, pos.z()));
            }
            for (AreaEffectCloud cloud : areaEffectClouds) {
                cloud.setDuration(duration);
                cloud.setRadius(radius);
                cloud.setCustomParticle(particleType);
                if (effects != null) {
                    for (MobEffectInstance effectInstance : effects) {
                        cloud.addEffect(effectInstance);
                    }
                }
                level.addFreshEntity((Entity)cloud);
            }
        }
    }

    public static void spawnSpellEffect(SpellShapes shape, ParticleOptions particleType, int duration, float radius, MobEffectInstance effect, Level level, Position pos) {
        ArrayList<MobEffectInstance> effectInstances = new ArrayList<MobEffectInstance>();
        effectInstances.add(effect);
        SpellHelper.spawnSpellEffect(shape, particleType, duration, radius, effectInstances, level, pos);
    }

    public static void addPlayerEffects(Entity entity, @Nullable MobEffectInstance effectInstance, float damageAmount) {
        Level level = entity.level();
        if (!level.isClientSide()) {
            if (entity instanceof Player) {
                Player entityIn = (Player)entity;
                if (effectInstance != null) {
                    entityIn.addEffect(effectInstance);
                }
                if (damageAmount < 0.0f) {
                    entityIn.hurt(level.damageSources().magic(), damageAmount);
                }
            } else if (entity instanceof LivingEntity) {
                LivingEntity entityIn = (LivingEntity)entity;
                if (effectInstance != null) {
                    entityIn.addEffect(effectInstance);
                }
                if (damageAmount < 0.0f) {
                    entityIn.hurt(level.damageSources().magic(), damageAmount);
                }
            }
        }
    }

    public static void spawnSpellEffect(SpellShapes shape, ParticleOptions particleType, int duration, float radius, Level level, Position pos) {
        SpellHelper.spawnSpellEffect(shape, particleType, duration, radius, (ArrayList<MobEffectInstance>)null, level, pos);
    }

    public static void spawnParticleEffects(ParticleShapeTypes type, ParticleOptions particleTypes, Level level, BlockPos pos) {
        block8: {
            double pz;
            double px;
            double theta;
            int i;
            int i2;
            block11: {
                block10: {
                    block9: {
                        block7: {
                            if (type != ParticleShapeTypes.ITEM_USED) break block7;
                            for (int i3 = 0; i3 < 2; ++i3) {
                                level.addParticle((ParticleOptions)ParticleTypes.LAVA, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.3f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                                level.addParticle(particleTypes, (double)((float)pos.getX() + 1.1f), (double)((float)pos.getY() + 1.3f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                                level.addParticle(particleTypes, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.3f), (double)((float)pos.getZ() - 0.1f), 0.0, 0.0, 0.0);
                                level.addParticle(particleTypes, (double)((float)pos.getX() - 0.1f), (double)((float)pos.getY() + 1.3f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
                                level.addParticle(particleTypes, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.3f), (double)((float)pos.getZ() + 1.1f), 0.0, 0.0, 0.0);
                            }
                            break block8;
                        }
                        if (type != ParticleShapeTypes.BLOCK_AMBIENT_LARGE) break block9;
                        double d0 = (double)pos.getX() + 0.5 + (double)(level.random.nextFloat() * 3.0f - 1.5f);
                        double d1 = (double)pos.getY() + 0.5 + (double)(level.random.nextFloat() * 1.5f);
                        double d2 = (double)pos.getZ() + 0.5 + (double)(level.random.nextFloat() * 3.0f - 1.5f);
                        level.addParticle(particleTypes, d0, d1, d2, 0.0, 0.0, 0.0);
                        break block8;
                    }
                    if (type != ParticleShapeTypes.BLOCK_AMBIENT) break block10;
                    double d0 = (float)pos.getX() + level.random.nextFloat();
                    double d1 = (float)pos.getY() + 1.1f;
                    double d2 = (float)pos.getZ() + level.random.nextFloat();
                    level.addParticle(particleTypes, d0, d1, d2, 0.0, 0.0, 0.0);
                    break block8;
                }
                if (type != ParticleShapeTypes.BLOCK_EVENT) break block11;
                double d0 = (float)pos.getX() + level.random.nextFloat();
                double d1 = (float)pos.getY() + 0.8f;
                double d2 = (float)pos.getZ() + level.random.nextFloat();
                level.addParticle(particleTypes, d0, d1, d2, 0.0, 0.0, 0.0);
                level.addParticle(particleTypes, d0 - (double)0.3f, d1, d2, 0.0, 0.0, 0.0);
                level.addParticle(particleTypes, d0, d1, d2 + (double)0.3f, 0.0, 0.0, 0.0);
                break block8;
            }
            if (type != ParticleShapeTypes.PENTERGRAM) break block8;
            double centerX = (double)pos.getX() + 0.5;
            double centerY = (double)pos.getY() + 0.5;
            double centerZ = (double)pos.getZ() + 0.5;
            double innerRadius = 2.5;
            double outerRadius = innerRadius + 0.5;
            int points = 5;
            int resolution = 80;
            double[] angles = new double[points];
            for (i2 = 0; i2 < points; ++i2) {
                angles[i2] = Math.toRadians(72 * i2 - 90);
            }
            for (i2 = 0; i2 < points; ++i2) {
                int nextIndex = (i2 + 2) % points;
                double x1 = centerX + Math.cos(angles[i2]) * innerRadius;
                double z1 = centerZ + Math.sin(angles[i2]) * innerRadius;
                double x2 = centerX + Math.cos(angles[nextIndex]) * innerRadius;
                double z2 = centerZ + Math.sin(angles[nextIndex]) * innerRadius;
                for (int j = 0; j < resolution; ++j) {
                    double t = (double)j / (double)resolution;
                    double px2 = x1 + (x2 - x1) * t;
                    double pz2 = z1 + (z2 - z1) * t;
                    level.addParticle(particleTypes, px2, centerY, pz2, 0.0, 0.0, 0.0);
                }
            }
            int circleResolution = 100;
            for (i = 0; i < circleResolution; ++i) {
                theta = Math.PI * 2 * (double)i / (double)circleResolution;
                px = centerX + Math.cos(theta) * innerRadius;
                pz = centerZ + Math.sin(theta) * innerRadius;
                level.addParticle(particleTypes, px, centerY, pz, 0.0, 0.0, 0.0);
            }
            for (i = 0; i < circleResolution; ++i) {
                theta = Math.PI * 2 * (double)i / (double)circleResolution;
                px = centerX + Math.cos(theta) * outerRadius;
                pz = centerZ + Math.sin(theta) * outerRadius;
                level.addParticle(particleTypes, px, centerY, pz, 0.0, 0.0, 0.0);
            }
            double fireRadius = innerRadius + 0.25;
            for (int i4 = 0; i4 < points; ++i4) {
                px = centerX + Math.cos(angles[i4]) * fireRadius;
                pz = centerZ + Math.sin(angles[i4]) * fireRadius;
                level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, px, centerY + 0.5, pz, 0.0, 0.0, 0.0);
            }
        }
    }
}

