/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.runecraft.world;

import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.TriState;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.BasicItemListing;
import net.neoforged.neoforge.event.AddPackFindersEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.village.WandererTradesEvent;
import xxrexraptorxx.magmacore.utils.FormattingHelper;
import xxrexraptorxx.runecraft.items.ItemPage;
import xxrexraptorxx.runecraft.main.RuneCraft;
import xxrexraptorxx.runecraft.registry.ModBlocks;
import xxrexraptorxx.runecraft.registry.ModItems;
import xxrexraptorxx.runecraft.utils.AltarHelper;
import xxrexraptorxx.runecraft.utils.Config;
import xxrexraptorxx.runecraft.utils.RuneHelper;
import xxrexraptorxx.runecraft.utils.SpellHelper;
import xxrexraptorxx.runecraft.utils.enums.ParticleShapeTypes;
import xxrexraptorxx.runecraft.utils.enums.SpellShapes;

@EventBusSubscriber(modid="runecraft")
public class Events {
    @SubscribeEvent
    private static void addFeaturePacks(AddPackFindersEvent event) {
        event.addPackFinders(ResourceLocation.fromNamespaceAndPath((String)"runecraft", (String)"packs/no_book_on_first_join"), PackType.SERVER_DATA, (Component)Component.literal((String)"Disable RuneCraft book upon entering the world!"), PackSource.FEATURE, false, Pack.Position.TOP);
    }

    @SubscribeEvent
    public static void changeRuneStoneType(PlayerInteractEvent.RightClickBlock event) {
        Item item = event.getItemStack().getItem();
        BlockPos pos = event.getPos();
        Level level = event.getLevel();
        Block block = level.getBlockState(pos).getBlock();
        if (!level.isClientSide() && BuiltInRegistries.BLOCK.getKey((Object)block).toString().contains("runecraft:rune_stone")) {
            level.playSound((Entity)((Player)null), pos, SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.8f);
            if (block != ModBlocks.RUNE_STONE.get() && Config.isActivateAreaEffectWhenRightClicked() && !BuiltInRegistries.ITEM.getKey((Object)item).toString().contains("runecraft:rune_") && block != ModBlocks.RUNE_STONE.get() && block != ModBlocks.RUNE_STONE_DMG.get() && block != ModBlocks.RUNE_STONE_FRE.get() && block != ModBlocks.RUNE_STONE_HRD.get() && block != ModBlocks.RUNE_STONE_PTL.get()) {
                SpellHelper.spawnSpellEffect(SpellShapes.SINGLE, (ParticleOptions)ParticleTypes.ENCHANT, Config.getAreaSpellDuration(), Config.getAreaSpellRadius(), new MobEffectInstance(RuneHelper.getEffect(BuiltInRegistries.BLOCK.getKey((Object)block).toString().substring(21)), Config.getSpellDuration(), Config.getSpellAmplifier()), level, (Position)pos.getCenter());
            }
            if (BuiltInRegistries.ITEM.getKey((Object)item).toString().contains("runecraft:rune_")) {
                if (block == ModBlocks.RUNE_STONE.get()) {
                    event.getItemStack().shrink(1);
                    level.setBlock(pos, RuneHelper.getRuneStoneFromType(BuiltInRegistries.ITEM.getKey((Object)item).toString().substring(15)).defaultBlockState(), 2);
                } else if (!BuiltInRegistries.BLOCK.getKey((Object)block).toString().substring(21).equals(BuiltInRegistries.ITEM.getKey((Object)item).toString().substring(15))) {
                    ItemEntity drop = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)RuneHelper.getRuneFromType(BuiltInRegistries.BLOCK.getKey((Object)block).toString().substring(21))));
                    level.addFreshEntity((Entity)drop);
                    event.getItemStack().shrink(1);
                    level.setBlock(pos, RuneHelper.getRuneStoneFromType(BuiltInRegistries.ITEM.getKey((Object)item).toString().substring(15)).defaultBlockState(), 2);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onInteractWithMagicalBook(PlayerInteractEvent.RightClickBlock event) {
        Item item = event.getItemStack().getItem();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        Random random = new Random();
        if (item == Items.BOOK) {
            if (level.getBlockState(pos).getBlock() == ModBlocks.ALTAR_BLOCK.get()) {
                if (player.experienceLevel >= ItemPage.getPageXpRequirement(item)) {
                    if (level.getMoonPhase() == 0) {
                        level.playSound((Entity)((Player)null), pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.8f);
                        SpellHelper.spawnParticleEffects(ParticleShapeTypes.ITEM_USED, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, level, pos);
                        SpellHelper.spawnParticleEffects(ParticleShapeTypes.PENTERGRAM, (ParticleOptions)ParticleTypes.ENCHANT, level, pos);
                        if (!level.isClientSide()) {
                            LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level, EntitySpawnReason.TRIGGERED);
                            lightningbolt.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                            lightningbolt.setVisualOnly(true);
                            level.addFreshEntity((Entity)lightningbolt);
                            event.getItemStack().shrink(1);
                            player.onEnchantmentPerformed(null, Config.getChargingCost());
                            ItemEntity reward = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + 0.5f), new ItemStack((ItemLike)ModItems.MAGICAL_BOOK.get()));
                            level.addFreshEntity((Entity)reward);
                            AltarHelper.spawnRandomGhosts(level, pos);
                            event.setUseBlock(TriState.FALSE);
                            event.setUseItem(TriState.FALSE);
                            event.setCanceled(true);
                        }
                    } else if (level.isClientSide()) {
                        player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"not_full_moon"), true);
                    }
                } else if (level.isClientSide()) {
                    player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"not_enough_levels"), true);
                }
            } else if (level.isClientSide()) {
                player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"wrong_block"), true);
            }
        }
    }

    @SubscribeEvent
    public static void onInteractWithPages(PlayerInteractEvent.RightClickBlock event) {
        Item item = event.getItemStack().getItem();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        if (item == ModItems.WAND_PAGE.get() || item == ModItems.ORB_PAGE.get() || item == ModItems.CURSE_PAGE.get() || item == ModItems.LOST_PAGE.get() || item == ModItems.SPELL_PAGE.get() || item == ModItems.ALCHEMY_PAGE.get() || item == ModItems.BANNED_PAGE.get() || item == ModItems.ENCHANTING_PAGE.get()) {
            if (level.getBlockState(pos).getBlock() == ModBlocks.ALTAR_BLOCK.get()) {
                if (player.experienceLevel >= ItemPage.getPageXpRequirement(item)) {
                    if (level.getSkyDarken() >= 5 || !level.dimensionType().hasSkyLight()) {
                        level.playSound((Entity)((Player)null), pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.8f);
                        SpellHelper.spawnParticleEffects(ParticleShapeTypes.ITEM_USED, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, level, pos);
                        SpellHelper.spawnParticleEffects(ParticleShapeTypes.PENTERGRAM, (ParticleOptions)ParticleTypes.ENCHANT, level, pos);
                        if (!level.isClientSide()) {
                            LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level, EntitySpawnReason.TRIGGERED);
                            lightningbolt.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                            lightningbolt.setVisualOnly(true);
                            level.addFreshEntity((Entity)lightningbolt);
                            event.getItemStack().shrink(1);
                            player.onEnchantmentPerformed(null, ItemPage.getPageXpRequirement(item));
                            if (item == ModItems.WAND_PAGE.get()) {
                                ItemEntity reward = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + 0.5f), new ItemStack((ItemLike)ModItems.BASIC_WAND.get()));
                                level.addFreshEntity((Entity)reward);
                            } else if (item == ModItems.ORB_PAGE.get()) {
                                ItemEntity reward = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + 0.5f), new ItemStack((ItemLike)ModItems.ORB.get(), 10));
                                level.addFreshEntity((Entity)reward);
                            } else if (item == ModItems.LOST_PAGE.get()) {
                                ItemEntity reward = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + 0.5f), AltarHelper.getRandomTreasure());
                                level.addFreshEntity((Entity)reward);
                            } else if (item == ModItems.CURSE_PAGE.get()) {
                                AltarHelper.getRandomCurse(level, pos);
                            } else if (item == ModItems.SPELL_PAGE.get()) {
                                AltarHelper.getRandomSpell(level, pos);
                            } else if (item == ModItems.BANNED_PAGE.get()) {
                                AltarHelper.getRandomBann(level, pos);
                            } else if (item == ModItems.ALCHEMY_PAGE.get()) {
                                ItemEntity reward = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + 0.5f), AltarHelper.getRandomPotion());
                                level.addFreshEntity((Entity)reward);
                            } else if (item == ModItems.ENCHANTING_PAGE.get()) {
                                ItemStack book = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                                book.set(DataComponents.CUSTOM_NAME, (Object)FormattingHelper.setModLangComponent((String)"item", (String)"runecraft", (String)"enchanting_book"));
                                ItemEntity reward = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + 0.5f), book);
                                level.addFreshEntity((Entity)reward);
                            }
                            AltarHelper.spawnRandomGhosts(level, pos);
                            event.setUseBlock(TriState.FALSE);
                            event.setUseItem(TriState.FALSE);
                            event.setCanceled(true);
                        }
                    } else if (level.isClientSide()) {
                        player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"not_night"), true);
                    }
                } else if (level.isClientSide()) {
                    player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"not_enough_levels"), true);
                }
            } else if (level.isClientSide()) {
                player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"wrong_block"), true);
            }
        }
    }

    @SubscribeEvent
    public static void onInteractWithWands(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        if (level.getBlockState(pos).getBlock() == ModBlocks.ALTAR_BLOCK.get() && BuiltInRegistries.ITEM.getKey((Object)item).toString().contains("runecraft") && BuiltInRegistries.ITEM.getKey((Object)item).toString().contains("_wand") && Config.getWandXPRepair() && stack.getDamageValue() > 0) {
            if (player.experienceLevel >= 1) {
                level.playSound((Entity)((Player)null), pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.0f);
                SpellHelper.spawnParticleEffects(ParticleShapeTypes.ITEM_USED, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, level, pos);
                SpellHelper.spawnParticleEffects(ParticleShapeTypes.PENTERGRAM, (ParticleOptions)ParticleTypes.ENCHANT, level, pos);
                player.onEnchantmentPerformed(null, 1);
                if (stack.getDamageValue() >= 50) {
                    stack.setDamageValue(stack.getDamageValue() - 50);
                } else {
                    stack.setDamageValue(0);
                }
            } else if (level.isClientSide()) {
                player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"not_enough_levels"), true);
            }
        }
    }

    @SubscribeEvent
    public static void onInteractWithPortableRuneStones(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        if (level.getBlockState(pos).getBlock() == ModBlocks.ALTAR_BLOCK.get() && BuiltInRegistries.ITEM.getKey((Object)item).toString().contains("runecraft") && BuiltInRegistries.ITEM.getKey((Object)item).toString().contains("portable_rune_stone") && Config.isPortableRuneStoneXpRepair() && stack.getDamageValue() > 0) {
            if (player.experienceLevel >= 1) {
                level.playSound((Entity)((Player)null), pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.8f);
                SpellHelper.spawnParticleEffects(ParticleShapeTypes.ITEM_USED, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, level, pos);
                SpellHelper.spawnParticleEffects(ParticleShapeTypes.PENTERGRAM, (ParticleOptions)ParticleTypes.ENCHANT, level, pos);
                player.onEnchantmentPerformed(null, 1);
                if (stack.getDamageValue() >= 50) {
                    stack.setDamageValue(stack.getDamageValue() - 50);
                } else {
                    stack.setDamageValue(0);
                }
            } else if (level.isClientSide()) {
                player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"not_enough_levels"), true);
            }
        }
    }

    @SubscribeEvent
    public static void onInteractWithSoul(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        if (stack.getItem() == ModItems.SOUL.get() && stack.has(DataComponents.CUSTOM_DATA)) {
            if (level.getBlockState(pos).getBlock() == ModBlocks.ALTAR_BLOCK.get()) {
                if (player.experienceLevel >= Config.getSoulCost()) {
                    if (level.getSkyDarken() >= 5 || !level.dimensionType().hasSkyLight()) {
                        level.playSound((Entity)((Player)null), pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.8f);
                        SpellHelper.spawnParticleEffects(ParticleShapeTypes.ITEM_USED, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, level, pos);
                        SpellHelper.spawnParticleEffects(ParticleShapeTypes.PENTERGRAM, (ParticleOptions)ParticleTypes.ENCHANT, level, pos);
                        if (!level.isClientSide()) {
                            LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level, EntitySpawnReason.TRIGGERED);
                            lightningbolt.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                            lightningbolt.setVisualOnly(true);
                            level.addFreshEntity((Entity)lightningbolt);
                            event.getItemStack().shrink(1);
                            player.onEnchantmentPerformed(null, Config.getSoulCost());
                            try {
                                ItemStack egg = new ItemStack((ItemLike)Objects.requireNonNull(SpawnEggItem.byId((EntityType)((EntityType)EntityType.byString((String)String.valueOf(Objects.requireNonNull((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getString("owner"))).get()))));
                                ItemEntity reward = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + 0.5f), egg);
                                level.addFreshEntity((Entity)reward);
                            }
                            catch (Exception e) {
                                ItemEntity reward = new ItemEntity(level, (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.1f), (double)((float)pos.getZ() + 0.5f), new ItemStack((ItemLike)Items.CHARCOAL));
                                level.addFreshEntity((Entity)reward);
                                RuneCraft.LOGGER.error((Object)e);
                                RuneCraft.LOGGER.error("Entity Type: " + String.valueOf(((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getString("owner")));
                            }
                            AltarHelper.spawnRandomGhosts(level, pos);
                            event.setUseBlock(TriState.FALSE);
                            event.setUseItem(TriState.FALSE);
                            event.setCanceled(true);
                        }
                    } else if (level.isClientSide()) {
                        player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"not_night"), true);
                    }
                } else if (level.isClientSide()) {
                    player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"not_enough_levels"), true);
                }
            } else if (level.isClientSide()) {
                player.displayClientMessage((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"wrong_block"), true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Entity attacker = event.getSource().getEntity();
        LivingEntity victim = event.getEntity();
        Level level = victim.level();
        Vec3 pos = victim.position();
        BlockPos blockPos = victim.getOnPos();
        if (attacker instanceof ServerPlayer && ((ServerPlayer)attacker).getMainHandItem().getItem().equals(ModItems.RITUAL_DAGGER.get())) {
            CompoundTag tag = new CompoundTag();
            ItemStack stack = new ItemStack((ItemLike)ModItems.SOUL.get());
            tag.putString("owner", victim.getType().toString().substring(7).replace(".", ":"));
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
            stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)victim.getDisplayName().getString()).append(" ").append((Component)FormattingHelper.setModLangComponent((String)"item", (String)"runecraft", (String)"soul")));
            ((Player)attacker).addItem(stack);
            level.playSound((Entity)((Player)null), blockPos, SoundEvents.ILLUSIONER_CAST_SPELL, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 1.0f);
            level.addParticle((ParticleOptions)ParticleTypes.SOUL, pos.x(), pos.y() + (double)0.3f, pos.z(), 0.0, 0.0, 0.0);
            SpellHelper.spawnParticleEffects(ParticleShapeTypes.PENTERGRAM, (ParticleOptions)ParticleTypes.ENCHANT, level, blockPos);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
    }

    @SubscribeEvent
    public static void addTrades(WandererTradesEvent event) {
        event.getGenericTrades().add(new BasicItemListing(5, new ItemStack((ItemLike)ModItems.SPIRIT_CRYSTAL.get(), 1), 3, 10));
    }

    @SubscribeEvent
    public static void addingToolTips(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Item item = stack.getItem();
        List list = event.getToolTip();
        if (BuiltInRegistries.ITEM.getKey((Object)item).getPath().contains("runecraft:rune_stone_")) {
            list.add(FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"rune_stone_desc").withStyle(ChatFormatting.GRAY));
        } else if (BuiltInRegistries.BLOCK.getKey((Object)((Block)ModBlocks.RUNE_SCRIBER_BLOCK.get())).getPath().equals(BuiltInRegistries.ITEM.getKey((Object)item).getPath())) {
            list.add(Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Work in progress...")));
        }
    }
}

