/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.runecraft.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.runecraft.registry.ModBlocks;
import xxrexraptorxx.runecraft.utils.Config;
import xxrexraptorxx.runecraft.utils.RuneHelper;
import xxrexraptorxx.runecraft.utils.SpellHelper;
import xxrexraptorxx.runecraft.utils.enums.ParticleShapeTypes;
import xxrexraptorxx.runecraft.utils.enums.SpellShapes;

public class BlockRuneStone
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected static final VoxelShape CUSTOM_COLLISION_AABB = Block.box((double)0.0625, (double)0.0625, (double)0.0625, (double)15.9375, (double)15.9375, (double)15.9375);

    public BlockRuneStone(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return CUSTOM_COLLISION_AABB;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        SpellHelper.spawnParticleEffects(ParticleShapeTypes.BLOCK_AMBIENT_LARGE, (ParticleOptions)ParticleTypes.ENCHANT, level, pos);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier) {
        if (!level.isClientSide && this != ModBlocks.RUNE_STONE.get() && BuiltInRegistries.BLOCK.getKey((Object)this).toString().length() == 22) {
            SpellHelper.addPlayerEffects(entity, new MobEffectInstance(RuneHelper.getEffect(String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)this).toString().charAt(21))), Config.getSpellDuration(), Config.getSpellAmplifier()), 0.0f);
        }
        if (!level.isClientSide && this != ModBlocks.RUNE_STONE.get() && BuiltInRegistries.BLOCK.getKey((Object)this).toString().length() == 24) {
            if (this == ModBlocks.RUNE_STONE_DMG.get()) {
                entity.hurt(level.damageSources().magic(), 4.0f);
            } else if (this == ModBlocks.RUNE_STONE_FRE.get()) {
                entity.setRemainingFireTicks(20);
            } else if (this == ModBlocks.RUNE_STONE_HRD.get()) {
                entity.hurt(level.damageSources().magic(), 2.0f);
            } else if (this == ModBlocks.RUNE_STONE_PTL.get()) {
                if (entity.isPassenger()) {
                    entity.stopRiding();
                }
                level.playSound((Entity)((Player)null), pos, SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.15f + 0.0f);
                if (entity.isCrouching()) {
                    entity.teleportTo((double)pos.getX(), (double)(pos.getY() - 10), (double)pos.getZ());
                } else {
                    entity.teleportTo((double)pos.getX(), (double)(pos.getY() + 10), (double)pos.getZ());
                }
            }
        }
    }

    public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
        SpellHelper.spawnParticleEffects(ParticleShapeTypes.BLOCK_EVENT, (ParticleOptions)ParticleTypes.ENCHANT, (Level)level, pos);
        if (!level.isClientSide) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 2);
            ItemEntity drop = new ItemEntity((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)ModBlocks.RUNE_STONE.get()));
            level.addFreshEntity((Entity)drop);
            if (this != ModBlocks.RUNE_STONE.get()) {
                ItemEntity extraDrop = new ItemEntity((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)RuneHelper.getRuneFromType(BuiltInRegistries.BLOCK.getKey((Object)this).toString().substring(21))));
                level.addFreshEntity((Entity)extraDrop);
            }
        }
    }

    public void playerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        SpellHelper.spawnParticleEffects(ParticleShapeTypes.BLOCK_EVENT, (ParticleOptions)ParticleTypes.ENCHANT, level, pos);
        if (!level.isClientSide) {
            ItemEntity drop = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)ModBlocks.RUNE_STONE.get()));
            level.addFreshEntity((Entity)drop);
            if (this != ModBlocks.RUNE_STONE.get()) {
                ItemEntity extraDrop = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), new ItemStack((ItemLike)RuneHelper.getRuneFromType(BuiltInRegistries.BLOCK.getKey((Object)this).toString().substring(21))));
                level.addFreshEntity((Entity)extraDrop);
            }
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        boolean flag;
        if (!level.isClientSide && Config.isActivateRedstoneEffect() && (flag = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != level.hasNeighborSignal(pos)) {
            if (flag) {
                level.scheduleTick(pos, (Block)this, 4);
            } else {
                level.playSound((Entity)((Player)null), pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.15f + 0.0f);
                if (this != ModBlocks.RUNE_STONE.get() && this != ModBlocks.RUNE_STONE_DMG.get() && this != ModBlocks.RUNE_STONE_FRE.get() && this != ModBlocks.RUNE_STONE_HRD.get() && this != ModBlocks.RUNE_STONE_PTL.get() && BuiltInRegistries.BLOCK.getKey((Object)this).toString().contains("rune_stone_")) {
                    level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
                    SpellHelper.spawnSpellEffect(SpellShapes.SINGLE, (ParticleOptions)ParticleTypes.ENCHANT, Config.getAreaSpellDuration(), (float)Config.getAreaSpellAmplifier(), new MobEffectInstance(RuneHelper.getEffect(BuiltInRegistries.BLOCK.getKey((Object)this).toString().substring(21)), Config.getSpellDuration(), Config.getSpellAmplifier()), level, (Position)pos.getCenter());
                }
            }
        }
    }

    public void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(context.getLevel().hasNeighborSignal(context.getClickedPos())));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }
}

