/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.runecraft.items;

import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import xxrexraptorxx.runecraft.utils.SpellHelper;
import xxrexraptorxx.runecraft.utils.enums.SpellShapes;

public class ItemMagicalBook
extends Item {
    public ItemMagicalBook(Item.Properties properties) {
        super(properties.rarity(Rarity.RARE).stacksTo(1).durability(15).fireResistant());
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainder(ItemStack stack) {
        if (stack.getMaxDamage() == stack.getDamageValue()) {
            return new ItemStack((ItemLike)Items.AIR);
        }
        ItemStack newItemStack = stack.copy();
        newItemStack.setDamageValue(stack.getDamageValue() + 1);
        return newItemStack;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        SpellHelper.spawnSpellEffect(SpellShapes.SINGLE, (ParticleOptions)ParticleTypes.ENCHANT, 10, 1.0f, level, (Position)player.position());
        return InteractionResult.SUCCESS;
    }
}

