/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.runecraft.items;

import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import xxrexraptorxx.magmacore.utils.FormattingHelper;
import xxrexraptorxx.runecraft.registry.ModBlocks;
import xxrexraptorxx.runecraft.registry.ModItems;
import xxrexraptorxx.runecraft.utils.Config;
import xxrexraptorxx.runecraft.utils.RuneHelper;
import xxrexraptorxx.runecraft.utils.SpellHelper;
import xxrexraptorxx.runecraft.utils.enums.SpellShapes;

public class ItemPortableRuneStone
extends Item {
    public ItemPortableRuneStone(Item.Properties properties) {
        super(properties.rarity(Rarity.EPIC).stacksTo(1).durability(200));
    }

    public boolean isFoil(ItemStack stack) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> list, TooltipFlag flag) {
        if (this != ModItems.PORTABLE_RUNE_STONE.get()) {
            list.accept((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + RuneHelper.getRuneName(BuiltInRegistries.ITEM.getKey((Object)this).toString().substring(30)))));
        }
        if (Config.getActivateRunestoneDescription() && this != ModItems.PORTABLE_RUNE_STONE.get()) {
            list.accept((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"contains").append((Component)Component.literal((String)(" " + BuiltInRegistries.MOB_EFFECT.getKey((Object)((MobEffect)RuneHelper.getEffect(BuiltInRegistries.ITEM.getKey((Object)this).toString().substring(30)).value())).toString().substring(10).replace("_", " ")))).withStyle(ChatFormatting.GRAY));
        }
        if (this == ModItems.PORTABLE_RUNE_STONE.get()) {
            list.accept((Component)FormattingHelper.setModLangComponent((String)"message", (String)"runecraft", (String)"empty").withStyle(ChatFormatting.GRAY));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        Random random = new Random();
        if (this != ModItems.PORTABLE_RUNE_STONE.get() && !level.getBlockState(context.getClickedPos()).getBlock().equals(ModBlocks.ALTAR_BLOCK.get())) {
            level.playSound((Entity)((Player)null), player.position().x(), player.position().y(), player.position().z(), SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            if (!level.isClientSide) {
                if (Config.isActivatePortableRuneStonePublicEffect()) {
                    SpellHelper.spawnSpellEffect(SpellShapes.SINGLE, (ParticleOptions)ParticleTypes.ENCHANT, 10, Config.getPortableSpellRadius(), new MobEffectInstance(RuneHelper.getEffect(BuiltInRegistries.ITEM.getKey((Object)this).toString().substring(30)), Config.getPortableSpellDuration(), Config.getPortableSpellAmplifier()), level, (Position)player.position());
                } else {
                    player.addEffect(new MobEffectInstance(RuneHelper.getEffect(BuiltInRegistries.ITEM.getKey((Object)this).toString().substring(30)), Config.getPortableSpellDuration(), Config.getPortableSpellAmplifier()));
                }
            }
            player.getCooldowns().addCooldown(stack, Config.getPortableSpellCooldown());
            stack.setDamageValue(stack.getDamageValue() + 1);
            if (level.isClientSide) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            if (stack.getDamageValue() == stack.getMaxDamage()) {
                level.playSound((Entity)((Player)null), player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
                stack.shrink(1);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

