/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.runecraft.items;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import xxrexraptorxx.runecraft.registry.ModBlocks;
import xxrexraptorxx.runecraft.registry.ModItems;
import xxrexraptorxx.runecraft.utils.AltarHelper;
import xxrexraptorxx.runecraft.utils.Config;
import xxrexraptorxx.runecraft.utils.SpellHelper;
import xxrexraptorxx.runecraft.utils.enums.SpellShapes;

public class ItemWand
extends Item {
    public ItemWand(Item.Properties properties) {
        super(properties.rarity(Rarity.EPIC).stacksTo(1).durability(200));
    }

    public InteractionResult useOn(UseOnContext event) {
        Level level = event.getLevel();
        Player player = event.getPlayer();
        Item item = event.getItemInHand().getItem();
        ItemStack stack = event.getItemInHand();
        Vec3 pos = event.getPlayer().position();
        BlockPos clickedPos = event.getClickedPos();
        Random random = new Random();
        if (!level.getBlockState(event.getClickedPos()).getBlock().equals(ModBlocks.ALTAR_BLOCK.get())) {
            ArrayList<MobEffectInstance> effectInstances = new ArrayList<MobEffectInstance>();
            level.playSound((Entity)((Player)null), pos.x(), pos.y(), pos.z(), SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            if (item != ModItems.CHANGING_WAND.get() || item != ModItems.DESTRUCTION_WAND.get()) {
                player.getCooldowns().addCooldown(stack, Config.getWandCooldown());
            }
            if (item == ModItems.BASIC_WAND.get()) {
                effectInstances.add(new MobEffectInstance(MobEffects.WEAKNESS, 150, 0));
                SpellHelper.spawnSpellEffect(SpellShapes.RING, (ParticleOptions)ParticleTypes.FIREWORK, 20, 3.0f, effectInstances, level, (Position)pos);
            } else if (item == ModItems.CURSE_WAND.get()) {
                effectInstances.add(new MobEffectInstance(MobEffects.UNLUCK, 1000, 0));
                effectInstances.add(new MobEffectInstance(MobEffects.INSTANT_DAMAGE, 10, 0));
                SpellHelper.spawnSpellEffect(SpellShapes.RING, (ParticleOptions)ParticleTypes.SMOKE, 20, 3.0f, effectInstances, level, (Position)pos);
                effectInstances.removeLast();
                event.getPlayer().hurt(level.damageSources().magic(), 2.0f);
                SpellHelper.spawnSpellEffect(SpellShapes.SINGLE, (ParticleOptions)ParticleTypes.LARGE_SMOKE, 20, 3.0f, effectInstances, level, (Position)pos);
            } else if (item == ModItems.HOLY_WAND.get()) {
                effectInstances.add(new MobEffectInstance(MobEffects.REGENERATION, 200, 1));
                SpellHelper.spawnSpellEffect(SpellShapes.SINGLE, (ParticleOptions)ParticleTypes.HEART, 10, 2.0f, effectInstances, level, (Position)pos);
            } else if (item == ModItems.NETHER_WAND.get()) {
                if (level.getBlockState(clickedPos.above()).isAir()) {
                    level.setBlock(clickedPos.above(), Blocks.FIRE.defaultBlockState(), 11);
                }
                if (level.getBlockState(clickedPos.offset(1, 1, 0)).isAir()) {
                    level.setBlock(clickedPos.offset(1, 1, 0), Blocks.FIRE.defaultBlockState(), 11);
                }
                if (level.getBlockState(clickedPos.offset(0, 1, 1)).isAir()) {
                    level.setBlock(clickedPos.offset(0, 1, 1), Blocks.FIRE.defaultBlockState(), 11);
                }
                if (level.getBlockState(clickedPos.offset(-1, 1, 0)).isAir()) {
                    level.setBlock(clickedPos.offset(-1, 1, 0), Blocks.FIRE.defaultBlockState(), 11);
                }
                if (level.getBlockState(clickedPos.offset(0, 1, -1)).isAir()) {
                    level.setBlock(clickedPos.offset(0, 1, -1), Blocks.FIRE.defaultBlockState(), 11);
                }
                SpellHelper.spawnSpellEffect(SpellShapes.SINGLE, (ParticleOptions)ParticleTypes.LAVA, 100, 1.0f, level, (Position)clickedPos.getCenter());
            } else if (item == ModItems.MAELSTROM_WAND.get()) {
                effectInstances.add(new MobEffectInstance(MobEffects.WITHER, 200, 1));
                SpellHelper.spawnSpellEffect(SpellShapes.RING, (ParticleOptions)ParticleTypes.SMOKE, 10, 3.0f, effectInstances, level, (Position)pos);
                SpellHelper.spawnSpellEffect(SpellShapes.SINGLE, (ParticleOptions)ParticleTypes.LAVA, 10, 4.0f, level, (Position)pos);
            } else if (item == ModItems.ESCAPE_WAND.get()) {
                SpellHelper.spawnSpellEffect(SpellShapes.STACKED, (ParticleOptions)ParticleTypes.LARGE_SMOKE, 500, 15.0f, level, (Position)pos);
                event.getPlayer().addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 1000));
                event.getPlayer().addEffect(new MobEffectInstance(MobEffects.SPEED, 1000, 1));
            } else if (item == ModItems.DESTRUCTION_WAND.get()) {
                if (player.isShiftKeyDown()) {
                    player.getCooldowns().addCooldown(stack, Config.getWandCooldown());
                }
                if (!level.isClientSide) {
                    if (event.getPlayer().isShiftKeyDown()) {
                        level.addFreshEntity((Entity)new PrimedTnt(level, (double)clickedPos.getX(), (double)clickedPos.getY(), (double)clickedPos.getZ(), (LivingEntity)event.getPlayer()));
                    } else {
                        level.destroyBlock(event.getClickedPos(), false);
                    }
                }
            } else if (item == ModItems.THUNDER_WAND.get()) {
                if (!level.isClientSide) {
                    if (player.isShiftKeyDown()) {
                        level.getLevelData().setRaining(true);
                        level.setThunderLevel(1.0f);
                    } else {
                        level.getLevelData().setRaining(false);
                    }
                }
            } else if (item == ModItems.DEFENSIVE_WAND.get()) {
                BlockPos blockPos = event.getPlayer().blockPosition();
                player.addEffect(new MobEffectInstance(MobEffects.RESISTANCE, 300, 0));
                if (player.isShiftKeyDown()) {
                    if (level.getBlockState(blockPos.offset(0, -1, 0)) == Blocks.COBBLESTONE.defaultBlockState()) {
                        level.destroyBlock(blockPos.offset(0, -1, 0), false);
                    }
                    if (level.getBlockState(blockPos.offset(0, 2, 0)) == Blocks.COBBLESTONE.defaultBlockState()) {
                        level.destroyBlock(blockPos.offset(0, 2, 0), false);
                    }
                    if (level.getBlockState(blockPos.offset(1, 0, 0)) == Blocks.COBBLESTONE.defaultBlockState()) {
                        level.destroyBlock(blockPos.offset(1, 0, 0), false);
                    }
                    if (level.getBlockState(blockPos.offset(-1, 0, 0)) == Blocks.COBBLESTONE.defaultBlockState()) {
                        level.destroyBlock(blockPos.offset(-1, 0, 0), false);
                    }
                    if (level.getBlockState(blockPos.offset(0, 0, 1)) == Blocks.COBBLESTONE.defaultBlockState()) {
                        level.destroyBlock(blockPos.offset(0, 0, 1), false);
                    }
                    if (level.getBlockState(blockPos.offset(0, 0, -1)) == Blocks.COBBLESTONE.defaultBlockState()) {
                        level.destroyBlock(blockPos.offset(0, 0, -1), false);
                    }
                    if (level.getBlockState(blockPos.offset(1, 1, 0)) == Blocks.COBBLESTONE.defaultBlockState()) {
                        level.destroyBlock(blockPos.offset(1, 1, 0), false);
                    }
                    if (level.getBlockState(blockPos.offset(-1, 1, 0)) == Blocks.COBBLESTONE.defaultBlockState()) {
                        level.destroyBlock(blockPos.offset(-1, 1, 0), false);
                    }
                    if (level.getBlockState(blockPos.offset(0, 1, 1)) == Blocks.COBBLESTONE.defaultBlockState()) {
                        level.destroyBlock(blockPos.offset(0, 1, 1), false);
                    }
                    if (level.getBlockState(blockPos.offset(0, 1, -1)) == Blocks.COBBLESTONE.defaultBlockState()) {
                        level.destroyBlock(blockPos.offset(0, 1, -1), false);
                    }
                } else {
                    if (level.getBlockState(blockPos.offset(0, -1, 0)).isAir() || level.getBlockState(blockPos.offset(0, -1, 0)).is(BlockTags.REPLACEABLE) || level.getBlockState(blockPos.offset(0, -1, 0)).is(Blocks.SNOW)) {
                        level.setBlock(blockPos.offset(0, -1, 0), Blocks.COBBLESTONE.defaultBlockState(), 11);
                    }
                    if (level.getBlockState(blockPos.offset(0, 2, 0)).isAir() || level.getBlockState(blockPos.offset(0, 2, 0)).is(BlockTags.REPLACEABLE) || level.getBlockState(blockPos.offset(0, 2, 0)).is(Blocks.SNOW)) {
                        level.setBlock(blockPos.offset(0, 2, 0), Blocks.COBBLESTONE.defaultBlockState(), 11);
                    }
                    if (level.getBlockState(blockPos.offset(1, 0, 0)).isAir() || level.getBlockState(blockPos.offset(1, 0, 0)).is(BlockTags.REPLACEABLE) || level.getBlockState(blockPos.offset(1, 0, 0)).is(Blocks.SNOW)) {
                        level.setBlock(blockPos.offset(1, 0, 0), Blocks.COBBLESTONE.defaultBlockState(), 11);
                    }
                    if (level.getBlockState(blockPos.offset(-1, 0, 0)).isAir() || level.getBlockState(blockPos.offset(-1, 0, 0)).is(BlockTags.REPLACEABLE) || level.getBlockState(blockPos.offset(-1, 0, 0)).is(Blocks.SNOW)) {
                        level.setBlock(blockPos.offset(-1, 0, 0), Blocks.COBBLESTONE.defaultBlockState(), 11);
                    }
                    if (level.getBlockState(blockPos.offset(0, 0, 1)).isAir() || level.getBlockState(blockPos.offset(0, 0, 1)).is(BlockTags.REPLACEABLE) || level.getBlockState(blockPos.offset(0, 0, 1)).is(Blocks.SNOW)) {
                        level.setBlock(blockPos.offset(0, 0, 1), Blocks.COBBLESTONE.defaultBlockState(), 11);
                    }
                    if (level.getBlockState(blockPos.offset(0, 0, -1)).isAir() || level.getBlockState(blockPos.offset(0, 0, -1)).is(BlockTags.REPLACEABLE) || level.getBlockState(blockPos.offset(0, 0, -1)).is(Blocks.SNOW)) {
                        level.setBlock(blockPos.offset(0, 0, -1), Blocks.COBBLESTONE.defaultBlockState(), 11);
                    }
                    if (level.getBlockState(blockPos.offset(1, 1, 0)).isAir() || level.getBlockState(blockPos.offset(1, 1, 0)).is(BlockTags.REPLACEABLE) || level.getBlockState(blockPos.offset(1, 1, 0)).is(Blocks.SNOW)) {
                        level.setBlock(blockPos.offset(1, 1, 0), Blocks.COBBLESTONE.defaultBlockState(), 11);
                    }
                    if (level.getBlockState(blockPos.offset(-1, 1, 0)).isAir() || level.getBlockState(blockPos.offset(-1, 1, 0)).is(BlockTags.REPLACEABLE) || level.getBlockState(blockPos.offset(-1, 1, 0)).is(Blocks.SNOW)) {
                        level.setBlock(blockPos.offset(-1, 1, 0), Blocks.COBBLESTONE.defaultBlockState(), 11);
                    }
                    if (level.getBlockState(blockPos.offset(0, 1, 1)).isAir() || level.getBlockState(blockPos.offset(0, 1, 1)).is(BlockTags.REPLACEABLE) || level.getBlockState(blockPos.offset(0, 1, 1)).is(Blocks.SNOW)) {
                        level.setBlock(blockPos.offset(0, 1, 1), Blocks.COBBLESTONE.defaultBlockState(), 11);
                    }
                    if (level.getBlockState(blockPos.offset(0, 1, -1)).isAir() || level.getBlockState(blockPos.offset(0, 1, -1)).is(BlockTags.REPLACEABLE) || level.getBlockState(blockPos.offset(0, 1, -1)).is(Blocks.SNOW)) {
                        level.setBlock(blockPos.offset(0, 1, -1), Blocks.COBBLESTONE.defaultBlockState(), 11);
                    }
                }
            } else if (item == ModItems.CHANGING_WAND.get()) {
                if (!level.isClientSide && !this.handleInteraction(player, level.getBlockState(clickedPos), (LevelAccessor)level, clickedPos, true, event.getItemInHand())) {
                    return InteractionResult.FAIL;
                }
            } else if (item == ModItems.CREATURE_WAND.get()) {
                AltarHelper.getRandomWeakMob(level, clickedPos);
                AltarHelper.getRandomWeakMob(level, clickedPos);
                AltarHelper.getRandomWeakMob(level, clickedPos);
            }
            stack.setDamageValue(stack.getDamageValue() + 1);
            if (stack.getDamageValue() == stack.getMaxDamage()) {
                level.playSound((Entity)((Player)null), event.getPlayer().getX(), event.getPlayer().getY(), event.getPlayer().getZ(), (Holder)SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
                stack.shrink(1);
            }
        }
        if (level.isClientSide) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return InteractionResult.SUCCESS;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        Item item = stack.getItem();
        Level level = player.level();
        Random random = new Random();
        level.playSound((Entity)((Player)null), player.position().x, player.position().y, player.position().z, SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
        if (item == ModItems.AETHER_WAND.get()) {
            SpellHelper.addPlayerEffects(entity, new MobEffectInstance(MobEffects.LEVITATION, 100, 1), 1.0f);
        } else if (item == ModItems.CURSE_WAND.get()) {
            SpellHelper.addPlayerEffects(entity, new MobEffectInstance(MobEffects.UNLUCK, 10000, 0), 2.0f);
            SpellHelper.addPlayerEffects(entity, new MobEffectInstance(MobEffects.WITHER, 100, 0), 2.0f);
            player.hurt(level.damageSources().magic(), 2.0f);
        } else if (item == ModItems.HOLY_WAND.get()) {
            SpellHelper.addPlayerEffects(entity, new MobEffectInstance(MobEffects.REGENERATION, 100, 0), 0.0f);
        } else if (item == ModItems.STORM_WAND.get()) {
            SpellHelper.spawnSpellEffect(SpellShapes.SINGLE, (ParticleOptions)ParticleTypes.SMOKE, 20, 3.0f, level, (Position)player.position());
            SpellHelper.spawnSpellEffect(SpellShapes.SINGLE, (ParticleOptions)ParticleTypes.SMOKE, 20, 3.0f, level, (Position)player.position());
        } else if (item == ModItems.NETHER_WAND.get()) {
            entity.setRemainingFireTicks(10);
        } else if (item == ModItems.MAELSTROM_WAND.get()) {
            SpellHelper.addPlayerEffects(entity, new MobEffectInstance(MobEffects.WITHER, 200, 0), 1.0f);
        } else if (item == ModItems.THUNDER_WAND.get() && !level.isClientSide) {
            LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level, EntitySpawnReason.TRIGGERED);
            lightningbolt.setDeltaMovement(entity.getX(), entity.getY(), entity.getZ());
            level.addFreshEntity((Entity)lightningbolt);
        }
        if (item != ModItems.STORM_WAND.get()) {
            player.getCooldowns().addCooldown(stack, 150);
        }
        if (level.isClientSide) {
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        stack.setDamageValue(stack.getDamageValue() + 1);
        if (stack.getDamageValue() == stack.getMaxDamage()) {
            level.playSound((Entity)((Player)null), player.position().x, player.position().y, player.position().z, (Holder)SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            stack.shrink(1);
        }
        return false;
    }

    public void inventoryTick(ItemStack stack, ServerLevel level, Entity entity, @Nullable EquipmentSlot slot) {
        if (stack.getItem() == ModItems.STORM_WAND.get() && !stack.isEnchanted()) {
            Registry enchantmentsRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            stack.enchant((Holder)enchantmentsRegistry.getOrThrow(Enchantments.KNOCKBACK), 5);
            stack.set(DataComponents.ENCHANTMENTS, (Object)((ItemEnchantments)stack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY)));
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Random random = new Random();
        Player player = (Player)entity;
        Level level = entity.level();
        if (stack.getItem() == ModItems.AETHER_WAND.get()) {
            level.playSound((Entity)((Player)null), entity.position().x, entity.position().y, entity.position().z, SoundEvents.PHANTOM_FLAP, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
            entity.setDeltaMovement(entity.getDeltaMovement().x, 0.5, entity.getDeltaMovement().z);
            entity.fallDistance = 0.0;
            level.addParticle((ParticleOptions)ParticleTypes.SWEEP_ATTACK, entity.position().x, entity.position().y + 1.0, entity.position().z, 0.0, 0.0, 0.0);
            if (level.isClientSide) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                stack.setDamageValue(stack.getDamageValue() + 1);
            }
            if (stack.getDamageValue() == stack.getMaxDamage()) {
                level.playSound((Entity)((Player)null), player.position().x, player.position().y, player.position().z, (Holder)SoundEvents.ITEM_BREAK, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
                stack.shrink(1);
            }
        }
        return true;
    }

    private boolean handleInteraction(Player player, BlockState state, LevelAccessor level, BlockPos pos, boolean p_150807_, ItemStack stack) {
        if (!player.canUseGameMasterBlocks()) {
            return false;
        }
        Holder holder = state.getBlockHolder();
        StateDefinition statedefinition = ((Block)holder.value()).getStateDefinition();
        Collection collection = statedefinition.getProperties();
        if (collection.isEmpty()) {
            ItemWand.message(player, (Component)Component.translatable((String)(this.getDescriptionId() + ".empty"), (Object[])new Object[]{holder.getRegisteredName()}));
            return false;
        }
        DebugStickState debugstickstate = (DebugStickState)stack.get(DataComponents.DEBUG_STICK_STATE);
        if (debugstickstate == null) {
            return false;
        }
        Property property = (Property)debugstickstate.properties().get(holder);
        if (p_150807_) {
            if (property == null) {
                property = (Property)collection.iterator().next();
            }
            BlockState blockstate = ItemWand.cycleState(state, property, player.isSecondaryUseActive());
            level.setBlock(pos, blockstate, 18);
            if (player.level().isClientSide) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            ItemWand.message(player, (Component)Component.translatable((String)(this.getDescriptionId() + ".update"), (Object[])new Object[]{property.getName(), ItemWand.getNameHelper(blockstate, property)}));
        } else {
            property = ItemWand.getRelative(collection, property, player.isSecondaryUseActive());
            stack.set(DataComponents.DEBUG_STICK_STATE, (Object)debugstickstate.withProperty(holder, property));
            ItemWand.message(player, (Component)Component.translatable((String)(this.getDescriptionId() + ".select"), (Object[])new Object[]{property.getName(), ItemWand.getNameHelper(state, property)}));
        }
        return true;
    }

    private static void message(Player player, Component component) {
        ((ServerPlayer)player).sendSystemMessage(component, true);
    }

    private static <T extends Comparable<T>> BlockState cycleState(BlockState state, Property<T> property, boolean backwards) {
        return (BlockState)state.setValue(property, ItemWand.getRelative(property.getPossibleValues(), state.getValue(property), backwards));
    }

    private static <T> T getRelative(Iterable<T> allowedValues, @Nullable T currentValue, boolean backwards) {
        return (T)(backwards ? Util.findPreviousInIterable(allowedValues, currentValue) : Util.findNextInIterable(allowedValues, currentValue));
    }

    private static <T extends Comparable<T>> String getNameHelper(BlockState state, Property<T> property) {
        return property.getName(state.getValue(property));
    }
}

