/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.runecraft.world;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;

public class ChestLootEnhancerModifier
extends LootModifier {
    public static final Supplier<MapCodec<ChestLootEnhancerModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.mapCodec(inst -> ChestLootEnhancerModifier.codecStart((RecordCodecBuilder.Instance)inst).and((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(m -> m.item)).and((App)Codec.INT.optionalFieldOf("count", (Object)-1).forGetter(m -> m.count)).and((App)Codec.INT.optionalFieldOf("min_count", (Object)-1).forGetter(m -> m.minCount)).and((App)Codec.INT.optionalFieldOf("max_count", (Object)-1).forGetter(m -> m.maxCount)).and((App)LootItemFunctions.CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(m -> m.functions)).apply((Applicative)inst, ChestLootEnhancerModifier::new)));
    private final Item item;
    private final int count;
    private final int minCount;
    private final int maxCount;
    private final List<Holder<LootItemFunction>> functions;

    public ChestLootEnhancerModifier(LootItemCondition[] conditionsIn, Item item, int count, int minCount, int maxCount, List<Holder<LootItemFunction>> functions) {
        super(conditionsIn);
        this.item = item;
        this.count = count;
        this.minCount = minCount;
        this.maxCount = maxCount;
        this.functions = functions;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        RandomSource random = context.getRandom();
        int itemCount = this.count >= 0 ? this.count : (this.minCount >= 0 && this.maxCount >= 0 ? random.nextIntBetweenInclusive(this.minCount, this.maxCount) : 1);
        ItemStack itemToAdd = new ItemStack((ItemLike)this.item, itemCount);
        for (Holder<LootItemFunction> functionHolder : this.functions) {
            LootItemFunction function = (LootItemFunction)functionHolder.value();
            itemToAdd = (ItemStack)function.apply((Object)itemToAdd, (Object)context);
        }
        generatedLoot.add((Object)itemToAdd);
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

