/*
 * Decompiled with CFR 0.152.
 */
package com.lpcneoforge.lpcmod.server;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;

public final class ChatUtils {
    public static MutableComponent applyColorToLiteral(String text, String colorCode) {
        MutableComponent component = ChatUtils.parseFormattedText(text);
        if (colorCode.startsWith("&") && colorCode.length() > 1) {
            char code = colorCode.charAt(1);
            ChatFormatting chatFormatting = ChatUtils.getChatFormattingByCode(code);
            if (chatFormatting != null) {
                return Component.literal((String)text).withStyle(Style.EMPTY.withColor(chatFormatting.getColor().intValue()));
            }
        } else if (colorCode.startsWith("#") && colorCode.length() == 7) {
            try {
                int rgb = Integer.parseInt(colorCode.substring(1), 16);
                TextColor color = TextColor.fromRgb((int)rgb);
                return Component.literal((String)text).withStyle(Style.EMPTY.withColor(color));
            }
            catch (NumberFormatException e) {
                return component;
            }
        }
        return component;
    }

    public static MutableComponent parseFormattedText(String text) {
        MutableComponent component = Component.literal((String)"");
        StringBuilder buffer = new StringBuilder();
        Style currentStyle = Style.EMPTY.withColor(ChatFormatting.WHITE);
        for (int i = 0; i < text.length(); ++i) {
            char formatCode;
            ChatFormatting formatting;
            char c = text.charAt(i);
            if (c == '#' && i + 6 < text.length()) {
                String hexCode = text.substring(i, i + 7);
                try {
                    int rgb = Integer.parseInt(hexCode.substring(1), 16);
                    if (!buffer.isEmpty()) {
                        component.append((Component)Component.literal((String)buffer.toString()).withStyle(currentStyle));
                        buffer.setLength(0);
                    }
                    currentStyle = currentStyle.withColor(TextColor.fromRgb((int)rgb));
                    i += 6;
                    continue;
                }
                catch (NumberFormatException rgb) {
                    // empty catch block
                }
            }
            if ((c == '&' || c == '\u00a7') && i + 1 < text.length() && (formatting = ChatUtils.getChatFormattingByCode(formatCode = text.charAt(i + 1))) != null) {
                if (!buffer.isEmpty()) {
                    component.append((Component)Component.literal((String)buffer.toString()).withStyle(currentStyle));
                    buffer.setLength(0);
                }
                currentStyle = formatting == ChatFormatting.RESET ? Style.EMPTY : (formatting.isColor() ? currentStyle.withColor(formatting.getColor().intValue()) : currentStyle.applyFormat(formatting));
                ++i;
                continue;
            }
            buffer.append(c);
        }
        if (!buffer.isEmpty()) {
            component.append((Component)Component.literal((String)buffer.toString()).withStyle(currentStyle));
        }
        return component;
    }

    public static ChatFormatting getChatFormattingByCode(char code) {
        return switch (code) {
            case '0' -> ChatFormatting.BLACK;
            case '1' -> ChatFormatting.DARK_BLUE;
            case '2' -> ChatFormatting.DARK_GREEN;
            case '3' -> ChatFormatting.DARK_AQUA;
            case '4' -> ChatFormatting.DARK_RED;
            case '5' -> ChatFormatting.DARK_PURPLE;
            case '6' -> ChatFormatting.GOLD;
            case '7' -> ChatFormatting.GRAY;
            case '8' -> ChatFormatting.DARK_GRAY;
            case '9' -> ChatFormatting.BLUE;
            case 'a' -> ChatFormatting.GREEN;
            case 'b' -> ChatFormatting.AQUA;
            case 'c' -> ChatFormatting.RED;
            case 'd' -> ChatFormatting.LIGHT_PURPLE;
            case 'e' -> ChatFormatting.YELLOW;
            case 'f' -> ChatFormatting.WHITE;
            case 'k' -> ChatFormatting.OBFUSCATED;
            case 'l' -> ChatFormatting.BOLD;
            case 'm' -> ChatFormatting.STRIKETHROUGH;
            case 'n' -> ChatFormatting.UNDERLINE;
            case 'o' -> ChatFormatting.ITALIC;
            case 'r' -> ChatFormatting.RESET;
            default -> ChatFormatting.WHITE;
        };
    }
}

