/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.USounds;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.data.Hit;
import com.minelittlepony.unicopia.ability.magic.spell.ChangelingFeedingSpell;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.util.TraceHelper;
import com.minelittlepony.unicopia.util.VecHelper;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1430;
import net.minecraft.class_1452;
import net.minecraft.class_1472;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1924;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3988;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ChangelingFeedAbility
implements Ability<Hit> {
    private static final Predicate<class_1297> TARGET_PREDICATE = e -> e instanceof class_1309 && (e instanceof class_1430 || e instanceof class_3988 || e instanceof class_1657 || e instanceof class_1472 || e instanceof class_1452 || e instanceof class_1588);

    @Override
    public int getWarmupTime(Pony player) {
        return 5;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return !SpellType.FEED.isOn(player) && ChangelingFeedingSpell.canFeed(player) ? 15 : 80;
    }

    @Override
    @Nullable
    public Optional<Hit> prepare(Pony player) {
        return Hit.of(ChangelingFeedingSpell.canFeed(player) && !this.getTargets(player).findAny().isEmpty());
    }

    @Override
    public class_9139<? super class_9129, Hit> getSerializer() {
        return Hit.CODEC;
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 0.0;
    }

    @Override
    public boolean apply(Pony iplayer, Hit data) {
        class_1657 player;
        block6: {
            List<class_1309> targets;
            int maximumFoodGain;
            float maximumHealthGain;
            block5: {
                if (!ChangelingFeedingSpell.canFeed(iplayer)) {
                    return false;
                }
                player = (class_1657)iplayer.asEntity();
                maximumHealthGain = player.method_6063() - player.method_6032();
                int n = maximumFoodGain = player.method_7332(false) ? 20 - player.method_7344().method_7586() : 0;
                if (maximumHealthGain > 0.0f) break block5;
                if (maximumFoodGain <= 0) break block6;
            }
            if ((targets = this.getTargets(iplayer).map(class_1309.class::cast).toList()).size() > 0) {
                new ChangelingFeedingSpell(targets, maximumHealthGain, maximumFoodGain).apply(iplayer);
                iplayer.playSound(USounds.ENTITY_PLAYER_CHANGELING_FEED, 0.1f, iplayer.getRandomPitch());
                return true;
            }
        }
        iplayer.playSound(USounds.Vanilla.field_19149, 1.0f, (float)player.method_37908().field_9229.method_43385(1.0, (double)0.2f));
        return true;
    }

    protected Stream<class_1297> getTargets(Pony player) {
        return Stream.concat(VecHelper.findInRange(player.asEntity(), (class_1924)player.asWorld(), player.getOriginVector(), 3.0, TARGET_PREDICATE).stream(), TraceHelper.findEntity(player.asEntity(), 17.0, 1.0f, TARGET_PREDICATE).stream()).distinct();
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
        player.getMagicalReserves().getExertion().addPercent(6.0f);
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
        if (player.asWorld().field_9229.method_43048(10) == 0) {
            player.spawnParticles((class_2394)class_2398.field_11201, 1);
        }
    }
}

