/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.unicopia.ability;

import com.minelittlepony.unicopia.Race;
import com.minelittlepony.unicopia.ability.Ability;
import com.minelittlepony.unicopia.ability.AbilitySlot;
import com.minelittlepony.unicopia.ability.data.Rot;
import com.minelittlepony.unicopia.ability.magic.spell.CastingMethod;
import com.minelittlepony.unicopia.ability.magic.spell.effect.SpellType;
import com.minelittlepony.unicopia.entity.player.Pony;
import com.minelittlepony.unicopia.server.world.UGameRules;
import java.util.Optional;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class TimeChangeAbility
implements Ability<Rot> {
    @Override
    public boolean canUse(Race.Composite race) {
        return this.canUse(race.physical()) || race.pseudo() == Race.UNICORN;
    }

    @Override
    public int getCooldownTime(Pony player) {
        return 2;
    }

    @Override
    public int getWarmupTime(Pony player) {
        return 20;
    }

    @Override
    public double getCostEstimate(Pony player) {
        return 2.0;
    }

    @Override
    public class_9139<? super class_9129, Rot> getSerializer() {
        return Rot.CODEC;
    }

    @Override
    public Optional<Rot> prepare(Pony player) {
        if (!player.asWorld().method_8450().method_8355(UGameRules.DO_TIME_MAGIC)) {
            return Optional.empty();
        }
        if (!player.subtractEnergyCost(0.0)) {
            return Optional.empty();
        }
        return Optional.of(Rot.of(player));
    }

    @Override
    public boolean apply(Pony player, Rot data) {
        if (!player.asWorld().method_8450().method_8355(UGameRules.DO_TIME_MAGIC)) {
            return false;
        }
        if (!player.getSpellSlot().removeWhere(SpellType.TIME_CONTROL)) {
            SpellType.TIME_CONTROL.withTraits().apply(player, CastingMethod.INNATE).update(player, data.applyTo(player));
        }
        return true;
    }

    @Override
    public void warmUp(Pony player, AbilitySlot slot) {
    }

    @Override
    public void coolDown(Pony player, AbilitySlot slot) {
    }
}

